/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpClientKeyExchangeParser
extends ClientKeyExchangeParser<SrpClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrpClientKeyExchangeParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(SrpClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing SRPClientKeyExchangeMessage");
        this.parsePublicKeyLength(msg);
        this.parsePublicKey(msg);
    }

    @Override
    protected SrpClientKeyExchangeMessage createHandshakeMessage() {
        return new SrpClientKeyExchangeMessage();
    }

    private void parsePublicKeyLength(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("PublicKeyLength: " + msg.getPublicKeyLength().getValue());
    }

    private void parsePublicKey(SrpClientKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("PublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }
}

