/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public class CustomFieldValueReader14
extends CustomFieldValueReader {
    public CustomFieldValueReader14(ProjectProperties projectProperties, CustomFieldContainer customFieldContainer, VarMeta varMeta, Var2Data var2Data, FixedData fixedData, FixedData fixedData2, Props props) {
        super(projectProperties, customFieldContainer, varMeta, var2Data, fixedData, fixedData2, props);
    }

    @Override
    public void process() {
        int n;
        int n2;
        int n3;
        Integer[] integerArray = this.m_outlineCodeVarMeta.getUniqueIdentifierArray();
        if (NumberHelper.getInt(this.m_properties.getApplicationVersion()) > 14) {
            n3 = 16;
            n2 = 18;
            n = 10;
        } else {
            n2 = 16;
            n3 = 32;
            n = 8;
        }
        Map<UUID, FieldType> map = this.populateCustomFieldMap();
        for (int i = 0; i < integerArray.length; ++i) {
            byte[] byArray;
            Integer n4 = integerArray[i];
            CustomFieldValueItem customFieldValueItem = new CustomFieldValueItem(n4);
            byte[] byArray2 = this.m_outlineCodeVarData.getByteArray(n4, VALUE_LIST_VALUE);
            customFieldValueItem.setDescription(this.m_outlineCodeVarData.getUnicodeString(n4, VALUE_LIST_DESCRIPTION));
            customFieldValueItem.setUnknown(this.m_outlineCodeVarData.getByteArray(n4, VALUE_LIST_UNKNOWN));
            byte[] byArray3 = this.m_outlineCodeFixedData.getByteArrayValue(i + 3);
            if (byArray3 != null) {
                customFieldValueItem.setParent(MPPUtility.getShort(byArray3, n));
            }
            if ((byArray = this.m_outlineCodeFixedData2.getByteArrayValue(i + 3)) == null) continue;
            customFieldValueItem.setGuid(MPPUtility.getGUID(byArray, 0));
            UUID uUID = MPPUtility.getGUID(byArray, n2);
            int n5 = MPPUtility.getShort(byArray, n3);
            customFieldValueItem.setValue(this.getTypedValue(n5, byArray2));
            FieldType fieldType = map.get(uUID);
            if (fieldType == null) continue;
            this.m_container.getCustomField(fieldType).getLookupTable().add(customFieldValueItem);
        }
    }

    private Map<UUID, FieldType> populateCustomFieldMap() {
        byte[] byArray = this.m_taskProps.getByteArray(Props.CUSTOM_FIELDS);
        int n = MPPUtility.getInt(byArray, 0);
        int n2 = n + 36;
        HashMap<UUID, FieldType> hashMap = new HashMap<UUID, FieldType>();
        while (n2 + 52 <= byArray.length) {
            int n3 = MPPUtility.getInt(byArray, n2 + 0);
            FieldType fieldType = FieldTypeHelper.getInstance(n3);
            UUID uUID = MPPUtility.getGUID(byArray, n2 + 36);
            hashMap.put(uUID, fieldType);
            n2 += 88;
        }
        return hashMap;
    }
}

