/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.search.SearchPattern;

public final class TextRegexpUtil {
    private static final String wordCharsExpr = "[\\p{javaLetterOrDigit}_]";
    private static final String checkNotAfterWordChar = "(?<![\\p{javaLetterOrDigit}_])";
    private static final String checkNotBeforeWordChar = "(?![\\p{javaLetterOrDigit}_])";
    private static String MULTILINE_REGEXP_PATTERN = ".*(\\\\n|\\\\r|\\\\f|\\\\u|\\\\0|\\\\x|\\\\s|\\(\\?[idmux]*s).*";
    private static final Logger LOG = Logger.getLogger(TextRegexpUtil.class.getName());

    private TextRegexpUtil() {
    }

    private static String makeLiteralRegexp(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(checkNotAfterWordChar);
        }
        stringBuilder.append(Pattern.quote(string));
        if (bl) {
            stringBuilder.append(checkNotBeforeWordChar);
        }
        return stringBuilder.toString();
    }

    private static String makeRegexp(String string, boolean bl) {
        if (string.length() == 0) {
            return string;
        }
        if (!bl && Pattern.matches("[a-zA-Z0-9 ]*", string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        boolean bl4 = true;
        char c = '*';
        for (char c2 : string.toCharArray()) {
            if (bl2 && (c2 == '?' || c2 == '*')) {
                assert (!bl3 && n == 0);
                if (bl && bl4) {
                    stringBuilder.append(checkNotAfterWordChar);
                }
                stringBuilder.append('\\');
                stringBuilder.append(c2);
                c = c2;
                bl4 = false;
                bl2 = false;
                continue;
            }
            if (c2 == '?') {
                assert (!bl2);
                ++n;
                continue;
            }
            if (c2 == '*') {
                assert (!bl2);
                bl3 = true;
                continue;
            }
            if (bl3 || n != 0) {
                if (bl && bl4 && !bl3) {
                    stringBuilder.append(checkNotAfterWordChar);
                }
                bl4 &= !TextRegexpUtil.addMetachars(stringBuilder, bl3, n, bl, !bl4);
                bl3 = false;
                n = 0;
            }
            if (bl2) {
                stringBuilder.append("\\\\");
                bl2 = false;
            }
            if (c2 == '\\') {
                bl2 = true;
                continue;
            }
            if (bl && bl4 && TextRegexpUtil.isWordChar(c2)) {
                stringBuilder.append(checkNotAfterWordChar);
            }
            if (TextRegexpUtil.isSpecialCharacter(c2)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
            c = c2;
            bl4 = false;
        }
        if (bl2) {
            assert (!bl3 && n == 0);
            stringBuilder.append('\\').append('\\');
            c = '\\';
        } else if (bl3 || n != 0) {
            if (bl && !bl3 && bl4) {
                stringBuilder.append(checkNotAfterWordChar);
            }
            bl4 &= !TextRegexpUtil.addMetachars(stringBuilder, bl3, n, bl, false);
            if (bl && !bl3) {
                stringBuilder.append(checkNotBeforeWordChar);
            }
            c = '*';
        }
        if (bl && TextRegexpUtil.isWordChar(c)) {
            stringBuilder.append(checkNotBeforeWordChar);
        }
        return stringBuilder.toString();
    }

    private static Pattern compileSimpleTextPattern(SearchPattern searchPattern) throws PatternSyntaxException {
        String string;
        assert (searchPattern != null);
        assert (searchPattern.getSearchExpression() != null);
        assert (!searchPattern.isRegExp());
        int n = 0;
        if (!searchPattern.isMatchCase()) {
            n |= 2;
            n |= 0x40;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, " - textPatternExpr = \"{0}{1}", new Object[]{searchPattern.getSearchExpression(), Character.valueOf('\"')});
        }
        switch (searchPattern.getMatchType()) {
            case BASIC: {
                string = TextRegexpUtil.makeRegexp(searchPattern.getSearchExpression(), searchPattern.isWholeWords());
                break;
            }
            case LITERAL: {
                string = TextRegexpUtil.makeLiteralRegexp(searchPattern.getSearchExpression(), searchPattern.isWholeWords());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, " - regexp = \"{0}{1}", new Object[]{string, Character.valueOf('\"')});
        }
        return Pattern.compile(string, n);
    }

    private static Pattern compileRegexpPattern(SearchPattern searchPattern) throws PatternSyntaxException {
        assert (searchPattern != null);
        assert (searchPattern.getSearchExpression() != null);
        assert (searchPattern.isRegExp());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, " - textPatternExpr = \"{0}{1}", new Object[]{searchPattern.getSearchExpression(), Character.valueOf('\"')});
        }
        int n = 0;
        if (!searchPattern.isMatchCase()) {
            n |= 2;
            n |= 0x40;
        }
        return Pattern.compile(searchPattern.getSearchExpression(), n |= 8);
    }

    public static Pattern makeTextPattern(SearchPattern searchPattern) throws PatternSyntaxException, NullPointerException {
        if (searchPattern == null) {
            throw new NullPointerException("search pattern is null");
        }
        if (searchPattern.getSearchExpression() == null) {
            throw new NullPointerException("expression is null");
        }
        if (searchPattern.isRegExp()) {
            return TextRegexpUtil.compileRegexpPattern(searchPattern);
        }
        return TextRegexpUtil.compileSimpleTextPattern(searchPattern);
    }

    private static boolean isWordChar(char c) {
        if (c == '*' || c == '\\') {
            return false;
        }
        assert (wordCharsExpr.equals(wordCharsExpr)) : "update implementation of method isWordChar(char)";
        return c == '_' || Character.isLetterOrDigit(c);
    }

    private static boolean addMetachars(StringBuilder stringBuilder, boolean bl, int n, boolean bl2, boolean bl3) {
        assert (bl || n != 0);
        if (bl && !bl2 && !bl3) {
            bl = false;
        }
        if (n == 0 && !bl) {
            return false;
        }
        if (bl2) {
            stringBuilder.append(wordCharsExpr);
        } else {
            stringBuilder.append('.');
        }
        switch (n) {
            case 0: {
                assert (bl);
                stringBuilder.append('*');
                break;
            }
            case 1: {
                if (!bl) break;
                stringBuilder.append('+');
                break;
            }
            default: {
                if (bl2) {
                    stringBuilder.append('{').append(n);
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append('}');
                    break;
                }
                for (int i = 1; i < n; ++i) {
                    stringBuilder.append('.');
                }
                if (!bl) break;
                stringBuilder.append('+');
            }
        }
        if (bl && bl3) {
            stringBuilder.append('?');
        }
        return true;
    }

    private static boolean isSpecialCharacter(char c) {
        return c > ' ' && c < '\u0080' && !TextRegexpUtil.isAlnum(c);
    }

    private static boolean isAlnum(char c) {
        return TextRegexpUtil.isAlpha(c) || TextRegexpUtil.isDigit(c);
    }

    private static boolean isAlpha(char c) {
        return (c = (char)(c | 0x20)) >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isMultilineOrMatchesMultiline(String string) {
        if (string == null) {
            return false;
        }
        return string.contains("\n") || string.contains("\r") || string.matches(MULTILINE_REGEXP_PATTERN);
    }
}

