/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMatcherEditor<E>
extends AbstractMatcherEditor<E> {
    public static final int AND = 42;
    public static final int OR = 24;
    private EventList<MatcherEditor<E>> matcherEditors;
    private int mode = 42;
    private List<DelegateMatcherEditorListener> matcherEditorListeners = new ArrayList<DelegateMatcherEditorListener>();

    public CompositeMatcherEditor(EventList<MatcherEditor<E>> matcherEditors) {
        this.matcherEditors = matcherEditors;
        Iterator i = matcherEditors.iterator();
        while (i.hasNext()) {
            this.matcherEditorListeners.add(new DelegateMatcherEditorListener((MatcherEditor)i.next()));
        }
        matcherEditors.addListEventListener(new MatcherEditorsListListener());
        this.fireChanged(this.rebuildMatcher());
    }

    public CompositeMatcherEditor() {
        this(new BasicEventList<MatcherEditor<E>>());
    }

    public EventList<MatcherEditor<E>> getMatcherEditors() {
        return this.matcherEditors;
    }

    private Matcher<E> rebuildMatcher() {
        Matcher[] matchers = new Matcher[this.matcherEditors.size()];
        int n = this.matcherEditors.size();
        for (int i = 0; i < n; ++i) {
            matchers[i] = ((MatcherEditor)this.matcherEditors.get(i)).getMatcher();
        }
        if (this.mode == 42) {
            return Matchers.and(matchers);
        }
        if (this.mode == 24) {
            return Matchers.or(matchers);
        }
        throw new IllegalStateException();
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        int oldMode = this.mode;
        this.mode = mode;
        if (this.matcherEditors.isEmpty()) {
            return;
        }
        if (oldMode == 42 && mode == 24) {
            this.fireRelaxed(this.rebuildMatcher());
        } else if (oldMode == 24 && mode == 42) {
            this.fireConstrained(this.rebuildMatcher());
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int getMode() {
        return this.mode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegateMatcherEditorListener
    implements MatcherEditor.Listener<E> {
        private MatcherEditor<E> source;

        @Override
        public void changedMatcher(MatcherEditor.Event<E> matcherEvent) {
            switch (matcherEvent.getType()) {
                case 2: {
                    this.constrained();
                    break;
                }
                case 3: {
                    this.relaxed();
                    break;
                }
                case 4: {
                    this.changed();
                    break;
                }
                case 0: {
                    this.matchAll();
                    break;
                }
                case 1: {
                    this.matchNone();
                }
            }
        }

        private DelegateMatcherEditorListener(MatcherEditor<E> source) {
            this.source = source;
            source.addMatcherEditorListener(this);
        }

        private void matchAll() {
            if (CompositeMatcherEditor.this.matcherEditors.size() == 1) {
                CompositeMatcherEditor.this.fireMatchAll();
            } else {
                CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
            }
        }

        private void matchNone() {
            if (CompositeMatcherEditor.this.matcherEditors.size() == 1) {
                CompositeMatcherEditor.this.fireMatchNone();
            } else {
                CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
            }
        }

        private void changed() {
            CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
        }

        private void constrained() {
            CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
        }

        private void relaxed() {
            CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
        }

        public void setMatcherEditor(MatcherEditor<E> source) {
            if (this.source == source) {
                return;
            }
            this.stopListening();
            this.source = source;
            source.addMatcherEditorListener(this);
        }

        public void stopListening() {
            this.source.removeMatcherEditorListener(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatcherEditorsListListener
    implements ListEventListener<MatcherEditor<E>> {
        private MatcherEditorsListListener() {
        }

        @Override
        public void listChanged(ListEvent<MatcherEditor<E>> listChanges) {
            boolean inserts = false;
            boolean deletes = false;
            boolean wasEmpty = CompositeMatcherEditor.this.matcherEditorListeners.isEmpty();
            while (listChanges.next()) {
                int index = listChanges.getIndex();
                int type = listChanges.getType();
                if (type == 2) {
                    MatcherEditor inserted = (MatcherEditor)CompositeMatcherEditor.this.matcherEditors.get(index);
                    CompositeMatcherEditor.this.matcherEditorListeners.add(new DelegateMatcherEditorListener(inserted));
                    inserts = true;
                    continue;
                }
                if (type == 0) {
                    DelegateMatcherEditorListener listener = (DelegateMatcherEditorListener)CompositeMatcherEditor.this.matcherEditorListeners.remove(index);
                    listener.stopListening();
                    deletes = true;
                    continue;
                }
                if (type != 1) continue;
                MatcherEditor updated = (MatcherEditor)CompositeMatcherEditor.this.matcherEditors.get(index);
                DelegateMatcherEditorListener listener = (DelegateMatcherEditorListener)CompositeMatcherEditor.this.matcherEditorListeners.get(index);
                listener.setMatcherEditor(updated);
                inserts = true;
                deletes = true;
            }
            boolean isEmpty = CompositeMatcherEditor.this.matcherEditorListeners.isEmpty();
            if (CompositeMatcherEditor.this.mode == 42) {
                if (inserts && deletes) {
                    CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (inserts) {
                    CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (deletes) {
                    if (isEmpty) {
                        CompositeMatcherEditor.this.fireMatchAll();
                    } else {
                        CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                }
            } else if (CompositeMatcherEditor.this.mode == 24) {
                if (inserts && deletes) {
                    CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (inserts) {
                    if (wasEmpty) {
                        CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                    } else {
                        CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                } else if (deletes) {
                    if (isEmpty) {
                        CompositeMatcherEditor.this.fireMatchAll();
                    } else {
                        CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

