/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(22u, 23u, 4u) << 0u) => uvec3(22u, 23u, 4u)
 * (uvec3(22u, 23u, 4u) << 1u) => uvec3(44u, 46u, 8u)
 * (uvec3(22u, 23u, 4u) << 2u) => uvec3(88u, 92u, 16u)
 * (uvec3(22u, 23u, 4u) << 5u) => uvec3(704u, 736u, 128u)
 * (uvec3(22u, 23u, 4u) << 25u) => uvec3(738197504u, 771751936u, 134217728u)
 * (uvec3(22u, 23u, 4u) << 31u) => uvec3(0u, 2147483648u, 0u)
 * (uvec3(19u, 1u, 13u) << 0u) => uvec3(19u, 1u, 13u)
 * (uvec3(19u, 1u, 13u) << 1u) => uvec3(38u, 2u, 26u)
 * (uvec3(19u, 1u, 13u) << 2u) => uvec3(76u, 4u, 52u)
 * (uvec3(19u, 1u, 13u) << 5u) => uvec3(608u, 32u, 416u)
 * (uvec3(19u, 1u, 13u) << 25u) => uvec3(637534208u, 33554432u, 436207616u)
 * (uvec3(19u, 1u, 13u) << 31u) => uvec3(2147483648u, 2147483648u, 2147483648u)
 */
#version 150

void main()
{
  float[all(equal((uvec3(22u, 23u, 4u) << 0u), uvec3(22u, 23u, 4u))) ? 1 : -1] array0;
  float[all(equal((uvec3(22u, 23u, 4u) << 1u), uvec3(44u, 46u, 8u))) ? 1 : -1] array1;
  float[all(equal((uvec3(22u, 23u, 4u) << 2u), uvec3(88u, 92u, 16u))) ? 1 : -1] array2;
  float[all(equal((uvec3(22u, 23u, 4u) << 5u), uvec3(704u, 736u, 128u))) ? 1 : -1] array3;
  float[all(equal((uvec3(22u, 23u, 4u) << 25u), uvec3(738197504u, 771751936u, 134217728u))) ? 1 : -1] array4;
  float[all(equal((uvec3(22u, 23u, 4u) << 31u), uvec3(0u, 2147483648u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec3(19u, 1u, 13u) << 0u), uvec3(19u, 1u, 13u))) ? 1 : -1] array6;
  float[all(equal((uvec3(19u, 1u, 13u) << 1u), uvec3(38u, 2u, 26u))) ? 1 : -1] array7;
  float[all(equal((uvec3(19u, 1u, 13u) << 2u), uvec3(76u, 4u, 52u))) ? 1 : -1] array8;
  float[all(equal((uvec3(19u, 1u, 13u) << 5u), uvec3(608u, 32u, 416u))) ? 1 : -1] array9;
  float[all(equal((uvec3(19u, 1u, 13u) << 25u), uvec3(637534208u, 33554432u, 436207616u))) ? 1 : -1] array10;
  float[all(equal((uvec3(19u, 1u, 13u) << 31u), uvec3(2147483648u, 2147483648u, 2147483648u))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
