/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.VectorSimilarityValuesSource;

class ByteVectorSimilarityValuesSource
extends VectorSimilarityValuesSource {
    private final byte[] queryVector;

    public ByteVectorSimilarityValuesSource(byte[] vector, String fieldName) {
        super(fieldName);
        this.queryVector = vector;
    }

    @Override
    public VectorScorer getScorer(LeafReaderContext ctx) throws IOException {
        ByteVectorValues vectorValues = ctx.reader().getByteVectorValues(this.fieldName);
        if (vectorValues == null) {
            ByteVectorValues.checkField(ctx.reader(), this.fieldName);
            return null;
        }
        return vectorValues.scorer(this.queryVector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fieldName, Arrays.hashCode(this.queryVector));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteVectorSimilarityValuesSource other = (ByteVectorSimilarityValuesSource)obj;
        return Objects.equals(this.fieldName, other.fieldName) && Arrays.equals(this.queryVector, other.queryVector);
    }

    @Override
    public String toString() {
        return "ByteVectorSimilarityValuesSource(fieldName=" + this.fieldName + " queryVector=" + Arrays.toString(this.queryVector) + ")";
    }
}

