/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Objects;
import org.apache.lucene.search.Query;

public final class BooleanClause {
    private final Query query;
    private final Occur occur;

    public BooleanClause(Query query, Occur occur) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
        this.occur = Objects.requireNonNull(occur, "Occur must not be null");
    }

    public Occur getOccur() {
        return this.occur;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isProhibited() {
        return Occur.MUST_NOT == this.occur;
    }

    public boolean isRequired() {
        return this.occur == Occur.MUST || this.occur == Occur.FILTER;
    }

    public boolean isScoring() {
        return this.occur == Occur.MUST || this.occur == Occur.SHOULD;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BooleanClause)) {
            return false;
        }
        BooleanClause other = (BooleanClause)o;
        return this.query.equals(other.query) && this.occur == other.occur;
    }

    public int hashCode() {
        return 31 * this.query.hashCode() + this.occur.hashCode();
    }

    public String toString() {
        return this.occur.toString() + this.query.toString();
    }

    public static enum Occur {
        MUST{

            public String toString() {
                return "+";
            }
        }
        ,
        FILTER{

            public String toString() {
                return "#";
            }
        }
        ,
        SHOULD{

            public String toString() {
                return "";
            }
        }
        ,
        MUST_NOT{

            public String toString() {
                return "-";
            }
        };

    }
}

