/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.TokenFilterFactory;

public class NGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int minGram;
    private final int maxGram;
    private final boolean preserveOriginal;
    private static final String PRESERVE_ORIG_KEY = "preserve_original";

    NGramTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        int maxAllowedNgramDiff = indexSettings.getMaxNgramDiff();
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        int ngramDiff = this.maxGram - this.minGram;
        if (ngramDiff > maxAllowedNgramDiff) {
            if (indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
                throw new IllegalArgumentException("The difference between max_gram and min_gram in NGram Tokenizer must be less than or equal to: [" + maxAllowedNgramDiff + "] but was [" + ngramDiff + "]. This limit can be set by changing the [" + IndexSettings.MAX_NGRAM_DIFF_SETTING.getKey() + "] index level setting.");
            }
            this.deprecationLogger.deprecate("ngram_big_difference", "Deprecated big difference between max_gram and min_gram in NGram Tokenizer,expected difference must be less than or equal to: [" + maxAllowedNgramDiff + "]", new Object[0]);
        }
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIG_KEY, Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new NGramTokenFilter(tokenStream, this.minGram, this.maxGram, this.preserveOriginal);
    }

    public TokenFilterFactory getSynonymFilter() {
        throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
    }
}

