/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhGenerateAndWrapKeyMaterial;
import EcdhEdkWrapping_Compile.EcdhWrapInfo;
import EcdhEdkWrapping_Compile.EcdhWrapKeyMaterial;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import RawECDHKeyring_Compile.DecryptSingleEncryptedDataKey;
import RawECDHKeyring_Compile.OnDecryptEcdhDataKeyFilter;
import RawECDHKeyring_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairOutput;

public class RawEcdhKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public RawEcdhStaticConfigurations _keyAgreementScheme = RawEcdhStaticConfigurations.Default();
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public ECCPublicKey _recipientPublicKey = ECCPublicKey.Default();
    public DafnySequence<? extends Byte> _compressedRecipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public ECCPublicKey _senderPublicKey = ECCPublicKey.Default();
    public ECCPrivateKey _senderPrivateKey = ECCPrivateKey.Default();
    public DafnySequence<? extends Byte> _compressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<RawEcdhKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawEcdhKeyring.class, () -> null);

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out8 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out8;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out8 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out8;
    }

    public void __ctor(RawEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec, Option<DafnySequence<? extends Byte>> senderPrivateKey, Option<DafnySequence<? extends Byte>> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, Option<DafnySequence<? extends Byte>> compressedSenderPublicKey, DafnySequence<? extends Byte> compressedRecipientPublicKey, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyAgreementScheme = keyAgreementScheme;
        this._curveSpec = curveSpec;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = ECCPublicKey.create(recipientPublicKey);
        this._compressedRecipientPublicKey = compressedRecipientPublicKey;
        if (senderPublicKey.is_Some() && senderPrivateKey.is_Some() && compressedSenderPublicKey.is_Some()) {
            this._senderPublicKey = ECCPublicKey.create(senderPublicKey.dtor_value());
            this._senderPrivateKey = ECCPrivateKey.create(senderPrivateKey.dtor_value());
            this._compressedSenderPublicKey = compressedSenderPublicKey.dtor_value();
        } else {
            this._senderPublicKey = ECCPublicKey.create((DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
            this._senderPrivateKey = ECCPrivateKey.create((DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
            this._compressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        }
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        if (this.keyAgreementScheme().is_PublicKeyDiscovery()) {
            res = Result.create_Failure(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"PublicKeyDiscovery Key Agreement Scheme is forbidden on encrypt.")));
            return res;
        }
        ECCPrivateKey _0_operationSenderPrivateKey = ECCPrivateKey.Default();
        ECCPublicKey _1_operationSenderPublicKey = ECCPublicKey.Default();
        DafnySequence _2_operationCompressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        if (this.keyAgreementScheme().is_EphemeralPrivateKeyToStaticPublicKey()) {
            DafnySequence _6_operationCompressedSenderPublicKey_q;
            Result<GenerateECCKeyPairOutput, Error> _3_valueOrError0 = Result.Default(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor(), GenerateECCKeyPairOutput.Default());
            Result<GenerateECCKeyPairOutput, Error> _out0 = __default.GenerateEphemeralEccKeyPair(this.curveSpec(), this.cryptoPrimitives());
            _3_valueOrError0 = _out0;
            if (_3_valueOrError0.IsFailure(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor())) {
                res = _3_valueOrError0.PropagateFailure(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            GenerateECCKeyPairOutput _4_ephemeralKeyPair = _3_valueOrError0.Extract(GenerateECCKeyPairOutput._typeDescriptor(), Error._typeDescriptor());
            _0_operationSenderPrivateKey = _4_ephemeralKeyPair.dtor_privateKey();
            _1_operationSenderPublicKey = _4_ephemeralKeyPair.dtor_publicKey();
            Result<DafnySequence, Error> _5_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
            Result<DafnySequence<? extends Byte>, Error> _out1 = __default.CompressPublicKey(ECCPublicKey.create(_1_operationSenderPublicKey.dtor_der()), this.curveSpec(), this.cryptoPrimitives());
            _5_valueOrError1 = _out1;
            if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                res = _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _2_operationCompressedSenderPublicKey = _6_operationCompressedSenderPublicKey_q = _5_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        } else {
            _0_operationSenderPrivateKey = this.senderPrivateKey();
            _1_operationSenderPublicKey = this.senderPublicKey();
            _2_operationCompressedSenderPublicKey = this.compressedSenderPublicKey();
        }
        EncryptionMaterials _7_materials = input.dtor_materials();
        AlgorithmSuiteInfo _8_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<DafnySequence, Error> _9_valueOrError2 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out2 = __default.LocalDeriveSharedSecret(_0_operationSenderPrivateKey, this.recipientPublicKey(), this.curveSpec(), this.cryptoPrimitives());
        _9_valueOrError2 = _out2;
        if (_9_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _9_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _10_sharedSecret = _9_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<DafnySequence<? extends Byte>, Error> _11_valueOrError3 = Result.Default(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), ValidUTF8Bytes.defaultValue());
        _11_valueOrError3 = UTF8.__default.Encode(__default.CurveSpecTypeToString(this.curveSpec())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::E);
        if (_11_valueOrError3.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _11_valueOrError3.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _12_curveSpecUtf8 = _11_valueOrError3.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Result<DafnySequence, Error> _13_valueOrError4 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _13_valueOrError4 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_13_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _13_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _14_canonicalizedEC = _13_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Byte> _15_fixedInfo = EcdhEdkWrapping_Compile.__default.SerializeFixedInfo(Constants_Compile.__default.ECDH__KDF__UTF8(), _12_curveSpecUtf8, (DafnySequence<? extends Byte>)_2_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey(), (DafnySequence<? extends Byte>)_14_canonicalizedEC, __default.RAW__ECDH__KEYRING__VERSION());
        EcdhGenerateAndWrapKeyMaterial _nw0 = new EcdhGenerateAndWrapKeyMaterial();
        _nw0.__ctor((DafnySequence<? extends Byte>)_10_sharedSecret, _15_fixedInfo, this.cryptoPrimitives());
        EcdhGenerateAndWrapKeyMaterial _16_ecdhGenerateAndWrap = _nw0;
        EcdhWrapKeyMaterial _nw1 = new EcdhWrapKeyMaterial();
        _nw1.__ctor((DafnySequence<? extends Byte>)_10_sharedSecret, _15_fixedInfo, this.cryptoPrimitives());
        EcdhWrapKeyMaterial _17_ecdhWrap = _nw1;
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Error> _18_valueOrError5 = Result.Default(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor(), WrapEdkMaterialOutput.Default(EcdhWrapInfo._typeDescriptor(), EcdhWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<EcdhWrapInfo>, Error> _out3 = EdkWrapping_Compile.__default.WrapEdkMaterial(EcdhWrapInfo._typeDescriptor(), _7_materials, _17_ecdhWrap, _16_ecdhGenerateAndWrap);
        _18_valueOrError5 = _out3;
        if (_18_valueOrError5.IsFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _18_valueOrError5.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<EcdhWrapInfo> _19_wrapOutput = _18_valueOrError5.Extract(WrapEdkMaterialOutput._typeDescriptor(EcdhWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<Object> _20_symmetricSigningKeyList = _19_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_19_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())));
        Outcome<Error> _21_valueOrError6 = Outcome.Default(Error._typeDescriptor());
        _21_valueOrError6 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidCompressedPublicKeyLength((DafnySequence<? extends Byte>)_2_operationCompressedSenderPublicKey) && __default.ValidCompressedPublicKeyLength(this.compressedRecipientPublicKey()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid compressed public key length.")));
        if (_21_valueOrError6.IsFailure(Error._typeDescriptor())) {
            res = _21_valueOrError6.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _22_edk = EncryptedDataKey.create(Constants_Compile.__default.RAW__ECDH__PROVIDER__ID(), __default.SerializeProviderInfo((DafnySequence<? extends Byte>)_2_operationCompressedSenderPublicKey, this.compressedRecipientPublicKey()), _19_wrapOutput.dtor_wrappedMaterial());
        if (_19_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _23_valueOrError7 = null;
            _23_valueOrError7 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_7_materials, _19_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_22_edk}), _20_symmetricSigningKeyList);
            if (_23_valueOrError7.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _23_valueOrError7.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _24_result = _23_valueOrError7.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_24_result));
            return res;
        }
        if (_19_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _25_valueOrError8 = null;
            _25_valueOrError8 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_7_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_22_edk}), _20_symmetricSigningKeyList);
            if (_25_valueOrError8.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _25_valueOrError8.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _26_result = _25_valueOrError8.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput.create(_26_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out1;
        Result<OnDecryptOutput, Error> res = null;
        if (this.keyAgreementScheme().is_EphemeralPrivateKeyToStaticPublicKey()) {
            res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"EphemeralPrivateKeyToStaticPublicKey Key Agreement Scheme is forbidden on decrypt.")));
            return res;
        }
        DecryptionMaterials _0_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Error> _2_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_0_materials), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_2_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _2_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        Option<Object> _3_operationCompressedSenderPublicKey = this.compressedSenderPublicKey().equals((Object)DafnySequence.empty(uint8._typeDescriptor())) ? Option.create_None(DafnySequence._typeDescriptor(uint8._typeDescriptor())) : Option.create_Some(DafnySequence._typeDescriptor(uint8._typeDescriptor()), this.compressedSenderPublicKey());
        OnDecryptEcdhDataKeyFilter _nw0 = new OnDecryptEcdhDataKeyFilter();
        _nw0.__ctor(this.keyAgreementScheme(), this.compressedRecipientPublicKey(), _3_operationCompressedSenderPublicKey);
        OnDecryptEcdhDataKeyFilter _4_filter = _nw0;
        Result<DafnySequence, Error> _5_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out0 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _4_filter, input.dtor_encryptedDataKeys());
        _5_valueOrError1 = _out0;
        if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _6_edksToAttempt = _5_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_6_edksToAttempt.length()).signum() == 0) {
            Result<DafnySequence, Error> _7_valueOrError2 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _7_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_7_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _7_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _8_errorMessage = _7_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), __default.E((DafnySequence<? extends Character>)_8_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw1 = new DecryptSingleEncryptedDataKey();
        _nw1.__ctor(_0_materials, this.cryptoPrimitives(), this.compressedSenderPublicKey(), this.compressedRecipientPublicKey(), this.keyAgreementScheme(), this.curveSpec());
        DecryptSingleEncryptedDataKey _9_decryptClosure = _nw1;
        Result<DecryptionMaterials, DafnySequence<Error>> _10_outcome = _out1 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _9_decryptClosure, _6_edksToAttempt);
        Result<DecryptionMaterials, Error> _11_valueOrError3 = null;
        _11_valueOrError3 = _10_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _12_errors_boxed0 -> {
            DafnySequence _12_errors = _12_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_12_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_11_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _11_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _13_SealedDecryptionMaterials = _11_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput.create(_13_SealedDecryptionMaterials));
        return res;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public RawEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public ECCPublicKey recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public DafnySequence<? extends Byte> compressedRecipientPublicKey() {
        return this._compressedRecipientPublicKey;
    }

    public ECCPublicKey senderPublicKey() {
        return this._senderPublicKey;
    }

    public ECCPrivateKey senderPrivateKey() {
        return this._senderPrivateKey;
    }

    public DafnySequence<? extends Byte> compressedSenderPublicKey() {
        return this._compressedSenderPublicKey;
    }

    public static TypeDescriptor<RawEcdhKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawECDHKeyring.RawEcdhKeyring";
    }
}

