/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsRsaKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsArnParsing_Compile.AwsKmsIdentifierString;
import AwsKmsRsaKeyring_Compile.KmsRsaUnwrapInfo;
import BoundedInts_Compile.uint8;
import MaterialWrapping_Compile.UnwrapInput;
import MaterialWrapping_Compile.UnwrapMaterial;
import MaterialWrapping_Compile.UnwrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenList;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.RecipientInfo;

public class KmsRsaUnwrapKeyMaterial
implements UnwrapMaterial<KmsRsaUnwrapInfo>,
ActionWithResult<UnwrapInput, UnwrapOutput<KmsRsaUnwrapInfo>, Error>,
Action<UnwrapInput, Result<UnwrapOutput<KmsRsaUnwrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public EncryptionAlgorithmSpec _paddingScheme = EncryptionAlgorithmSpec.Default();
    public DafnySequence<? extends Byte> _encryptionContextDigest = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<KmsRsaUnwrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsRsaUnwrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, EncryptionAlgorithmSpec paddingScheme, DafnySequence<? extends Byte> encryptionContextDigest, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._paddingScheme = paddingScheme;
        this._encryptionContextDigest = encryptionContextDigest;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<UnwrapOutput<KmsRsaUnwrapInfo>, Error> Invoke(UnwrapInput input) {
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out0;
        Result<UnwrapOutput<KmsRsaUnwrapInfo>, Error> res = Result.Default(UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), UnwrapOutput.Default(KmsRsaUnwrapInfo._typeDescriptor(), KmsRsaUnwrapInfo.Default()));
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(input.dtor_wrappedMaterial()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Ciphertext length invalid")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        DecryptRequest _1_decryptRequest = DecryptRequest.create(input.dtor_wrappedMaterial(), Option.create_None(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))), Option.create_Some(GrantTokenList._typeDescriptor(), this.grantTokens()), Option.create_Some(AwsKmsIdentifierString._typeDescriptor(), this.awsKmsKey()), Option.create_Some(EncryptionAlgorithmSpec._typeDescriptor(), this.paddingScheme()), Option.create_None(RecipientInfo._typeDescriptor()), Option.create_None(TypeDescriptor.BOOLEAN));
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _2_maybeDecryptResponse = _out0 = this.client().Decrypt(_1_decryptRequest);
        Result<DecryptResponse, Error> _3_valueOrError1 = Result.Default(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), DecryptResponse.Default());
        _3_valueOrError1 = _2_maybeDecryptResponse.MapFailure(DecryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _4_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _4_e = _4_e_boxed0;
            return Error.create_ComAmazonawsKms(_4_e);
        });
        if (_3_valueOrError1.IsFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _3_valueOrError1.PropagateFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        DecryptResponse _5_decryptResponse = _3_valueOrError1.Extract(DecryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _6_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError2 = __default.Need(Error._typeDescriptor(), _5_decryptResponse.dtor_KeyId().is_Some() && _5_decryptResponse.dtor_KeyId().dtor_value().equals(this.awsKmsKey()) && _5_decryptResponse.dtor_Plaintext().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS Decrypt")));
        if (_6_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _6_valueOrError2.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Error> _7_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _7_valueOrError3 = __default.Need(Error._typeDescriptor(), this.encryptionContextDigest().isPrefixOf(_5_decryptResponse.dtor_Plaintext().dtor_value()) && Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(input.dtor_algorithmSuite())).add(BigInteger.valueOf(this.encryptionContextDigest().length())), BigInteger.valueOf(_5_decryptResponse.dtor_Plaintext().dtor_value().length())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context digest does not match expected value.")));
        if (_7_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _7_valueOrError3.PropagateFailure(Error._typeDescriptor(), UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()));
            return res;
        }
        UnwrapOutput<KmsRsaUnwrapInfo> _8_output = UnwrapOutput.create(KmsRsaUnwrapInfo._typeDescriptor(), (DafnySequence<? extends Byte>)_5_decryptResponse.dtor_Plaintext().dtor_value().drop(BigInteger.valueOf(this.encryptionContextDigest().length())), KmsRsaUnwrapInfo.create());
        res = Result.create_Success(UnwrapOutput._typeDescriptor(KmsRsaUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), _8_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public EncryptionAlgorithmSpec paddingScheme() {
        return this._paddingScheme;
    }

    public DafnySequence<? extends Byte> encryptionContextDigest() {
        return this._encryptionContextDigest;
    }

    public static TypeDescriptor<KmsRsaUnwrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsRsaKeyring.KmsRsaUnwrapKeyMaterial";
    }
}

