/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.intel.qat.QatZipper;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.opensearch.index.codec.customcodecs.Lucene912QatCodec;
import org.opensearch.index.codec.customcodecs.QatCompressionMode;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99QatCodec;

public class Lucene912QatStoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene912QatStoredFieldsFormat.class.getSimpleName() + ".mode";
    private static final int QAT_DEFLATE_BLOCK_LENGTH = 491520;
    private static final int QAT_DEFLATE_MAX_DOCS_PER_BLOCK = 4096;
    private static final int QAT_DEFLATE_BLOCK_SHIFT = 10;
    private static final int QAT_LZ4_BLOCK_LENGTH = 81920;
    private static final int QAT_LZ4_MAX_DOCS_PER_BLOCK = 4096;
    private static final int QAT_LZ4_BLOCK_SHIFT = 10;
    private final QatCompressionMode qatCompressionMode;
    private final Lucene912QatCodec.Mode mode;

    public Lucene912QatStoredFieldsFormat() {
        this(Lucene912QatCodec.DEFAULT_COMPRESSION_MODE, Lucene99QatCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene912QatStoredFieldsFormat(Lucene912QatCodec.Mode mode) {
        this(mode, Lucene99QatCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene912QatStoredFieldsFormat(Lucene912QatCodec.Mode mode, int compressionLevel) {
        this(mode, compressionLevel, () -> Lucene99QatCodec.DEFAULT_QAT_MODE);
    }

    public Lucene912QatStoredFieldsFormat(Lucene912QatCodec.Mode mode, Supplier<QatZipper.Mode> supplier) {
        this(mode, Lucene99QatCodec.DEFAULT_COMPRESSION_LEVEL, supplier);
    }

    public Lucene912QatStoredFieldsFormat(Lucene912QatCodec.Mode mode, int compressionLevel, Supplier<QatZipper.Mode> supplier) {
        this.mode = Objects.requireNonNull(mode);
        this.qatCompressionMode = new QatCompressionMode(Lucene912QatStoredFieldsFormat.getAlgorithm(mode), compressionLevel, supplier);
    }

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        if (si.getAttribute(MODE_KEY) != null) {
            String value = si.getAttribute(MODE_KEY);
            Lucene912QatCodec.Mode mode = Lucene912QatCodec.Mode.valueOf(value);
            return this.impl(mode).fieldsReader(directory, si, fn, context);
        }
        throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        String previous = si.putAttribute(MODE_KEY, this.mode.name());
        if (previous != null && !previous.equals(this.mode.name())) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + si.name + " old = " + previous + ", new = " + this.mode.name());
        }
        return this.impl(this.mode).fieldsWriter(directory, si, context);
    }

    private StoredFieldsFormat impl(Lucene912QatCodec.Mode mode) {
        switch (mode) {
            case QAT_LZ4: {
                return this.getQatCompressingStoredFieldsFormat("QatStoredFieldsLz4", this.qatCompressionMode, 81920, 4096, 10);
            }
            case QAT_DEFLATE: {
                return this.getQatCompressingStoredFieldsFormat("QatStoredFieldsDeflate", this.qatCompressionMode, 491520, 4096, 10);
            }
        }
        throw new IllegalStateException("Unsupported compression mode: " + String.valueOf((Object)mode));
    }

    private StoredFieldsFormat getQatCompressingStoredFieldsFormat(String formatName, CompressionMode compressionMode, int blockSize, int maxDocs, int blockShift) {
        return new Lucene90CompressingStoredFieldsFormat(formatName, compressionMode, blockSize, maxDocs, blockShift);
    }

    public Lucene912QatCodec.Mode getMode() {
        return this.mode;
    }

    public QatCompressionMode getCompressionMode() {
        return this.qatCompressionMode;
    }

    private static QatZipper.Algorithm getAlgorithm(Lucene912QatCodec.Mode mode) {
        return mode == Lucene912QatCodec.Mode.QAT_LZ4 ? QatZipper.Algorithm.LZ4 : QatZipper.Algorithm.DEFLATE;
    }
}

