/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.transport.model_group.MLModelGroupGetAction;
import org.opensearch.ml.common.transport.model_group.MLModelGroupGetRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetModelGroupAction
extends BaseRestHandler {
    private static final String ML_GET_MODEL_GROUP_ACTION = "ml_get_model_group_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetModelGroupAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_MODEL_GROUP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/model_groups/{%s}", "/_plugins/_ml", "model_group_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLModelGroupGetRequest mlModelGroupGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLModelGroupGetAction.INSTANCE, (ActionRequest)mlModelGroupGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLModelGroupGetRequest getRequest(RestRequest request) throws IOException {
        String modelGroupId = RestActionUtils.getParameterId(request, "model_group_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        return new MLModelGroupGetRequest(modelGroupId, tenantId);
    }
}

