/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.handler.MLSearchHandler;
import org.opensearch.ml.common.transport.search.MLSearchActionRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchModelTransportAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchModelTransportAction.class);
    private final MLSearchHandler mlSearchHandler;
    private final SdkClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public SearchModelTransportAction(TransportService transportService, ActionFilters actionFilters, SdkClient sdkClient, MLSearchHandler mlSearchHandler, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/models/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.sdkClient = sdkClient;
        this.mlSearchHandler = mlSearchHandler;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest request, ActionListener<SearchResponse> actionListener) {
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        this.mlSearchHandler.search(this.sdkClient, (SearchRequest)request, tenantId, actionListener);
    }
}

