/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.pit.PointInTimeHandler;

public abstract class ElasticHitsExecutor {
    protected static final Logger LOG = LogManager.getLogger();
    protected PointInTimeHandler pit;
    protected Client client;

    protected abstract void run() throws IOException, SqlParseException;

    protected abstract SearchHits getHits();

    public SearchResponse getResponseWithHits(SearchRequestBuilder request, Select select, int size, SearchResponse previousResponse, PointInTimeHandler pit) {
        SearchResponse responseWithHits;
        request.setSize(size);
        if (((Boolean)LocalClusterState.state().getSettingValue(Settings.Key.SQL_PAGINATION_API_SEARCH_AFTER)).booleanValue()) {
            boolean ordered = select.isOrderdSelect();
            if (!ordered) {
                request.addSort("_doc", SortOrder.ASC);
            }
            request.setPointInTime(new PointInTimeBuilder(pit.getPitId()));
            if (previousResponse != null && select.getFrom().isEmpty()) {
                request.searchAfter((Object[])previousResponse.getHits().getSortFields());
            }
            responseWithHits = (SearchResponse)request.get();
        } else {
            TimeValue keepAlive = (TimeValue)LocalClusterState.state().getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE);
            if (previousResponse != null) {
                responseWithHits = (SearchResponse)this.client.prepareSearchScroll(previousResponse.getScrollId()).setScroll(keepAlive).execute().actionGet();
            } else {
                request.setScroll(keepAlive);
                responseWithHits = (SearchResponse)request.get();
            }
        }
        return responseWithHits;
    }
}

