/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.opensearch.search.aggregations.pipeline.InternalBucketMetricValue;

public class MaxBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private List<String> maxBucketKeys;
    private double maxValue;

    MaxBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, formatter, metadata);
    }

    public MaxBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "max_bucket";
    }

    @Override
    protected void preCollection() {
        this.maxBucketKeys = new ArrayList<String>();
        this.maxValue = Double.NEGATIVE_INFINITY;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        if (bucketValue > this.maxValue) {
            this.maxBucketKeys.clear();
            this.maxBucketKeys.add(bucketKey);
            this.maxValue = bucketValue;
        } else if (bucketValue.equals(this.maxValue)) {
            this.maxBucketKeys.add(bucketKey);
        }
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        String[] keys = this.maxBucketKeys.toArray(new String[0]);
        return new InternalBucketMetricValue(this.name(), keys, this.maxValue, this.format, this.metadata());
    }
}

