/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;

class MaxAggregator
extends NumericMetricsAggregator.SingleValue
implements StarTreePreComputeCollector {
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat formatter;
    final String pointField;
    final Function<byte[], Number> pointConverter;
    DoubleArray maxes;

    MaxAggregator(String name, ValuesSourceConfig config, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        ValuesSource.Numeric numeric = this.valuesSource = config.hasValues() ? (ValuesSource.Numeric)config.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.maxes = context.bigArrays().newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        this.formatter = config.format();
        this.pointConverter = this.pointReaderIfAvailable(config);
        this.pointField = this.pointConverter != null ? config.fieldContext().field() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        if (this.valuesSource == null) {
            return false;
        }
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext());
        if (supportedStarTree != null) {
            if (this.parent != null && this.subAggregators.length == 0) {
                return true;
            }
            this.precomputeLeafUsingStarTree(ctx, supportedStarTree);
            return true;
        }
        return false;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        Number segMax;
        if (this.valuesSource == null) {
            if (this.parent != null) {
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            throw new CollectionTerminatedException();
        }
        if (this.pointConverter != null && (segMax = MaxAggregator.findLeafMaxValue(ctx.reader(), this.pointField, this.pointConverter)) != null) {
            assert (this.maxes.size() == 1L);
            double max = this.maxes.get(0L);
            max = Math.max(max, segMax.doubleValue());
            this.maxes.set(0L, max);
            throw new CollectionTerminatedException();
        }
        final BigArrays bigArrays = this.context.bigArrays();
        SortedNumericDoubleValues allValues = this.valuesSource.doubleValues(ctx);
        final NumericDoubleValues values = MultiValueMode.MAX.select(allValues);
        return new LeafBucketCollectorBase(sub, allValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= MaxAggregator.this.maxes.size()) {
                    long from = MaxAggregator.this.maxes.size();
                    MaxAggregator.this.maxes = bigArrays.grow(MaxAggregator.this.maxes, bucket + 1L);
                    MaxAggregator.this.maxes.fill(from, MaxAggregator.this.maxes.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    double value = values.doubleValue();
                    double max = MaxAggregator.this.maxes.get(bucket);
                    max = Math.max(max, value);
                    MaxAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    private void precomputeLeafUsingStarTree(LeafReaderContext ctx, CompositeIndexFieldInfo starTree) throws IOException {
        AtomicReference<Double> max = new AtomicReference<Double>(this.maxes.get(0L));
        StarTreeQueryHelper.precomputeLeafUsingStarTree(this.context, this.valuesSource, ctx, starTree, MetricStat.MAX.getTypeName(), value -> max.set(Math.max((Double)max.get(), NumericUtils.sortableLongToDouble((long)value))), () -> this.maxes.set(0L, (Double)max.get()));
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.maxes.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.maxes.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.maxes.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMax(this.name, this.maxes.get(bucket), this.formatter, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMax(this.name, Double.NEGATIVE_INFINITY, this.formatter, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.maxes);
    }

    static Number findLeafMaxValue(LeafReader reader, String fieldName, Function<byte[], Number> converter) throws IOException {
        PointValues pointValues = reader.getPointValues(fieldName);
        if (pointValues == null) {
            return null;
        }
        final Bits liveDocs = reader.getLiveDocs();
        if (liveDocs == null) {
            return converter.apply(pointValues.getMaxPackedValue());
        }
        final int numBytes = pointValues.getBytesPerDimension();
        final byte[] maxValue = pointValues.getMaxPackedValue();
        final byte[][] result = new byte[1][];
        pointValues.intersect(new PointValues.IntersectVisitor(){

            public void visit(int docID) {
                throw new UnsupportedOperationException();
            }

            public void visit(int docID, byte[] packedValue) {
                if (liveDocs.get(docID)) {
                    if (result[0] == null) {
                        result[0] = new byte[packedValue.length];
                    }
                    System.arraycopy(packedValue, 0, result[0], 0, packedValue.length);
                }
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (Arrays.equals(maxValue, 0, numBytes, maxPackedValue, 0, numBytes)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        });
        return result[0] != null ? (Number)converter.apply(result[0]) : (Number)null;
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(LeafReaderContext ctx, CompositeIndexFieldInfo starTree, StarTreeBucketCollector parentCollector) throws IOException {
        return StarTreeQueryHelper.getStarTreeBucketMetricCollector(starTree, MetricStat.MAX.getTypeName(), this.valuesSource, parentCollector, bucket -> {
            long from = this.maxes.size();
            this.maxes = this.context.bigArrays().grow(this.maxes, bucket + 1L);
            this.maxes.fill(from, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }, (bucket, metricValue) -> this.maxes.set((long)bucket, Math.max(this.maxes.get((long)bucket), NumericUtils.sortableLongToDouble((long)metricValue))));
    }
}

