/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public final class BufferedChecksumStreamOutput
extends StreamOutput {
    private final StreamOutput out;
    private final Checksum digest;

    public BufferedChecksumStreamOutput(StreamOutput out) {
        this.out = out;
        this.digest = new BufferedChecksum((Checksum)new CRC32());
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    public void writeByte(byte b) throws IOException {
        this.out.writeByte(b);
        this.digest.update(b);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.out.writeBytes(b, offset, length);
        this.digest.update(b, offset, length);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void reset() throws IOException {
        this.out.reset();
        this.digest.reset();
    }

    public void resetDigest() {
        this.digest.reset();
    }

    public void writeMap(@Nullable Map<String, Object> map) throws IOException {
        TreeMap<String, Object> newMap = new TreeMap<String, Object>(map);
        this.writeGenericValue(newMap);
    }

    public <K, V> void writeMap(Map<K, V> map, Writeable.Writer<K> keyWriter, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeVInt(map.size());
        map.keySet().stream().sorted().forEachOrdered(key -> {
            try {
                keyWriter.write((StreamOutput)this, key);
                valueWriter.write((StreamOutput)this, map.get(key));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write map values.", e);
            }
        });
    }

    public <K, V> void writeMapValues(Map<K, V> map, Writeable.Writer<V> valueWriter) throws IOException {
        this.writeVInt(map.size());
        map.keySet().stream().sorted().forEachOrdered(key -> {
            try {
                valueWriter.write((StreamOutput)this, map.get(key));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write map values.", e);
            }
        });
    }

    public void writeStringArray(String[] array) throws IOException {
        Object[] copyArray = Arrays.copyOf(array, array.length);
        Arrays.sort(copyArray);
        super.writeStringArray((String[])copyArray);
    }

    public void writeVLongArray(long[] values) throws IOException {
        long[] copyValues = Arrays.copyOf(values, values.length);
        Arrays.sort(copyValues);
        super.writeVLongArray(copyValues);
    }

    public void writeCollection(Collection<? extends Writeable> collection) throws IOException {
        List sortedList = collection.stream().sorted().collect(Collectors.toList());
        super.writeCollection(sortedList, (o, v) -> v.writeTo(o));
    }

    public void writeStringCollection(Collection<String> collection) throws IOException {
        ArrayList<String> listCollection = new ArrayList<String>(collection);
        Collections.sort(listCollection);
        this.writeCollection(listCollection, StreamOutput::writeString);
    }

    public void writeOptionalStringCollection(Collection<String> collection) throws IOException {
        if (collection != null) {
            ArrayList<String> listCollection = new ArrayList<String>(collection);
            Collections.sort(listCollection);
            this.writeBoolean(true);
            this.writeCollection(listCollection, StreamOutput::writeString);
        } else {
            this.writeBoolean(false);
        }
    }
}

