/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.Map;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeFilters;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.node.remotestore.RemoteStoreNodeService;

public class SearchReplicaAllocationDecider
extends AllocationDecider {
    public static final String NAME = "filter";
    private static final String SEARCH_REPLICA_ROUTING_INCLUDE_GROUP_PREFIX = "cluster.routing.allocation.search.replica.dedicated.include";
    public static final Setting.AffixSetting<String> SEARCH_REPLICA_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.search.replica.dedicated.include.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    private volatile DiscoveryNodeFilters searchReplicaIncludeFilters;
    private volatile RemoteStoreNodeService.Direction migrationDirection;
    private volatile RemoteStoreNodeService.CompatibilityMode compatibilityMode;

    public SearchReplicaAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.setSearchReplicaIncludeFilters(SEARCH_REPLICA_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(settings));
        clusterSettings.addAffixMapUpdateConsumer(SEARCH_REPLICA_ROUTING_INCLUDE_GROUP_SETTING, this::setSearchReplicaIncludeFilters, (a, b) -> {});
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    private Decision shouldFilter(ShardRouting shardRouting, DiscoveryNode node, RoutingAllocation allocation) {
        if (this.searchReplicaIncludeFilters != null) {
            boolean match = this.searchReplicaIncludeFilters.match(node);
            if (!match && shardRouting.isSearchOnly()) {
                return allocation.decision(Decision.NO, NAME, "node does not match shard setting [%s] filters [%s]", SEARCH_REPLICA_ROUTING_INCLUDE_GROUP_PREFIX, this.searchReplicaIncludeFilters);
            }
            if (!shardRouting.isSearchOnly() && match) {
                return allocation.decision(Decision.NO, NAME, "only search replicas can be allocated to node with setting [%s] filters [%s]", SEARCH_REPLICA_ROUTING_INCLUDE_GROUP_PREFIX, this.searchReplicaIncludeFilters);
            }
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private void setSearchReplicaIncludeFilters(Map<String, String> filters) {
        this.searchReplicaIncludeFilters = DiscoveryNodeFilters.trimTier(DiscoveryNodeFilters.buildOrUpdateFromKeyValue(this.searchReplicaIncludeFilters, DiscoveryNodeFilters.OpType.OR, filters));
    }
}

