/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.implementation;

import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.TableFunctionImplementation;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.request.PrometheusQueryRequest;
import org.opensearch.sql.prometheus.storage.PrometheusMetricTable;
import org.opensearch.sql.storage.Table;

public class QueryRangeFunctionImplementation
extends FunctionExpression
implements TableFunctionImplementation {
    private final FunctionName functionName;
    private final List<Expression> arguments;
    private final PrometheusClient prometheusClient;

    public QueryRangeFunctionImplementation(FunctionName functionName, List<Expression> arguments, PrometheusClient prometheusClient) {
        super(functionName, arguments);
        this.functionName = functionName;
        this.arguments = arguments;
        this.prometheusClient = prometheusClient;
    }

    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        throw new UnsupportedOperationException(String.format("Prometheus defined function [%s] is only supported in SOURCE clause with prometheus connector catalog", this.functionName));
    }

    public ExprType type() {
        return ExprCoreType.STRUCT;
    }

    public String toString() {
        List args = this.arguments.stream().map(arg -> String.format("%s=%s", ((NamedArgumentExpression)arg).getArgName(), ((NamedArgumentExpression)arg).getValue().toString())).collect(Collectors.toList());
        return String.format("%s(%s)", this.functionName, String.join((CharSequence)", ", args));
    }

    public Table applyArguments() {
        return new PrometheusMetricTable(this.prometheusClient, this.buildQueryFromQueryRangeFunction(this.arguments));
    }

    private PrometheusQueryRequest buildQueryFromQueryRangeFunction(List<Expression> arguments) {
        PrometheusQueryRequest prometheusQueryRequest = new PrometheusQueryRequest();
        arguments.forEach(arg -> {
            String argName = ((NamedArgumentExpression)arg).getArgName();
            Expression argValue = ((NamedArgumentExpression)arg).getValue();
            ExprValue literalValue = argValue.valueOf();
            switch (argName) {
                case "query": {
                    prometheusQueryRequest.setPromQl((String)literalValue.value());
                    break;
                }
                case "starttime": {
                    prometheusQueryRequest.setStartTime(((Number)literalValue.value()).longValue());
                    break;
                }
                case "endtime": {
                    prometheusQueryRequest.setEndTime(((Number)literalValue.value()).longValue());
                    break;
                }
                case "step": {
                    prometheusQueryRequest.setStep(literalValue.value().toString());
                    break;
                }
                default: {
                    throw new ExpressionEvaluationException(String.format("Invalid Function Argument:%s", argName));
                }
            }
        });
        return prometheusQueryRequest;
    }
}

