/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.settings;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;

public class SecurityAnalyticsSettings {
    public static final String CORRELATION_INDEX = "index.correlation";
    public static final int minSystemIndexReplicas = 0;
    public static final int maxSystemIndexReplicas = 20;
    public static Setting<TimeValue> INDEX_TIMEOUT = Setting.positiveTimeSetting((String)"plugins.security_analytics.index_timeout", (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Long DEFAULT_MAX_ACTIONABLE_ALERT_COUNT = 50L;
    public static final Setting<Boolean> ALERT_HISTORY_ENABLED = Setting.boolSetting((String)"plugins.security_analytics.alert_history_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> FINDING_HISTORY_ENABLED = Setting.boolSetting((String)"plugins.security_analytics.alert_finding_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> IOC_FINDING_HISTORY_ENABLED = Setting.boolSetting((String)"plugins.security_analytics.ioc_finding_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> ALERT_HISTORY_ROLLOVER_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.alert_history_rollover_period", (TimeValue)TimeValue.timeValueHours((long)12L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> FINDING_HISTORY_ROLLOVER_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.alert_finding_rollover_period", (TimeValue)TimeValue.timeValueHours((long)12L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> CORRELATION_HISTORY_ROLLOVER_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.correlation_history_rollover_period", (TimeValue)TimeValue.timeValueHours((long)12L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> IOC_FINDING_HISTORY_ROLLOVER_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.ioc_finding_history_rollover_period", (TimeValue)TimeValue.timeValueHours((long)12L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> ALERT_HISTORY_INDEX_MAX_AGE = Setting.positiveTimeSetting((String)"plugins.security_analytics.alert_history_max_age", (TimeValue)new TimeValue(30L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> FINDING_HISTORY_INDEX_MAX_AGE = Setting.positiveTimeSetting((String)"plugins.security_analytics.finding_history_max_age", (TimeValue)new TimeValue(30L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> CORRELATION_HISTORY_INDEX_MAX_AGE = Setting.positiveTimeSetting((String)"plugins.security_analytics.correlation_history_max_age", (TimeValue)new TimeValue(30L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> IOC_FINDING_HISTORY_INDEX_MAX_AGE = Setting.positiveTimeSetting((String)"plugins.security_analytics.ioc_finding_history_max_age", (TimeValue)new TimeValue(30L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> ALERT_HISTORY_MAX_DOCS = Setting.longSetting((String)"plugins.security_analytics.alert_history_max_docs", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> FINDING_HISTORY_MAX_DOCS = Setting.longSetting((String)"plugins.security_analytics.alert_finding_max_docs", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated});
    public static final Setting<Long> CORRELATION_HISTORY_MAX_DOCS = Setting.longSetting((String)"plugins.security_analytics.correlation_history_max_docs", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> IOC_FINDING_HISTORY_MAX_DOCS = Setting.longSetting((String)"plugins.security_analytics.ioc_finding_history_max_docs", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> ALERT_HISTORY_RETENTION_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.alert_history_retention_period", (TimeValue)new TimeValue(60L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> FINDING_HISTORY_RETENTION_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.finding_history_retention_period", (TimeValue)new TimeValue(60L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> CORRELATION_HISTORY_RETENTION_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.correlation_history_retention_period", (TimeValue)new TimeValue(60L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> IOC_FINDING_HISTORY_RETENTION_PERIOD = Setting.positiveTimeSetting((String)"plugins.security_analytics.ioc_finding_history_retention_period", (TimeValue)new TimeValue(60L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> REQUEST_TIMEOUT = Setting.positiveTimeSetting((String)"plugins.security_analytics.request_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> MAX_ACTION_THROTTLE_VALUE = Setting.positiveTimeSetting((String)"plugins.security_analytics.action_throttle_max_value", (TimeValue)TimeValue.timeValueHours((long)24L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> FILTER_BY_BACKEND_ROLES = Setting.boolSetting((String)"plugins.security_analytics.filter_by_backend_roles", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> ENABLE_WORKFLOW_USAGE = Setting.boolSetting((String)"plugins.security_analytics.enable_workflow_usage", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> IS_CORRELATION_INDEX_SETTING = Setting.boolSetting((String)"index.correlation", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    public static final Setting<TimeValue> CORRELATION_TIME_WINDOW = Setting.positiveTimeSetting((String)"plugins.security_analytics.correlation_time_window", (TimeValue)new TimeValue(5L, TimeUnit.MINUTES), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> ENABLE_AUTO_CORRELATIONS = Setting.boolSetting((String)"plugins.security_analytics.auto_correlations_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<String> DEFAULT_MAPPING_SCHEMA = Setting.simpleString((String)"plugins.security_analytics.mappings.default_schema", (String)"ecs", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> TIF_UPDATE_INTERVAL = Setting.timeSetting((String)"plugins.security_analytics.threatintel.tifjob.update_interval", (TimeValue)TimeValue.timeValueMinutes((long)1440L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> BATCH_SIZE = Setting.intSetting((String)"plugins.security_analytics.threatintel.tifjob.batch_size", (int)10000, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> THREAT_INTEL_TIMEOUT = Setting.timeSetting((String)"plugins.security_analytics.threat_intel_timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> IOC_INDEX_RETENTION_PERIOD = Setting.timeSetting((String)"plugins.security_analytics.ioc.index_retention_period", (TimeValue)new TimeValue(30L, TimeUnit.DAYS), (TimeValue)new TimeValue(1L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> IOC_MAX_INDICES_PER_INDEX_PATTERN = Setting.intSetting((String)"plugins.security_analytics.ioc.max_indices_per_alias", (int)30, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> IOC_SCAN_MAX_TERMS_COUNT = Setting.intSetting((String)"plugins.security_analytics.ioc.scan_max_terms_count", (int)65536, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> ENABLE_DETECTORS_WITH_DEDICATED_QUERY_INDICES = Setting.boolSetting((String)"plugins.security_analytics.enable_detectors_with_dedicated_query_indices", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public static final List<Setting<?>> settings() {
        return List.of(BATCH_SIZE, THREAT_INTEL_TIMEOUT, TIF_UPDATE_INTERVAL);
    }
}

