/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.ml.ForecastModelManager;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.model.ForecastTask;
import org.opensearch.forecast.model.ForecastTaskType;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.stats.ForecastStats;
import org.opensearch.forecast.task.ForecastTaskManager;
import org.opensearch.forecast.transport.EntityForecastResultAction;
import org.opensearch.forecast.transport.ForecastResultAction;
import org.opensearch.forecast.transport.ForecastResultProcessor;
import org.opensearch.forecast.transport.ForecastResultRequest;
import org.opensearch.forecast.transport.ForecastResultResponse;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.cluster.HashRing;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.transport.ResultProcessor;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;

public class ForecastResultTransportAction
extends HandledTransportAction<ForecastResultRequest, ForecastResultResponse> {
    private static final Logger LOG = LogManager.getLogger(ForecastResultTransportAction.class);
    private ResultProcessor<ForecastResultRequest, ForecastResult, ForecastResultResponse, TaskCacheManager, ForecastTaskType, ForecastTask, ForecastIndex, ForecastIndexManagement, ForecastTaskManager> resultProcessor;
    private final Client client;
    private CircuitBreakerService circuitBreakerService;
    private final Set<String> hcForecasters;
    private final ForecastStats forecastStats;
    private final NodeStateManager nodeStateManager;
    private final Settings settings;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final HashRing hashRing;
    private final TransportService transportService;
    private final ForecastTaskManager realTimeTaskManager;
    private final NamedXContentRegistry xContentRegistry;
    private final SecurityClientUtil clientUtil;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final FeatureManager featureManager;

    @Inject
    public ForecastResultTransportAction(ActionFilters actionFilters, TransportService transportService, Settings settings, Client client, SecurityClientUtil clientUtil, NodeStateManager nodeStateManager, FeatureManager featureManager, ForecastModelManager modelManager, HashRing hashRing, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, CircuitBreakerService circuitBreakerService, ForecastStats forecastStats, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, ForecastTaskManager realTimeTaskManager) {
        super(ForecastResultAction.NAME, transportService, actionFilters, ForecastResultRequest::new);
        this.settings = settings;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.hashRing = hashRing;
        this.transportService = transportService;
        this.realTimeTaskManager = realTimeTaskManager;
        this.xContentRegistry = xContentRegistry;
        this.clientUtil = clientUtil;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.featureManager = featureManager;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
        this.hcForecasters = new HashSet<String>();
        this.forecastStats = forecastStats;
        this.nodeStateManager = nodeStateManager;
        this.resultProcessor = null;
    }

    protected void doExecute(Task task, ForecastResultRequest request, ActionListener<ForecastResultResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String forecastID = request.getConfigId();
            ActionListener original = listener;
            listener = ActionListener.wrap(r -> {
                this.hcForecasters.remove(forecastID);
                original.onResponse((Object)r);
            }, e -> {
                if (!(e instanceof TimeSeriesException) || ((TimeSeriesException)e).isCountedInStats()) {
                    this.forecastStats.getStat(StatNames.FORECAST_EXECUTE_FAIL_COUNT.getName()).increment();
                    if (this.hcForecasters.contains(forecastID)) {
                        this.forecastStats.getStat(StatNames.FORECAST_HC_EXECUTE_FAIL_COUNT.getName()).increment();
                    }
                }
                this.hcForecasters.remove(forecastID);
                original.onFailure(e);
            });
            if (!ForecastEnabledSetting.isForecastEnabled()) {
                throw new EndRunException(forecastID, "Forecast functionality is disabled. To enable update plugins.forecast.enabled to true", true).countedInStats(false);
            }
            this.forecastStats.getStat(StatNames.FORECAST_EXECUTE_REQUEST_COUNT.getName()).increment();
            if (this.circuitBreakerService.isOpen().booleanValue()) {
                listener.onFailure((Exception)new LimitExceededException(forecastID, "The total OpenSearch memory usage exceeds our threshold, opening the memory circuit.", false));
                return;
            }
            this.resultProcessor = new ForecastResultProcessor(ForecastSettings.FORECAST_REQUEST_TIMEOUT, EntityForecastResultAction.NAME, StatNames.FORECAST_HC_EXECUTE_REQUEST_COUNT, this.settings, this.clusterService, this.threadPool, this.hashRing, this.nodeStateManager, this.transportService, this.forecastStats, this.realTimeTaskManager, this.xContentRegistry, this.client, this.clientUtil, this.indexNameExpressionResolver, ForecastResultResponse.class, this.featureManager, AnalysisType.FORECAST, false);
            try {
                this.nodeStateManager.getConfig(forecastID, AnalysisType.FORECAST, this.resultProcessor.onGetConfig((ActionListener<ForecastResultResponse>)listener, forecastID, request, Optional.of(this.hcForecasters)));
            }
            catch (Exception ex) {
                ResultProcessor.handleExecuteException(ex, (ActionListener<? extends ActionResponse>)listener, forecastID);
            }
        }
        catch (Exception e2) {
            LOG.error((Object)e2);
            listener.onFailure(e2);
        }
    }
}

