/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.settings;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.plugin.insights.core.exporter.SinkType;
import org.opensearch.plugin.insights.rules.model.GroupingType;
import org.opensearch.plugin.insights.rules.model.MetricType;

public class QueryInsightsSettings {
    public static final String QUERY_INSIGHTS_EXECUTOR = "query_insights_executor";
    public static final int MAX_THREAD_COUNT = 5;
    public static final int QUERY_RECORD_QUEUE_CAPACITY = 1000;
    public static final TimeValue QUERY_RECORD_QUEUE_DRAIN_INTERVAL = new TimeValue(5L, TimeUnit.SECONDS);
    public static final TimeValue MAX_WINDOW_SIZE = new TimeValue(1L, TimeUnit.DAYS);
    public static final TimeValue MIN_WINDOW_SIZE = new TimeValue(1L, TimeUnit.MINUTES);
    public static final Set<TimeValue> VALID_WINDOW_SIZES_IN_MINUTES = new HashSet<TimeValue>(Arrays.asList(new TimeValue(1L, TimeUnit.MINUTES), new TimeValue(5L, TimeUnit.MINUTES), new TimeValue(10L, TimeUnit.MINUTES), new TimeValue(30L, TimeUnit.MINUTES)));
    public static final int MAX_N_SIZE = 100;
    public static final TimeValue DEFAULT_WINDOW_SIZE = new TimeValue(5L, TimeUnit.MINUTES);
    public static final int DEFAULT_TOP_N_SIZE = 10;
    public static final String PLUGINS_BASE_URI = "/_insights";
    public static final GroupingType DEFAULT_GROUPING_TYPE = GroupingType.NONE;
    public static final int DEFAULT_GROUPS_EXCLUDING_TOPN_LIMIT = 100;
    public static final int MAX_GROUPS_EXCLUDING_TOPN_LIMIT = 10000;
    public static final String QUERY_INSIGHTS_HEALTH_STATS_URI = "/_insights/health_stats";
    public static final String TOP_QUERIES_BASE_URI = "/_insights/top_queries";
    public static final String TOP_N_QUERIES_SETTING_PREFIX = "search.insights.top_queries";
    public static final String TOP_N_QUERIES_GROUPING_SETTING_PREFIX = "search.insights.top_queries.grouping";
    public static final String TOP_N_LATENCY_QUERIES_PREFIX = "search.insights.top_queries.latency";
    public static final String TOP_N_CPU_QUERIES_PREFIX = "search.insights.top_queries.cpu";
    public static final String TOP_N_MEMORY_QUERIES_PREFIX = "search.insights.top_queries.memory";
    public static final Setting<Boolean> TOP_N_LATENCY_QUERIES_ENABLED = Setting.boolSetting((String)"search.insights.top_queries.latency.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> TOP_N_LATENCY_QUERIES_SIZE = Setting.intSetting((String)"search.insights.top_queries.latency.top_n_size", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> TOP_N_LATENCY_QUERIES_WINDOW_SIZE = Setting.positiveTimeSetting((String)"search.insights.top_queries.latency.window_size", (TimeValue)DEFAULT_WINDOW_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<String> TOP_N_QUERIES_GROUP_BY = Setting.simpleString((String)"search.insights.top_queries.group_by", (String)DEFAULT_GROUPING_TYPE.getValue(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> TOP_N_QUERIES_MAX_GROUPS_EXCLUDING_N = Setting.intSetting((String)"search.insights.top_queries.max_groups_excluding_topn", (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> TOP_N_QUERIES_GROUPING_FIELD_NAME = Setting.boolSetting((String)"search.insights.top_queries.grouping.attributes.field_name", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> TOP_N_QUERIES_GROUPING_FIELD_TYPE = Setting.boolSetting((String)"search.insights.top_queries.grouping.attributes.field_type", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> TOP_N_CPU_QUERIES_ENABLED = Setting.boolSetting((String)"search.insights.top_queries.cpu.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> TOP_N_CPU_QUERIES_SIZE = Setting.intSetting((String)"search.insights.top_queries.cpu.top_n_size", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> TOP_N_CPU_QUERIES_WINDOW_SIZE = Setting.positiveTimeSetting((String)"search.insights.top_queries.cpu.window_size", (TimeValue)DEFAULT_WINDOW_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> TOP_N_MEMORY_QUERIES_ENABLED = Setting.boolSetting((String)"search.insights.top_queries.memory.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> TOP_N_MEMORY_QUERIES_SIZE = Setting.intSetting((String)"search.insights.top_queries.memory.top_n_size", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> TOP_N_MEMORY_QUERIES_WINDOW_SIZE = Setting.positiveTimeSetting((String)"search.insights.top_queries.memory.window_size", (TimeValue)DEFAULT_WINDOW_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final String EXPORTER_TYPE = "type";
    private static final String TOP_N_QUERIES_EXPORTER_PREFIX = "search.insights.top_queries.exporter";
    public static final String DEFAULT_TOP_N_QUERIES_INDEX_PATTERN = "'top_queries-'YYYY.MM.dd";
    public static final String DEFAULT_TOP_QUERIES_EXPORTER_TYPE = SinkType.LOCAL_INDEX.toString();
    public static final int DEFAULT_DELETE_AFTER_VALUE = 7;
    public static final int MIN_DELETE_AFTER_VALUE = 1;
    public static final int MAX_DELETE_AFTER_VALUE = 180;
    public static final Setting<Integer> TOP_N_EXPORTER_DELETE_AFTER = Setting.intSetting((String)"search.insights.top_queries.exporter.delete_after_days", (int)7, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<String> TOP_N_EXPORTER_TYPE = Setting.simpleString((String)"search.insights.top_queries.exporter.type", (String)DEFAULT_TOP_QUERIES_EXPORTER_TYPE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public static Setting<Boolean> getTopNEnabledSetting(MetricType type) {
        switch (type) {
            case CPU: {
                return TOP_N_CPU_QUERIES_ENABLED;
            }
            case MEMORY: {
                return TOP_N_MEMORY_QUERIES_ENABLED;
            }
        }
        return TOP_N_LATENCY_QUERIES_ENABLED;
    }

    public static Setting<Integer> getTopNSizeSetting(MetricType type) {
        switch (type) {
            case CPU: {
                return TOP_N_CPU_QUERIES_SIZE;
            }
            case MEMORY: {
                return TOP_N_MEMORY_QUERIES_SIZE;
            }
        }
        return TOP_N_LATENCY_QUERIES_SIZE;
    }

    public static Setting<TimeValue> getTopNWindowSizeSetting(MetricType type) {
        switch (type) {
            case CPU: {
                return TOP_N_CPU_QUERIES_WINDOW_SIZE;
            }
            case MEMORY: {
                return TOP_N_MEMORY_QUERIES_WINDOW_SIZE;
            }
        }
        return TOP_N_LATENCY_QUERIES_WINDOW_SIZE;
    }
}

