/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.action.top_queries;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueries;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;

public class TopQueriesResponse
extends BaseNodesResponse<TopQueries>
implements ToXContentFragment {
    private static final String CLUSTER_LEVEL_RESULTS_KEY = "top_queries";
    private final MetricType metricType;
    private final int top_n_size;

    public TopQueriesResponse(StreamInput in) throws IOException {
        super(in);
        this.top_n_size = in.readInt();
        this.metricType = (MetricType)in.readEnum(MetricType.class);
    }

    public TopQueriesResponse(ClusterName clusterName, List<TopQueries> nodes, List<FailedNodeException> failures, int top_n_size, MetricType metricType) {
        super(clusterName, nodes, failures);
        this.top_n_size = top_n_size;
        this.metricType = metricType;
    }

    protected List<TopQueries> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(TopQueries::new);
    }

    protected void writeNodesTo(StreamOutput out, List<TopQueries> nodes) throws IOException {
        out.writeList(nodes);
        out.writeLong((long)this.top_n_size);
        out.writeEnum((Enum)this.metricType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List results = this.getNodes();
        builder.startObject();
        this.toClusterLevelResult(builder, params, results);
        return builder.endObject();
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.toString();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    private void toClusterLevelResult(XContentBuilder builder, ToXContent.Params params, List<TopQueries> results) throws IOException {
        List all_records = results.stream().map(TopQueries::getTopQueriesRecord).flatMap(Collection::stream).sorted((a, b) -> SearchQueryRecord.compare(a, b, this.metricType) * -1).limit(this.top_n_size).collect(Collectors.toList());
        builder.startArray(CLUSTER_LEVEL_RESULTS_KEY);
        for (SearchQueryRecord record : all_records) {
            record.toXContent(builder, params);
        }
        builder.endArray();
    }
}

