/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.categorizer;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.common.SetOnce;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.index.Index;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.plugin.insights.core.service.categorizer.QueryShapeGenerator;

public final class QueryShapeVisitor
implements QueryBuilderVisitor {
    private final SetOnce<String> queryType = new SetOnce();
    private final SetOnce<String> fieldData = new SetOnce();
    private final Map<BooleanClause.Occur, List<QueryShapeVisitor>> childVisitors = new EnumMap<BooleanClause.Occur, List<QueryShapeVisitor>>(BooleanClause.Occur.class);
    private final QueryShapeGenerator queryShapeGenerator;
    private final Map<String, Object> propertiesAsMap;
    private final Index index;
    private final Boolean showFieldName;
    private final Boolean showFieldType;

    public void accept(QueryBuilder queryBuilder) {
        this.queryType.set((Object)queryBuilder.getName());
        this.fieldData.set((Object)this.queryShapeGenerator.buildFieldDataString((NamedWriteable)queryBuilder, this.propertiesAsMap, this.index, this.showFieldName, this.showFieldType));
    }

    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        if (this.childVisitors.containsKey(occur)) {
            throw new IllegalStateException("child visitor already called for " + String.valueOf(occur));
        }
        final ArrayList childVisitorList = new ArrayList();
        QueryBuilderVisitor childVisitorWrapper = new QueryBuilderVisitor(){
            QueryShapeVisitor currentChild;

            public void accept(QueryBuilder qb) {
                this.currentChild = new QueryShapeVisitor(QueryShapeVisitor.this.queryShapeGenerator, QueryShapeVisitor.this.propertiesAsMap, QueryShapeVisitor.this.index, QueryShapeVisitor.this.showFieldName, QueryShapeVisitor.this.showFieldType);
                childVisitorList.add(this.currentChild);
                this.currentChild.accept(qb);
            }

            public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
                return this.currentChild.getChildVisitor(occur);
            }
        };
        this.childVisitors.put(occur, childVisitorList);
        return childVisitorWrapper;
    }

    public String toJson() {
        StringBuilder outputBuilder = new StringBuilder("{\"type\":\"").append((String)this.queryType.get()).append("\"");
        for (Map.Entry<BooleanClause.Occur, List<QueryShapeVisitor>> entry : this.childVisitors.entrySet()) {
            outputBuilder.append(",\"").append(entry.getKey().name().toLowerCase(Locale.ROOT)).append("\"[");
            boolean first = true;
            for (QueryShapeVisitor child : entry.getValue()) {
                if (!first) {
                    outputBuilder.append(",");
                }
                outputBuilder.append(child.toJson());
                first = false;
            }
            outputBuilder.append("]");
        }
        outputBuilder.append("}");
        return outputBuilder.toString();
    }

    public String prettyPrintTree(String indent, Boolean showFieldName, Boolean showFieldType) {
        StringBuilder outputBuilder = new StringBuilder(indent).append((String)this.queryType.get());
        if (showFieldName.booleanValue() || showFieldType.booleanValue()) {
            outputBuilder.append((String)this.fieldData.get());
        }
        outputBuilder.append("\n");
        for (Map.Entry<BooleanClause.Occur, List<QueryShapeVisitor>> entry : this.childVisitors.entrySet()) {
            outputBuilder.append(indent).append(" ".repeat(2)).append(entry.getKey().name().toLowerCase(Locale.ROOT)).append(":\n");
            for (QueryShapeVisitor child : entry.getValue()) {
                outputBuilder.append(child.prettyPrintTree(indent + " ".repeat(4), showFieldName, showFieldType));
            }
        }
        return outputBuilder.toString();
    }

    public QueryShapeVisitor(QueryShapeGenerator queryShapeGenerator, Map<String, Object> propertiesAsMap, Index index, Boolean showFieldName, Boolean showFieldType) {
        this.queryShapeGenerator = queryShapeGenerator;
        this.propertiesAsMap = propertiesAsMap;
        this.index = index;
        this.showFieldName = showFieldName;
        this.showFieldType = showFieldType;
    }
}

