/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.action.search.SearchTask;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.tasks.resourcetracker.TaskResourceInfo;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.plugin.insights.core.metrics.OperationalMetricsCounter;
import org.opensearch.plugin.insights.core.service.QueryInsightsService;
import org.opensearch.plugin.insights.core.service.categorizer.QueryShapeGenerator;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.Measurement;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.settings.QueryCategorizationSettings;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;

public final class QueryInsightsListener
extends SearchRequestOperationsListener {
    private static final Logger log = LogManager.getLogger(QueryInsightsListener.class);
    private final QueryInsightsService queryInsightsService;
    private final ClusterService clusterService;
    private boolean groupingFieldNameEnabled;
    private boolean groupingFieldTypeEnabled;
    private final QueryShapeGenerator queryShapeGenerator;

    @Inject
    public QueryInsightsListener(ClusterService clusterService, QueryInsightsService queryInsightsService) {
        this(clusterService, queryInsightsService, false);
        this.groupingFieldNameEnabled = false;
        this.groupingFieldTypeEnabled = false;
    }

    public QueryInsightsListener(ClusterService clusterService, QueryInsightsService queryInsightsService, boolean initiallyEnabled) {
        super(initiallyEnabled);
        this.clusterService = clusterService;
        this.queryInsightsService = queryInsightsService;
        this.queryShapeGenerator = new QueryShapeGenerator(clusterService);
        queryInsightsService.setQueryShapeGenerator(this.queryShapeGenerator);
        for (MetricType type : MetricType.allMetricTypes()) {
            clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.getTopNEnabledSetting(type), v -> this.setEnableTopQueries(type, (boolean)v));
            clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.getTopNSizeSetting(type), v -> this.queryInsightsService.setTopNSize(type, (int)v), v -> this.queryInsightsService.validateTopNSize(type, (int)v));
            clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.getTopNWindowSizeSetting(type), v -> this.queryInsightsService.setWindowSize(type, (TimeValue)v), v -> this.queryInsightsService.validateWindowSize(type, (TimeValue)v));
            this.setEnableTopQueries(type, (Boolean)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNEnabledSetting(type)));
            this.queryInsightsService.validateTopNSize(type, (Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNSizeSetting(type)));
            this.queryInsightsService.setTopNSize(type, (Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNSizeSetting(type)));
            this.queryInsightsService.validateWindowSize(type, (TimeValue)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNWindowSizeSetting(type)));
            this.queryInsightsService.setWindowSize(type, (TimeValue)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNWindowSizeSetting(type)));
        }
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_QUERIES_GROUP_BY, v -> this.queryInsightsService.setGrouping((String)v), v -> this.queryInsightsService.validateGrouping((String)v));
        this.queryInsightsService.validateGrouping((String)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_QUERIES_GROUP_BY));
        this.queryInsightsService.setGrouping((String)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_QUERIES_GROUP_BY));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_QUERIES_MAX_GROUPS_EXCLUDING_N, v -> this.queryInsightsService.setMaximumGroups((int)v), v -> this.queryInsightsService.validateMaximumGroups((int)v));
        this.queryInsightsService.validateMaximumGroups((Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_QUERIES_MAX_GROUPS_EXCLUDING_N));
        this.queryInsightsService.setMaximumGroups((Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_QUERIES_MAX_GROUPS_EXCLUDING_N));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_QUERIES_GROUPING_FIELD_NAME, this::setGroupingFieldNameEnabled);
        this.setGroupingFieldNameEnabled((Boolean)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_QUERIES_GROUPING_FIELD_NAME));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_QUERIES_GROUPING_FIELD_TYPE, this::setGroupingFieldTypeEnabled);
        this.setGroupingFieldTypeEnabled((Boolean)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_QUERIES_GROUPING_FIELD_TYPE));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryCategorizationSettings.SEARCH_QUERY_METRICS_ENABLED_SETTING, this::setSearchQueryMetricsEnabled);
        this.setSearchQueryMetricsEnabled((Boolean)clusterService.getClusterSettings().get(QueryCategorizationSettings.SEARCH_QUERY_METRICS_ENABLED_SETTING));
    }

    public void setEnableTopQueries(MetricType metricType, boolean isCurrentMetricEnabled) {
        this.queryInsightsService.enableCollection(metricType, isCurrentMetricEnabled);
        this.updateQueryInsightsState();
    }

    public void setSearchQueryMetricsEnabled(boolean searchQueryMetricsEnabled) {
        this.queryInsightsService.enableSearchQueryMetricsFeature(searchQueryMetricsEnabled);
        this.updateQueryInsightsState();
    }

    public void setGroupingFieldNameEnabled(Boolean fieldNameEnabled) {
        this.groupingFieldNameEnabled = fieldNameEnabled;
    }

    public void setGroupingFieldTypeEnabled(Boolean fieldTypeEnabled) {
        this.groupingFieldTypeEnabled = fieldTypeEnabled;
    }

    private void updateQueryInsightsState() {
        boolean anyFeatureEnabled = this.queryInsightsService.isAnyFeatureEnabled();
        if (anyFeatureEnabled && !super.isEnabled()) {
            super.setEnabled(true);
            this.queryInsightsService.stop();
            this.queryInsightsService.start();
        } else if (!anyFeatureEnabled && super.isEnabled()) {
            super.setEnabled(false);
            this.queryInsightsService.stop();
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void onPhaseStart(SearchPhaseContext context) {
    }

    public void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    public void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
    }

    public void onRequestStart(SearchRequestContext searchRequestContext) {
    }

    public void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        this.constructSearchQueryRecord(context, searchRequestContext);
    }

    public void onRequestFailure(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        this.constructSearchQueryRecord(context, searchRequestContext);
    }

    private void constructSearchQueryRecord(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        SearchTask searchTask = context.getTask();
        List tasksResourceUsages = searchRequestContext.getPhaseResourceUsage();
        tasksResourceUsages.add(new TaskResourceInfo(searchTask.getAction(), searchTask.getId(), searchTask.getParentTaskId().getId(), this.clusterService.localNode().getId(), searchTask.getTotalResourceStats()));
        SearchRequest request = context.getRequest();
        try {
            HashMap<MetricType, Measurement> measurements = new HashMap<MetricType, Measurement>();
            measurements.put(MetricType.LATENCY, new Measurement(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - searchRequestContext.getAbsoluteStartNanos())));
            measurements.put(MetricType.CPU, new Measurement(tasksResourceUsages.stream().map(a -> a.getTaskResourceUsage().getCpuTimeInNanos()).mapToLong(Long::longValue).sum()));
            measurements.put(MetricType.MEMORY, new Measurement(tasksResourceUsages.stream().map(a -> a.getTaskResourceUsage().getMemoryInBytes()).mapToLong(Long::longValue).sum()));
            HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
            attributes.put(Attribute.SEARCH_TYPE, request.searchType().toString().toLowerCase(Locale.ROOT));
            attributes.put(Attribute.SOURCE, request.source());
            attributes.put(Attribute.TOTAL_SHARDS, context.getNumShards());
            attributes.put(Attribute.INDICES, request.indices());
            attributes.put(Attribute.PHASE_LATENCY_MAP, searchRequestContext.phaseTookMap());
            attributes.put(Attribute.TASK_RESOURCE_USAGES, tasksResourceUsages);
            attributes.put(Attribute.GROUP_BY, (Object)QueryInsightsSettings.DEFAULT_GROUPING_TYPE);
            attributes.put(Attribute.NODE_ID, this.clusterService.localNode().getId());
            if (this.queryInsightsService.isGroupingEnabled() || log.isTraceEnabled()) {
                String queryShape = this.queryShapeGenerator.buildShape(request.source(), this.groupingFieldNameEnabled, this.groupingFieldTypeEnabled, searchRequestContext.getSuccessfulSearchShardIndices());
                if (log.isTraceEnabled()) {
                    log.trace("Query Shape:\n{}", (Object)queryShape);
                }
                if (this.queryInsightsService.isGroupingEnabled()) {
                    String hashcode = this.queryShapeGenerator.getShapeHashCodeAsString(queryShape);
                    attributes.put(Attribute.QUERY_GROUP_HASHCODE, hashcode);
                }
            }
            HashMap<String, String> labels = new HashMap<String, String>();
            String userProvidedLabel = context.getTask().getHeader("X-Opaque-Id");
            if (userProvidedLabel != null) {
                labels.put("X-Opaque-Id", userProvidedLabel);
            }
            attributes.put(Attribute.LABELS, labels);
            SearchQueryRecord record = new SearchQueryRecord(request.getOrCreateAbsoluteStartMillis(), measurements, attributes);
            this.queryInsightsService.addRecord(record);
        }
        catch (Exception e) {
            OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.DATA_INGEST_EXCEPTIONS);
            log.error(String.format(Locale.ROOT, "fail to ingest query insight data, error: %s", e));
        }
    }
}

