/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.selectivem.collections.CheckTable;
import com.selectivem.collections.CompactMapGroupBuilder;
import com.selectivem.collections.DeduplicatingCompactSubSetBuilder;
import com.selectivem.collections.ImmutableCompactSubSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.security.privileges.ClusterStateMetadataDependentPrivileges;
import org.opensearch.security.privileges.IndexPattern;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.WellKnownActions;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.WildcardMatcher;

public class ActionPrivileges
extends ClusterStateMetadataDependentPrivileges {
    public static Setting<ByteSizeValue> PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE = Setting.memorySizeSetting((String)"plugins.security.privileges_evaluation.precomputed_privileges.max_heap_size", (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger log = LogManager.getLogger(ActionPrivileges.class);
    private final ClusterPrivileges cluster;
    private final IndexPrivileges index;
    private final SecurityDynamicConfiguration<RoleV7> roles;
    private final FlattenedActionGroups actionGroups;
    private final ImmutableSet<String> wellKnownClusterActions;
    private final ImmutableSet<String> wellKnownIndexActions;
    private final Supplier<Map<String, IndexAbstraction>> indexMetadataSupplier;
    private final ByteSizeValue statefulIndexMaxHeapSize;
    private final AtomicReference<StatefulIndexPrivileges> statefulIndex = new AtomicReference();

    public ActionPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, Supplier<Map<String, IndexAbstraction>> indexMetadataSupplier, Settings settings, ImmutableSet<String> wellKnownClusterActions, ImmutableSet<String> wellKnownIndexActions, ImmutableSet<String> explicitlyRequiredIndexActions, Map<String, Set<String>> pluginToClusterActions) {
        this.cluster = new ClusterPrivileges(roles, actionGroups, wellKnownClusterActions, pluginToClusterActions);
        this.index = new IndexPrivileges(roles, actionGroups, wellKnownIndexActions, explicitlyRequiredIndexActions);
        this.roles = roles;
        this.actionGroups = actionGroups;
        this.wellKnownClusterActions = wellKnownClusterActions;
        this.wellKnownIndexActions = wellKnownIndexActions;
        this.indexMetadataSupplier = indexMetadataSupplier;
        this.statefulIndexMaxHeapSize = (ByteSizeValue)PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE.get(settings);
    }

    public ActionPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, Supplier<Map<String, IndexAbstraction>> indexMetadataSupplier, Settings settings) {
        this(roles, actionGroups, indexMetadataSupplier, settings, WellKnownActions.CLUSTER_ACTIONS, WellKnownActions.INDEX_ACTIONS, WellKnownActions.EXPLICITLY_REQUIRED_INDEX_ACTIONS, Map.of());
    }

    public ActionPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, Supplier<Map<String, IndexAbstraction>> indexMetadataSupplier, Settings settings, Map<String, Set<String>> pluginToClusterActions) {
        this(roles, actionGroups, indexMetadataSupplier, settings, WellKnownActions.CLUSTER_ACTIONS, WellKnownActions.INDEX_ACTIONS, WellKnownActions.EXPLICITLY_REQUIRED_INDEX_ACTIONS, pluginToClusterActions);
    }

    public PrivilegesEvaluatorResponse hasClusterPrivilege(PrivilegesEvaluationContext context, String action) {
        return this.cluster.providesPrivilege(context, action, (Set<String>)context.getMappedRoles());
    }

    public PrivilegesEvaluatorResponse hasAnyClusterPrivilege(PrivilegesEvaluationContext context, Set<String> actions) {
        return this.cluster.providesAnyPrivilege(context, actions, (Set<String>)context.getMappedRoles());
    }

    public PrivilegesEvaluatorResponse hasExplicitClusterPrivilege(PrivilegesEvaluationContext context, String action) {
        return this.cluster.providesExplicitPrivilege(context, action, (Set<String>)context.getMappedRoles());
    }

    public PrivilegesEvaluatorResponse hasIndexPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices) {
        PrivilegesEvaluatorResponse response = this.index.providesWildcardPrivilege(context, actions);
        if (response != null) {
            return response;
        }
        if (!resolvedIndices.isLocalAll() && resolvedIndices.getAllIndices().isEmpty()) {
            log.debug("No local indices; grant the request");
            return PrivilegesEvaluatorResponse.ok();
        }
        CheckTable checkTable = CheckTable.create(resolvedIndices.getAllIndicesResolved(context.getClusterStateSupplier(), context.getIndexNameExpressionResolver()), actions);
        StatefulIndexPrivileges statefulIndex = this.statefulIndex.get();
        PrivilegesEvaluatorResponse resultFromStatefulIndex = null;
        Map<String, IndexAbstraction> indexMetadata = this.indexMetadataSupplier.get();
        if (statefulIndex != null && (resultFromStatefulIndex = statefulIndex.providesPrivilege(actions, resolvedIndices, context, (CheckTable<String, String>)checkTable, indexMetadata)) != null) {
            return resultFromStatefulIndex;
        }
        return this.index.providesPrivilege(context, actions, resolvedIndices, (CheckTable<String, String>)checkTable, indexMetadata);
    }

    public PrivilegesEvaluatorResponse hasExplicitIndexPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices) {
        CheckTable checkTable = CheckTable.create(resolvedIndices.getAllIndices(), actions);
        return this.index.providesExplicitPrivilege(context, actions, resolvedIndices, (CheckTable<String, String>)checkTable, this.indexMetadataSupplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStatefulIndexPrivileges(Map<String, IndexAbstraction> indices, long metadataVersion) {
        StatefulIndexPrivileges statefulIndex = this.statefulIndex.get();
        indices = StatefulIndexPrivileges.relevantOnly(indices);
        if (statefulIndex == null || !statefulIndex.indices.equals(indices)) {
            long start = System.currentTimeMillis();
            this.statefulIndex.set(new StatefulIndexPrivileges(this.roles, this.actionGroups, this.wellKnownIndexActions, indices, metadataVersion, this.statefulIndexMaxHeapSize));
            long duration = System.currentTimeMillis() - start;
            log.debug("Updating StatefulIndexPrivileges took {} ms", (Object)duration);
        } else {
            ActionPrivileges actionPrivileges = this;
            synchronized (actionPrivileges) {
                if (statefulIndex.metadataVersion < metadataVersion) {
                    statefulIndex.metadataVersion = metadataVersion;
                }
            }
        }
    }

    @Override
    protected void updateClusterStateMetadata(Metadata metadata) {
        this.updateStatefulIndexPrivileges(metadata.getIndicesLookup(), metadata.version());
    }

    @Override
    protected long getCurrentlyUsedMetadataVersion() {
        StatefulIndexPrivileges statefulIndex = this.statefulIndex.get();
        return statefulIndex != null ? statefulIndex.metadataVersion : 0L;
    }

    int getEstimatedStatefulIndexByteSize() {
        StatefulIndexPrivileges statefulIndex = this.statefulIndex.get();
        if (statefulIndex != null) {
            return statefulIndex.estimatedByteSize;
        }
        return 0;
    }

    static class ClusterPrivileges {
        private final ImmutableMap<String, ImmutableCompactSubSet<String>> actionToRoles;
        private final ImmutableSet<String> rolesWithWildcardPermissions;
        private final ImmutableMap<String, WildcardMatcher> rolesToActionMatcher;
        private final ImmutableMap<String, WildcardMatcher> usersToActionMatcher;
        private final ImmutableSet<String> wellKnownClusterActions;

        ClusterPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, ImmutableSet<String> wellKnownClusterActions, Map<String, Set<String>> pluginToClusterActions) {
            DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(roles.getCEntries().keySet());
            HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder> actionToRoles = new HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder>();
            ImmutableSet.Builder rolesWithWildcardPermissions = ImmutableSet.builder();
            ImmutableMap.Builder rolesToActionMatcher = ImmutableMap.builder();
            ImmutableMap.Builder usersToActionMatcher = ImmutableMap.builder();
            for (Map.Entry<String, RoleV7> entry2 : roles.getCEntries().entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    roleSetBuilder.next((Object)roleName);
                    ImmutableSet<String> permissionPatterns = actionGroups.resolve(role.getCluster_permissions());
                    ArrayList<WildcardMatcher> wildcardMatchers = new ArrayList<WildcardMatcher>();
                    for (String permission : permissionPatterns) {
                        if (WildcardMatcher.isExact(permission)) {
                            actionToRoles.computeIfAbsent(permission, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                            continue;
                        }
                        if (permission.equals("*")) {
                            rolesWithWildcardPermissions.add((Object)roleName);
                            continue;
                        }
                        WildcardMatcher wildcardMatcher = WildcardMatcher.from(permission);
                        Set matchedActions = wildcardMatcher.getMatchAny((Collection<String>)wellKnownClusterActions, Collectors.toUnmodifiableSet());
                        for (String action : matchedActions) {
                            actionToRoles.computeIfAbsent(action, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                        }
                        wildcardMatchers.add(wildcardMatcher);
                    }
                    if (wildcardMatchers.isEmpty()) continue;
                    rolesToActionMatcher.put((Object)roleName, (Object)WildcardMatcher.from(wildcardMatchers));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry2.getKey(), (Object)e);
                }
            }
            if (pluginToClusterActions != null) {
                for (String pluginIdentifier : pluginToClusterActions.keySet()) {
                    Set<String> clusterActions = pluginToClusterActions.get(pluginIdentifier);
                    WildcardMatcher matcher = WildcardMatcher.from(clusterActions);
                    usersToActionMatcher.put((Object)pluginIdentifier, (Object)matcher);
                }
            }
            DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
            this.actionToRoles = (ImmutableMap)actionToRoles.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)entry.getValue()).build(completedRoleSetBuilder)));
            this.rolesWithWildcardPermissions = rolesWithWildcardPermissions.build();
            this.rolesToActionMatcher = rolesToActionMatcher.build();
            this.usersToActionMatcher = usersToActionMatcher.build();
            this.wellKnownClusterActions = wellKnownClusterActions;
        }

        PrivilegesEvaluatorResponse providesPrivilege(PrivilegesEvaluationContext context, String action, Set<String> roles) {
            WildcardMatcher matcher;
            if (CollectionUtils.containsAny(roles, this.rolesWithWildcardPermissions)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            ImmutableCompactSubSet rolesWithPrivileges = (ImmutableCompactSubSet)this.actionToRoles.get((Object)action);
            if (rolesWithPrivileges != null && rolesWithPrivileges.containsAny(roles)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            if (!this.wellKnownClusterActions.contains((Object)action)) {
                for (String role : roles) {
                    WildcardMatcher matcher2 = (WildcardMatcher)this.rolesToActionMatcher.get((Object)role);
                    if (matcher2 == null || !matcher2.test(action)) continue;
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            if (context.getUser().isPluginUser() && this.usersToActionMatcher.containsKey((Object)context.getUser().getName()) && (matcher = (WildcardMatcher)this.usersToActionMatcher.get((Object)context.getUser().getName())) != null && matcher.test(action)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            return PrivilegesEvaluatorResponse.insufficient(action);
        }

        PrivilegesEvaluatorResponse providesExplicitPrivilege(PrivilegesEvaluationContext context, String action, Set<String> roles) {
            ImmutableCompactSubSet rolesWithPrivileges = (ImmutableCompactSubSet)this.actionToRoles.get((Object)action);
            if (rolesWithPrivileges != null && rolesWithPrivileges.containsAny(roles)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            if (!this.wellKnownClusterActions.contains((Object)action)) {
                for (String role : roles) {
                    WildcardMatcher matcher = (WildcardMatcher)this.rolesToActionMatcher.get((Object)role);
                    if (matcher == null || !matcher.test(action)) continue;
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            return PrivilegesEvaluatorResponse.insufficient(action);
        }

        PrivilegesEvaluatorResponse providesAnyPrivilege(PrivilegesEvaluationContext context, Set<String> actions, Set<String> roles) {
            if (CollectionUtils.containsAny(roles, this.rolesWithWildcardPermissions)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            for (String action : actions) {
                ImmutableCompactSubSet rolesWithPrivileges = (ImmutableCompactSubSet)this.actionToRoles.get((Object)action);
                if (rolesWithPrivileges == null || !rolesWithPrivileges.containsAny(roles)) continue;
                return PrivilegesEvaluatorResponse.ok();
            }
            for (String action : actions) {
                if (this.wellKnownClusterActions.contains((Object)action)) continue;
                for (String role : roles) {
                    WildcardMatcher matcher = (WildcardMatcher)this.rolesToActionMatcher.get((Object)role);
                    if (matcher == null || !matcher.test(action)) continue;
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            if (this.usersToActionMatcher.containsKey((Object)context.getUser().getName())) {
                WildcardMatcher matcher = (WildcardMatcher)this.usersToActionMatcher.get((Object)context.getUser().getName());
                for (String action : actions) {
                    if (matcher == null || !matcher.test(action)) continue;
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            if (actions.size() == 1) {
                return PrivilegesEvaluatorResponse.insufficient(actions.iterator().next());
            }
            return PrivilegesEvaluatorResponse.insufficient("any of " + String.valueOf(actions));
        }
    }

    static class IndexPrivileges {
        private final ImmutableMap<String, ImmutableMap<String, IndexPattern>> rolesToActionToIndexPattern;
        private final ImmutableMap<String, ImmutableMap<WildcardMatcher, IndexPattern>> rolesToActionPatternToIndexPattern;
        private final ImmutableMap<String, ImmutableCompactSubSet<String>> actionToRolesWithWildcardIndexPrivileges;
        private final ImmutableSet<String> wellKnownIndexActions;
        private final ImmutableSet<String> explicitlyRequiredIndexActions;
        private final ImmutableMap<String, ImmutableMap<String, IndexPattern>> rolesToExplicitActionToIndexPattern;

        IndexPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, ImmutableSet<String> wellKnownIndexActions, ImmutableSet<String> explicitlyRequiredIndexActions) {
            DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(roles.getCEntries().keySet());
            HashMap<String, Map> rolesToActionToIndexPattern = new HashMap<String, Map>();
            HashMap<String, Map> rolesToActionPatternToIndexPattern = new HashMap<String, Map>();
            HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder> actionToRolesWithWildcardIndexPrivileges = new HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder>();
            HashMap<String, Map> rolesToExplicitActionToIndexPattern = new HashMap<String, Map>();
            for (Map.Entry<String, RoleV7> entry2 : roles.getCEntries().entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    roleSetBuilder.next((Object)roleName);
                    for (RoleV7.Index indexPermissions : role.getIndex_permissions()) {
                        ImmutableSet<String> permissions = actionGroups.resolve(indexPermissions.getAllowed_actions());
                        for (String permission : permissions) {
                            if (WildcardMatcher.isExact(permission)) {
                                rolesToActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(permission, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                                if (explicitlyRequiredIndexActions.contains((Object)permission)) {
                                    rolesToExplicitActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(permission, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                                }
                                if (!indexPermissions.getIndex_patterns().contains("*")) continue;
                                actionToRolesWithWildcardIndexPrivileges.computeIfAbsent(permission, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                                continue;
                            }
                            WildcardMatcher actionMatcher = WildcardMatcher.from(permission);
                            for (String action : actionMatcher.iterateMatching((Iterable<String>)wellKnownIndexActions)) {
                                rolesToActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(action, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                                if (!indexPermissions.getIndex_patterns().contains("*")) continue;
                                actionToRolesWithWildcardIndexPrivileges.computeIfAbsent(permission, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                            }
                            rolesToActionPatternToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(actionMatcher, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                            if (actionMatcher == WildcardMatcher.ANY) continue;
                            for (String action : actionMatcher.iterateMatching((Iterable<String>)explicitlyRequiredIndexActions)) {
                                rolesToExplicitActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(action, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry2.getKey(), (Object)e);
                }
            }
            DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
            this.rolesToActionToIndexPattern = (ImmutableMap)rolesToActionToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableMap)((Map)entry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry2 -> ((IndexPattern.Builder)entry2.getValue()).build()))));
            this.rolesToActionPatternToIndexPattern = (ImmutableMap)rolesToActionPatternToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableMap)((Map)entry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry2 -> ((IndexPattern.Builder)entry2.getValue()).build()))));
            this.actionToRolesWithWildcardIndexPrivileges = (ImmutableMap)actionToRolesWithWildcardIndexPrivileges.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)entry.getValue()).build(completedRoleSetBuilder)));
            this.rolesToExplicitActionToIndexPattern = (ImmutableMap)rolesToExplicitActionToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableMap)((Map)entry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry2 -> ((IndexPattern.Builder)entry2.getValue()).build()))));
            this.wellKnownIndexActions = wellKnownIndexActions;
            this.explicitlyRequiredIndexActions = explicitlyRequiredIndexActions;
        }

        PrivilegesEvaluatorResponse providesPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices, CheckTable<String, String> checkTable, Map<String, IndexAbstraction> indexMetadata) {
            ArrayList<PrivilegesEvaluationException> exceptions = new ArrayList<PrivilegesEvaluationException>();
            for (String role : context.getMappedRoles()) {
                ImmutableMap actionToIndexPattern = (ImmutableMap)this.rolesToActionToIndexPattern.get((Object)role);
                if (actionToIndexPattern == null) continue;
                for (String action : actions) {
                    IndexPattern indexPattern = (IndexPattern)actionToIndexPattern.get((Object)action);
                    if (indexPattern == null) continue;
                    for (String index : checkTable.iterateUncheckedRows((Object)action)) {
                        try {
                            if (!indexPattern.matches(index, context, indexMetadata) || !checkTable.check((Object)index, (Object)action)) continue;
                            return PrivilegesEvaluatorResponse.ok();
                        }
                        catch (PrivilegesEvaluationException e) {
                            log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                            exceptions.add(new PrivilegesEvaluationException("Error while evaluating role " + role, e));
                        }
                    }
                }
            }
            boolean allActionsWellKnown = actions.stream().allMatch(a -> this.wellKnownIndexActions.contains(a));
            if (!checkTable.isComplete() && !allActionsWellKnown) {
                block7: for (String role : context.getMappedRoles()) {
                    ImmutableMap actionPatternToIndexPattern = (ImmutableMap)this.rolesToActionPatternToIndexPattern.get((Object)role);
                    if (actionPatternToIndexPattern == null) continue;
                    for (String action : actions) {
                        if (this.wellKnownIndexActions.contains((Object)action)) continue;
                        for (Map.Entry entry : actionPatternToIndexPattern.entrySet()) {
                            WildcardMatcher actionMatcher = (WildcardMatcher)entry.getKey();
                            IndexPattern indexPattern = (IndexPattern)entry.getValue();
                            if (!actionMatcher.test(action)) continue;
                            for (String index : checkTable.iterateUncheckedRows((Object)action)) {
                                try {
                                    if (!indexPattern.matches(index, context, indexMetadata) || !checkTable.check((Object)index, (Object)action)) continue;
                                    break block7;
                                }
                                catch (PrivilegesEvaluationException e) {
                                    log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                                    exceptions.add(new PrivilegesEvaluationException("Error while evaluating role " + role, e));
                                }
                            }
                        }
                    }
                }
            }
            if (checkTable.isComplete()) {
                return PrivilegesEvaluatorResponse.ok();
            }
            Set availableIndices = checkTable.getCompleteRows();
            if (!availableIndices.isEmpty()) {
                return PrivilegesEvaluatorResponse.partiallyOk(availableIndices, checkTable).evaluationExceptions(exceptions);
            }
            return PrivilegesEvaluatorResponse.insufficient(checkTable).reason((String)(resolvedIndices.getAllIndices().size() == 1 ? "Insufficient permissions for the referenced index" : "None of " + resolvedIndices.getAllIndices().size() + " referenced indices has sufficient permissions")).evaluationExceptions(exceptions);
        }

        PrivilegesEvaluatorResponse providesWildcardPrivilege(PrivilegesEvaluationContext context, Set<String> actions) {
            ImmutableSet<String> effectiveRoles = context.getMappedRoles();
            for (String action : actions) {
                ImmutableCompactSubSet rolesWithWildcardIndexPrivileges = (ImmutableCompactSubSet)this.actionToRolesWithWildcardIndexPrivileges.get((Object)action);
                if (rolesWithWildcardIndexPrivileges != null && rolesWithWildcardIndexPrivileges.containsAny(effectiveRoles)) continue;
                return null;
            }
            return PrivilegesEvaluatorResponse.ok();
        }

        PrivilegesEvaluatorResponse providesExplicitPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices, CheckTable<String, String> checkTable, Map<String, IndexAbstraction> indexMetadata) {
            ArrayList<PrivilegesEvaluationException> exceptions = new ArrayList<PrivilegesEvaluationException>();
            if (!CollectionUtils.containsAny(actions, this.explicitlyRequiredIndexActions)) {
                return PrivilegesEvaluatorResponse.insufficient((CheckTable<String, String>)CheckTable.create((Set)ImmutableSet.of((Object)"_"), actions));
            }
            for (String role : context.getMappedRoles()) {
                ImmutableMap actionToIndexPattern = (ImmutableMap)this.rolesToExplicitActionToIndexPattern.get((Object)role);
                if (actionToIndexPattern == null) continue;
                for (String action : actions) {
                    IndexPattern indexPattern = (IndexPattern)actionToIndexPattern.get((Object)action);
                    if (indexPattern == null) continue;
                    for (String index : checkTable.iterateUncheckedRows((Object)action)) {
                        try {
                            if (!indexPattern.matches(index, context, indexMetadata) || !checkTable.check((Object)index, (Object)action)) continue;
                            return PrivilegesEvaluatorResponse.ok();
                        }
                        catch (PrivilegesEvaluationException e) {
                            log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                            exceptions.add(new PrivilegesEvaluationException("Error while evaluating role " + role, e));
                        }
                    }
                }
            }
            return PrivilegesEvaluatorResponse.insufficient(checkTable).reason("No explicit privileges have been provided for the referenced indices.").evaluationExceptions(exceptions);
        }
    }

    static class StatefulIndexPrivileges {
        private final Map<String, Map<String, ImmutableCompactSubSet<String>>> actionToIndexToRoles;
        private final Map<String, IndexAbstraction> indices;
        private final ImmutableSet<String> wellKnownIndexActions;
        private final int estimatedByteSize;
        private long metadataVersion;

        StatefulIndexPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, ImmutableSet<String> wellKnownIndexActions, Map<String, IndexAbstraction> indices, long metadataVersion, ByteSizeValue statefulIndexMaxHeapSize) {
            HashMap<String, CompactMapGroupBuilder.MapBuilder> actionToIndexToRoles = new HashMap<String, CompactMapGroupBuilder.MapBuilder>();
            DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(roles.getCEntries().keySet());
            CompactMapGroupBuilder indexMapBuilder = new CompactMapGroupBuilder(indices.keySet(), k2 -> roleSetBuilder.createSubSetBuilder());
            block2: for (Map.Entry<String, RoleV7> entry2 : roles.getCEntries().entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    roleSetBuilder.next((Object)roleName);
                    for (RoleV7.Index indexPermissions : role.getIndex_permissions()) {
                        WildcardMatcher indexMatcher;
                        ImmutableSet<String> permissions = actionGroups.resolve(indexPermissions.getAllowed_actions());
                        if (indexPermissions.getIndex_patterns().contains("*") || (indexMatcher = IndexPattern.from(indexPermissions.getIndex_patterns()).getStaticPattern()) == WildcardMatcher.NONE) continue;
                        for (String permission : permissions) {
                            WildcardMatcher actionMatcher = WildcardMatcher.from(permission);
                            List matchedActions = actionMatcher.getMatchAny((Collection<String>)wellKnownIndexActions, Collectors.toList());
                            for (Map.Entry indicesEntry : indexMatcher.iterateMatching(indices.entrySet(), Map.Entry::getKey)) {
                                for (String action : matchedActions) {
                                    CompactMapGroupBuilder.MapBuilder indexToRoles = actionToIndexToRoles.computeIfAbsent(action, k -> indexMapBuilder.createMapBuilder());
                                    ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoles.get((Object)((String)indicesEntry.getKey()))).add((Object)roleName);
                                    if (indicesEntry.getValue() instanceof IndexAbstraction.Alias) {
                                        for (IndexMetadata subIndex : ((IndexAbstraction)indicesEntry.getValue()).getIndices()) {
                                            ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoles.get((Object)subIndex.getIndex().getName())).add((Object)roleName);
                                        }
                                    }
                                    if ((long)(roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize()) <= statefulIndexMaxHeapSize.getBytes()) continue;
                                    log.info("Size of precomputed index privileges exceeds configured limit ({}). Using capped data structure.This might lead to slightly lower performance during privilege evaluation. Consider raising {}.", (Object)statefulIndexMaxHeapSize, (Object)PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE.getKey());
                                    break block2;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry2.getKey(), (Object)e);
                }
            }
            DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
            this.estimatedByteSize = roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize();
            log.debug("Estimated size of StatefulIndexPermissions data structure: {}", (Object)this.estimatedByteSize);
            this.actionToIndexToRoles = (Map)actionToIndexToRoles.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((CompactMapGroupBuilder.MapBuilder)entry.getValue()).build(subSetBuilder -> subSetBuilder.build(completedRoleSetBuilder))));
            this.indices = ImmutableMap.copyOf(indices);
            this.metadataVersion = metadataVersion;
            this.wellKnownIndexActions = wellKnownIndexActions;
        }

        PrivilegesEvaluatorResponse providesPrivilege(Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices, PrivilegesEvaluationContext context, CheckTable<String, String> checkTable, Map<String, IndexAbstraction> indexMetadata) {
            ImmutableSet<String> effectiveRoles = context.getMappedRoles();
            for (String action : actions) {
                Map<String, ImmutableCompactSubSet<String>> indexToRoles = this.actionToIndexToRoles.get(action);
                if (indexToRoles == null) continue;
                Iterator<String> iterator = resolvedIndices.getAllIndices().iterator();
                while (iterator.hasNext()) {
                    ImmutableCompactSubSet<String> rolesWithPrivileges;
                    String index;
                    String lookupIndex = index = iterator.next();
                    if (index.startsWith(".ds-")) {
                        lookupIndex = StatefulIndexPrivileges.backingIndexToDataStream(index, indexMetadata);
                    }
                    if ((rolesWithPrivileges = indexToRoles.get(lookupIndex)) == null || !rolesWithPrivileges.containsAny(effectiveRoles) || !checkTable.check((Object)index, (Object)action)) continue;
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            return null;
        }

        static String backingIndexToDataStream(String index, Map<String, IndexAbstraction> indexMetadata) {
            IndexAbstraction indexAbstraction = indexMetadata.get(index);
            if (indexAbstraction instanceof IndexAbstraction.Index && indexAbstraction.getParentDataStream() != null) {
                return indexAbstraction.getParentDataStream().getName();
            }
            return index;
        }

        static Map<String, IndexAbstraction> relevantOnly(Map<String, IndexAbstraction> indices) {
            boolean doFilter = false;
            for (IndexAbstraction indexAbstraction : indices.values()) {
                if (!(indexAbstraction instanceof IndexAbstraction.Index) || indexAbstraction.getParentDataStream() == null && indexAbstraction.getWriteIndex().getState() != IndexMetadata.State.CLOSE) continue;
                doFilter = true;
                break;
            }
            if (!doFilter) {
                return indices;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (IndexAbstraction indexAbstraction : indices.values()) {
                if (indexAbstraction instanceof IndexAbstraction.Index) {
                    if (indexAbstraction.getParentDataStream() != null || indexAbstraction.getWriteIndex().getState() == IndexMetadata.State.CLOSE) continue;
                    builder.put((Object)indexAbstraction.getName(), (Object)indexAbstraction);
                    continue;
                }
                builder.put((Object)indexAbstraction.getName(), (Object)indexAbstraction);
            }
            return builder.build();
        }
    }
}

