/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.JavaNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.panel.ContentPanel;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JNode
extends DefaultMutableTreeNode
implements Comparable<JNode> {
    private static final long serialVersionUID = -5154479091781041008L;
    private static final Comparator<JNode> COMPARATOR = Comparator.comparing(JNode::makeLongString).thenComparingInt(JNode::getPos);

    public abstract JClass getJParent();

    public JClass getRootClass() {
        return null;
    }

    public JavaNode getJavaNode() {
        return null;
    }

    @Nullable
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        return null;
    }

    public String getSyntaxName() {
        return "text/plain";
    }

    @NotNull
    public ICodeInfo getCodeInfo() {
        return ICodeInfo.EMPTY;
    }

    public abstract Icon getIcon();

    public String getName() {
        JavaNode javaNode = this.getJavaNode();
        if (javaNode == null) {
            return null;
        }
        return javaNode.getName();
    }

    public boolean canRename() {
        return false;
    }

    public abstract String makeString();

    public String makeStringHtml() {
        return this.makeString();
    }

    public String makeDescString() {
        return null;
    }

    public boolean hasDescString() {
        return false;
    }

    public String makeLongString() {
        return this.makeString();
    }

    public String makeLongStringHtml() {
        return this.makeLongString();
    }

    public boolean disableHtml() {
        return true;
    }

    public int getPos() {
        JavaNode javaNode = this.getJavaNode();
        if (javaNode == null) {
            return -1;
        }
        return javaNode.getDefPos();
    }

    public String getTooltip() {
        return this.makeLongStringHtml();
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        return COMPARATOR.compare(this, other);
    }

    @Override
    public String toString() {
        return this.makeString();
    }
}

