/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.actions.generate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenerateDomElementProvider<T extends DomElement> {
    private final @NlsActions.ActionDescription String myDescription;
    private final @NlsActions.ActionText String myText;

    public GenerateDomElementProvider(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description) {
        this.myText = text2;
        this.myDescription = description;
    }

    public boolean isAvailableForElement(@NotNull DomElement contextElement) {
        if (contextElement == null) {
            GenerateDomElementProvider.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Nullable
    public abstract T generate(Project var1, Editor var2, PsiFile var3);

    public void navigate(DomElement element) {
        if (element != null && element.isValid()) {
            Object copy = element.createStableCopy();
            Project project2 = element.getManager().getProject();
            DomElementNavigationProvider navigateProvider = GenerateDomElementProvider.getNavigationProviderName(project2);
            if (navigateProvider != null && navigateProvider.canNavigate((DomElement)copy)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!project2.isDisposed()) {
                        this.doNavigate(navigateProvider, (DomElement)copy);
                    }
                });
            }
        }
    }

    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement copy) {
        navigateProvider.navigate(copy, true);
    }

    protected static DomElementNavigationProvider getNavigationProviderName(Project project2) {
        return DomElementsNavigationManager.getManager(project2).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME);
    }

    @NlsActions.ActionDescription
    public String getDescription() {
        return this.myDescription == null ? "" : this.myDescription;
    }

    @NlsActions.ActionText
    public String getText() {
        return this.myText == null ? "" : this.myText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/util/xml/ui/actions/generate/GenerateDomElementProvider", "isAvailableForElement"));
    }
}

