/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberValueConverter<T extends Number>
extends ResolvingConverter<T> {
    private final Class myNumberClass;
    private final boolean myAllowEmpty;

    public NumberValueConverter(@NotNull Class<T> numberClass, boolean allowEmpty) {
        if (numberClass == null) {
            NumberValueConverter.$$$reportNull$$$0(0);
        }
        this.myNumberClass = numberClass;
        this.myAllowEmpty = allowEmpty;
    }

    @Override
    public T fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            NumberValueConverter.$$$reportNull$$$0(1);
        }
        if (s == null) {
            return null;
        }
        if (this.myAllowEmpty && s.trim().length() == 0) {
            return null;
        }
        return (T)NumberValueConverter.parseNumber(s, this.myNumberClass);
    }

    @Override
    public String toString(@Nullable T value, @NotNull ConvertContext context) {
        if (context == null) {
            NumberValueConverter.$$$reportNull$$$0(2);
        }
        return value == null ? null : NumberValueConverter.parseText(value, this.myNumberClass);
    }

    @Override
    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        boolean isEmpty;
        if (context == null) {
            NumberValueConverter.$$$reportNull$$$0(3);
        }
        if (s == null) {
            return super.getErrorMessage(null, context);
        }
        boolean bl = isEmpty = s.trim().length() == 0;
        if (isEmpty && this.myAllowEmpty) {
            return null;
        }
        return isEmpty ? XmlDomBundle.message("dom.converter.format.exception.empty.string", this.myNumberClass.getName()) : XmlDomBundle.message("dom.converter.format.exception", s, this.myNumberClass.getName());
    }

    @Override
    @NotNull
    public Collection<? extends T> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            NumberValueConverter.$$$reportNull$$$0(4);
        }
        Set set = Collections.emptySet();
        if (set == null) {
            NumberValueConverter.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public static String parseText(@NotNull Number value, @NotNull Class targetClass) {
        if (value == null) {
            NumberValueConverter.$$$reportNull$$$0(6);
        }
        if (targetClass == null) {
            NumberValueConverter.$$$reportNull$$$0(7);
        }
        if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
            return Byte.toString((Byte)value);
        }
        if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
            return Short.toString((Short)value);
        }
        if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
            return Integer.toString((Integer)value);
        }
        if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
            return Long.toString((Long)value);
        }
        if (targetClass.equals(BigInteger.class)) {
            return value.toString();
        }
        if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
            return Float.toString(((Float)value).floatValue());
        }
        if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
            return Double.toString((Double)value);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return ((BigDecimal)value).toPlainString();
        }
        return null;
    }

    @Nullable
    public static Number parseNumber(@NotNull String text2, @NotNull Class targetClass) {
        if (text2 == null) {
            NumberValueConverter.$$$reportNull$$$0(8);
        }
        if (targetClass == null) {
            NumberValueConverter.$$$reportNull$$$0(9);
        }
        try {
            String trimmed = text2.trim();
            if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
                return Byte.decode(trimmed);
            }
            if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
                return Short.decode(trimmed);
            }
            if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
                return Integer.decode(trimmed);
            }
            if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
                return Long.decode(trimmed);
            }
            if (targetClass.equals(BigInteger.class)) {
                return NumberValueConverter.decodeBigInteger(trimmed);
            }
            if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
                return Float.valueOf(trimmed);
            }
            if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
                return Double.valueOf(trimmed);
            }
            if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
                return new BigDecimal(trimmed);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return null;
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result2 = new BigInteger(value.substring(index), radix);
        return negative ? result2.negate() : result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numberClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/converters/values/NumberValueConverter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/converters/values/NumberValueConverter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseNumber";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

