/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.model;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.platform.ml.LevelSignature;
import com.intellij.platform.ml.MLModel;
import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.environment.Environment;
import com.intellij.platform.ml.feature.Feature;
import com.intellij.platform.ml.feature.FeatureDeclaration;
import com.intellij.platform.ml.feature.FeatureSelector;
import com.intellij.platform.ml.impl.model.RegressionModel;
import com.intellij.platform.ml.impl.model.RegressionModelKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u001e\u001f !\"B=\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fBK\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00120\u0010\r\u001a,\u0012(\u0012&\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u000fj\u0002`\u00100\u000e\u00a2\u0006\u0004\b\u000b\u0010\u0011JI\u0010\u0018\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000e2,\u0010\u001b\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00060\u0013j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u0006`\u0015H\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0012\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel;", "Lcom/intellij/platform/ml/MLModel;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "featuresTiers", "", "Lcom/intellij/platform/ml/Tier;", "availableTiers", "featureSerialization", "Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "<init>", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/util/Set;Ljava/util/Set;Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;)V", "sessionTiers", "", "Lcom/intellij/platform/ml/LevelSignature;", "Lcom/intellij/platform/ml/LevelTiers;", "(Lcom/intellij/internal/ml/DecisionFunction;Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;Ljava/util/List;)V", "knownFeatures", "", "Lcom/intellij/platform/ml/feature/FeatureSelector;", "Lcom/intellij/platform/ml/PerTier;", "getKnownFeatures", "()Ljava/util/Map;", "predict", "callParameters", "Lcom/intellij/platform/ml/environment/Environment;", "features", "Lcom/intellij/platform/ml/feature/Feature;", "(Ljava/util/List;Ljava/util/Map;)Ljava/lang/Double;", "FeatureNameSerialization", "DefaultFeatureSerialization", "SelectionMissingFeatures", "DecisionFunctionWrapper", "Companion", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,172:1\n11165#2:173\n11500#2,2:174\n11502#2:182\n1202#3,2:176\n1230#3,4:178\n1557#3:186\n1628#3,3:187\n1187#3,2:193\n1261#3,4:195\n77#4:183\n97#4,2:184\n99#4,3:190\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel\n*L\n29#1:173\n29#1:174,2\n29#1:182\n30#1:176,2\n30#1:178,4\n44#1:186\n44#1:187,3\n45#1:193,2\n45#1:195,4\n44#1:183\n44#1:184,2\n44#1:190,3\n*E\n"})
public class RegressionModel
implements MLModel<Double> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DecisionFunction decisionFunction;
    @NotNull
    private final Set<Tier<?>> featuresTiers;
    @NotNull
    private final FeatureNameSerialization featureSerialization;
    @NotNull
    private final Map<Tier<?>, FeatureSelector> knownFeatures;

    private RegressionModel(DecisionFunction decisionFunction, Set<? extends Tier<?>> featuresTiers, Set<? extends Tier<?>> availableTiers, FeatureNameSerialization featureSerialization) {
        this.decisionFunction = decisionFunction;
        this.featuresTiers = featuresTiers;
        this.featureSerialization = featureSerialization;
        this.knownFeatures = RegressionModel.Companion.createFeatureSelectors(new DecisionFunctionWrapper(this.decisionFunction, availableTiers, this.featureSerialization), this.featuresTiers);
    }

    /*
     * WARNING - void declaration
     */
    public RegressionModel(@NotNull DecisionFunction decisionFunction, @NotNull FeatureNameSerialization featureSerialization, @NotNull List<LevelSignature<Set<Tier<?>>, Set<Tier<?>>>> sessionTiers) {
        Collection<Tier> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
        Intrinsics.checkNotNullParameter((Object)featureSerialization, (String)"featureSerialization");
        Intrinsics.checkNotNullParameter(sessionTiers, (String)"sessionTiers");
        FeatureMapper[] featureMapperArray = decisionFunction.getFeaturesOrder();
        Intrinsics.checkNotNullExpressionValue((Object)featureMapperArray, (String)"getFeaturesOrder(...)");
        Object[] objectArray = featureMapperArray;
        DecisionFunction decisionFunction2 = decisionFunction;
        RegressionModel regressionModel = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            Map map;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            void it;
            FeatureMapper featureMapper = (FeatureMapper)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getFeatureName(), (String)"getFeatureName(...)");
            Iterable iterable = RegressionModelKt.access$flatten(sessionTiers);
            FeatureNameSerialization featureNameSerialization = featureSerialization;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var19_21 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it2;
                Tier tier = (Tier)element$iv$iv;
                map = destination$iv$iv2;
                boolean bl2 = false;
                map.put(it2.getName(), element$iv$iv);
            }
            map = destination$iv$iv2;
            collection.add((Tier)featureNameSerialization.deserialize(string2, map).getFirst());
        }
        collection = (List)destination$iv$iv;
        regressionModel(decisionFunction2, CollectionsKt.toSet((Iterable)collection), RegressionModelKt.access$flatten(sessionTiers), featureSerialization);
    }

    @NotNull
    public Map<Tier<?>, FeatureSelector> getKnownFeatures() {
        return this.knownFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Double predict(@NotNull List<? extends Environment> callParameters, @NotNull Map<Tier<?>, ? extends Set<? extends Feature>> features) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(callParameters, (String)"callParameters");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        double[] array = new double[this.decisionFunction.getFeaturesOrder().length];
        Map<Tier<?>, Set<Feature>> map = features;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry2 = element$iv$iv = iterator.next();
            boolean bl = false;
            Tier tier = (Tier)entry2.getKey();
            Set tierFeatures = (Set)entry2.getValue();
            Iterable $this$map$iv = tierFeatures;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Feature feature = (Feature)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)tier, (Object)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv3;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            Tier tier = (Tier)pair.component1();
            Feature feature = (Feature)pair.component2();
            pair = TuplesKt.to((Object)this.featureSerialization.serialize(tier, feature.getDeclaration().getName()), (Object)feature);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map featurePerSerializedName = destination$iv$iv3;
        if (!Intrinsics.areEqual(features.keySet(), this.featuresTiers)) {
            boolean bl = false;
            String string2 = "Given features tiers are " + features.keySet() + ", but this model needs " + this.featuresTiers;
            throw new IllegalArgumentException(string2.toString());
        }
        int n = this.decisionFunction.getFeaturesOrder().length;
        for (int featureI = 0; featureI < n; ++featureI) {
            double featureValue;
            String featureSerializedName;
            FeatureMapper featureMapper = this.decisionFunction.getFeaturesOrder()[featureI];
            Intrinsics.checkNotNullExpressionValue((Object)featureMapper.getFeatureName(), (String)"getFeatureName(...)");
            Feature feature = (Feature)featurePerSerializedName.get(featureSerializedName);
            array[featureI] = featureValue = featureMapper.asArrayValue(feature != null ? feature.getValue() : null);
        }
        return this.decisionFunction.predict(array);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$Companion;", "", "<init>", "()V", "createFeatureSelectors", "", "Lcom/intellij/platform/ml/Tier;", "Lcom/intellij/platform/ml/feature/FeatureSelector;", "Lcom/intellij/platform/ml/PerTier;", "decisionFunction", "Lcom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper;", "featuresTiers", "", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1279#2,2:173\n1293#2,4:175\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$Companion\n*L\n164#1:173,2\n164#1:175,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Tier<?>, FeatureSelector> createFeatureSelectors(DecisionFunctionWrapper decisionFunction, Set<? extends Tier<?>> featuresTiers) {
            Map<Tier<?>, Set<String>> requiredFeaturesPerTier = decisionFunction.getRequiredFeaturesPerTier();
            Iterable $this$associateWith$iv = featuresTiers;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                Tier tier = (Tier)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                createFeatureSelectors.createFeatureSelector.1 var15_15 = com.intellij.platform.ml.impl.model.RegressionModel$Companion.createFeatureSelectors$createFeatureSelector(decisionFunction, requiredFeaturesPerTier, it);
                map.put(t, var15_15);
            }
            return result$iv;
        }

        private static final createFeatureSelectors.createFeatureSelector.1 createFeatureSelectors$createFeatureSelector(DecisionFunctionWrapper $decisionFunction, Map<Tier<?>, ? extends Set<String>> requiredFeaturesPerTier, Tier<?> tier) {
            return new FeatureSelector($decisionFunction, tier, requiredFeaturesPerTier){
                final /* synthetic */ DecisionFunctionWrapper $decisionFunction;
                final /* synthetic */ Tier<?> $tier;
                final /* synthetic */ Map<Tier<?>, Set<String>> $requiredFeaturesPerTier;
                {
                    Map<Tier<?>, Set<String>> knownFeatures;
                    this.$decisionFunction = $decisionFunction;
                    this.$tier = $tier;
                    this.$requiredFeaturesPerTier = $requiredFeaturesPerTier;
                    Map<Tier<?>, Set<String>> $this$forEach$iv = knownFeatures = $decisionFunction.getKnownFeatures();
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<Tier<?>, Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Set<String> tierFeatures;
                        Map.Entry<Tier<?>, Set<String>> element$iv;
                        Map.Entry<Tier<?>, Set<String>> entry2 = element$iv = iterator.next();
                        boolean bl = false;
                        Tier<?> tier = entry2.getKey();
                        Set<String> nonConsistentlyKnownFeatures = $decisionFunction.getUnknownFeatures(tier, tierFeatures = entry2.getValue());
                        if (nonConsistentlyKnownFeatures.isEmpty()) continue;
                        boolean bl2 = false;
                        String string2 = "These features are known and unknown at the same time: " + nonConsistentlyKnownFeatures;
                        throw new IllegalArgumentException(string2.toString());
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public FeatureSelector.Selection select(Set<? extends FeatureDeclaration<?>> availableFeatures) {
                    Set requiredFeaturesNames;
                    void $this$mapTo$iv$iv;
                    void $this$mapTo$iv$iv2;
                    FeatureDeclaration it;
                    Object object;
                    Iterable $this$associateByTo$iv$iv;
                    Intrinsics.checkNotNullParameter(availableFeatures, (String)"availableFeatures");
                    Iterable $this$associateBy$iv = availableFeatures;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associateBy$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv : $this$associateByTo$iv$iv) {
                        FeatureDeclaration featureDeclaration = (FeatureDeclaration)element$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.put(it.getName(), element$iv$iv);
                    }
                    Map availableFeaturesPerName = destination$iv$iv;
                    Iterable $this$map$iv = availableFeatures;
                    boolean $i$f$map = false;
                    $this$associateByTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        it = (FeatureDeclaration)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.add(it.getName());
                    }
                    Set availableFeaturesNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    Set<String> unknownFeaturesNames = this.$decisionFunction.getUnknownFeatures(this.$tier, availableFeaturesNames);
                    Set knownAvailableFeaturesNames = SetsKt.minus((Set)availableFeaturesNames, (Iterable)unknownFeaturesNames);
                    Iterable $this$map$iv2 = knownAvailableFeaturesNames;
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string2 = (String)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl = false;
                        object.add((FeatureDeclaration)MapsKt.getValue((Map)availableFeaturesPerName, (Object)it2));
                    }
                    Set knownAvailableFeatures = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    Set set = this.$requiredFeaturesPerTier.get(this.$tier);
                    if (set == null) {
                        set = SetsKt.emptySet();
                    }
                    return availableFeaturesNames.containsAll(requiredFeaturesNames = set) ? (FeatureSelector.Selection)new FeatureSelector.Selection.Complete(knownAvailableFeatures) : (FeatureSelector.Selection)new SelectionMissingFeatures(knownAvailableFeatures, SetsKt.minus((Set)requiredFeaturesNames, (Iterable)availableFeaturesNames));
                }

                public boolean select(FeatureDeclaration<?> featureDeclaration) {
                    Intrinsics.checkNotNullParameter(featureDeclaration, (String)"featureDeclaration");
                    return this.$decisionFunction.getUnknownFeatures(this.$tier, SetsKt.setOf((Object)featureDeclaration.getName())).isEmpty();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\u000e\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00050\fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0005`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R7\u0010\u0012\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00050\fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0005`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "availableTiers", "", "Lcom/intellij/platform/ml/Tier;", "featureNameSerialization", "Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "<init>", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/util/Set;Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;)V", "availableTiersPerName", "", "", "knownFeatures", "Lcom/intellij/platform/ml/PerTier;", "getKnownFeatures", "()Ljava/util/Map;", "requiredFeaturesPerTier", "getRequiredFeaturesPerTier", "getUnknownFeatures", "tier", "featuresNames", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,172:1\n1202#2,2:173\n1230#2,4:175\n1557#2:183\n1628#2,3:184\n1498#2:187\n1528#2,3:188\n1531#2,3:198\n1246#2,4:203\n1202#2,2:207\n1230#2,4:209\n1557#2:213\n1628#2,3:214\n1498#2:217\n1528#2,3:218\n1531#2,3:228\n1246#2,4:233\n827#2:237\n855#2,2:238\n11165#3:179\n11500#3,3:180\n381#4,7:191\n462#4:201\n412#4:202\n381#4,7:221\n462#4:231\n412#4:232\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper\n*L\n104#1:173,2\n104#1:175,4\n109#1:183\n109#1:184,3\n110#1:187\n110#1:188,3\n110#1:198,3\n111#1:203,4\n115#1:207,2\n115#1:209,4\n118#1:213\n118#1:214,3\n119#1:217\n119#1:218,3\n119#1:228,3\n120#1:233,4\n125#1:237\n125#1:238,2\n107#1:179\n107#1:180,3\n110#1:191,7\n111#1:201\n111#1:202\n119#1:221,7\n120#1:231\n120#1:232\n*E\n"})
    private static final class DecisionFunctionWrapper {
        @NotNull
        private final DecisionFunction decisionFunction;
        @NotNull
        private final Set<Tier<?>> availableTiers;
        @NotNull
        private final FeatureNameSerialization featureNameSerialization;
        @NotNull
        private final Map<String, Tier<?>> availableTiersPerName;
        @NotNull
        private final Map<Tier<?>, Set<String>> knownFeatures;
        @NotNull
        private final Map<Tier<?>, Set<String>> requiredFeaturesPerTier;

        /*
         * WARNING - void declaration
         */
        public DecisionFunctionWrapper(@NotNull DecisionFunction decisionFunction, @NotNull Set<? extends Tier<?>> availableTiers, @NotNull FeatureNameSerialization featureNameSerialization) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$associateByTo$iv$iv;
            void $this$requiredFeaturesPerTier_u24lambda_u2412;
            Set<Object> set;
            void $this$mapValuesTo$iv$iv2;
            void $this$mapValues$iv2;
            Object value$iv$iv$iv;
            Object $this$getOrPut$iv$iv$iv;
            void $this$groupByTo$iv$iv2;
            Object $this$groupBy$iv2;
            Pair it;
            Object object;
            String item$iv$iv2;
            Object $this$mapTo$iv$iv2;
            DecisionFunctionWrapper $this$knownFeatures_u24lambda_u246;
            void $this$associateByTo$iv$iv2;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter(availableTiers, (String)"availableTiers");
            Intrinsics.checkNotNullParameter((Object)featureNameSerialization, (String)"featureNameSerialization");
            this.decisionFunction = decisionFunction;
            this.availableTiers = availableTiers;
            this.featureNameSerialization = featureNameSerialization;
            Iterable iterable = this.availableTiers;
            DecisionFunctionWrapper decisionFunctionWrapper = this;
            boolean $i$f$associateBy22 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var7_9 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
                void it2;
                Tier tier = (Tier)element$iv$iv;
                Map map = destination$iv$iv;
                int n = 0;
                map.put(it2.getName(), element$iv$iv);
            }
            decisionFunctionWrapper.availableTiersPerName = destination$iv$iv;
            DecisionFunctionWrapper $i$f$associateBy22 = this;
            decisionFunctionWrapper = this;
            boolean bl = false;
            FeatureMapper[] featureMapperArray = $this$knownFeatures_u24lambda_u246.decisionFunction.getFeaturesOrder();
            Intrinsics.checkNotNullExpressionValue((Object)featureMapperArray, (String)"getFeaturesOrder(...)");
            Object $this$map$iv2 = featureMapperArray;
            boolean $i$f$map = false;
            Object[] $i$f$associateByTo22 = $this$map$iv2;
            Object destination$iv$iv2 = new ArrayList(((Object[])$this$map$iv2).length);
            boolean $i$f$mapTo = false;
            for (String item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it3;
                FeatureMapper featureMapper = (FeatureMapper)item$iv$iv2;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(it3.getFeatureName());
            }
            Set knownFeaturesSerializedNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            $this$map$iv2 = knownFeaturesSerializedNames;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            Iterator it2 = $this$mapTo$iv$iv2.iterator();
            while (it2.hasNext()) {
                Object item$iv$iv3 = it2.next();
                item$iv$iv2 = (String)item$iv$iv3;
                object = destination$iv$iv2;
                boolean bl3 = false;
                FeatureNameSerialization featureNameSerialization2 = $this$knownFeatures_u24lambda_u246.featureNameSerialization;
                Intrinsics.checkNotNull((Object)it);
                object.add(featureNameSerialization2.deserialize((String)it, $this$knownFeatures_u24lambda_u246.availableTiersPerName));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv2 = $this$groupBy$iv2;
            destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                void it4;
                Object object2;
                it = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$knownFeatures$1$42 = false;
                Tier key$iv$iv2 = (Tier)it.getFirst();
                $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                Pair $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$knownFeatures$1$42 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl5 = false;
                object.add((String)it4.getSecond());
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv2 = $this$mapValues$iv2;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo32 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it5;
                void it$iv$iv;
                Map.Entry key$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean bl6 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = $this$getOrPut$iv$iv$iv;
                boolean bl7 = false;
                set = CollectionsKt.toSet((Iterable)((Iterable)it5.getValue()));
                object.put(k, set);
            }
            decisionFunctionWrapper.knownFeatures = destination$iv$iv2;
            $this$knownFeatures_u24lambda_u246 = this;
            decisionFunctionWrapper = this;
            boolean bl8 = false;
            Iterable $this$associateBy$iv2 = $this$requiredFeaturesPerTier_u24lambda_u2412.availableTiers;
            boolean $i$f$associateBy32 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
            destination$iv$iv2 = $this$associateBy$iv2;
            Object destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it6;
                Tier element$iv$iv$iv = (Tier)element$iv$iv;
                object = destination$iv$iv3;
                boolean bl9 = false;
                object.put(it6.getName(), element$iv$iv);
            }
            Map availableTiersPerName = destination$iv$iv3;
            List list2 = $this$requiredFeaturesPerTier_u24lambda_u2412.decisionFunction.getRequiredFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRequiredFeatures(...)");
            Set requiredFeaturesSerializedNames = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)list2));
            Iterable $i$f$associateBy32 = requiredFeaturesSerializedNames;
            boolean $i$f$map2 = false;
            $this$associateByTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator $i$f$associateByTo32 = $this$mapTo$iv$iv.iterator();
            while ($i$f$associateByTo32.hasNext()) {
                void serializedFeatureName;
                String it6 = item$iv$iv2 = $i$f$associateByTo32.next();
                object = destination$iv$iv3;
                boolean bl10 = false;
                object.add($this$requiredFeaturesPerTier_u24lambda_u2412.featureNameSerialization.deserialize((String)serializedFeatureName, availableTiersPerName));
            }
            $this$map$iv = (List)destination$iv$iv3;
            boolean $i$f$groupBy2 = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it7;
                Object object3;
                Pair it8 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$requiredFeaturesPerTier$1$42 = false;
                key$iv$iv = (Tier)it8.getFirst();
                Object $this$getOrPut$iv$iv$iv2 = destination$iv$iv3;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv2 == null) {
                    boolean bl11 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv2;
                }
                List list$iv$iv = (List)object3;
                Pair $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$requiredFeaturesPerTier$1$42 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl12 = false;
                object.add((String)it7.getSecond());
            }
            $this$groupBy$iv = destination$iv$iv3;
            boolean $i$f$mapValues2 = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo2 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo4 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it9;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object4 = destination$iv$iv3;
                boolean bl13 = false;
                Map.Entry value$iv$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                set = it$iv$iv.getKey();
                object = object4;
                boolean bl14 = false;
                Set set2 = CollectionsKt.toSet((Iterable)((Iterable)it9.getValue()));
                object.put(set, set2);
            }
            decisionFunctionWrapper.requiredFeaturesPerTier = destination$iv$iv3;
        }

        @NotNull
        public final Map<Tier<?>, Set<String>> getKnownFeatures() {
            return this.knownFeatures;
        }

        @NotNull
        public final Map<Tier<?>, Set<String>> getRequiredFeaturesPerTier() {
            return this.requiredFeaturesPerTier;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getUnknownFeatures(@NotNull Tier<?> tier, @NotNull Set<String> featuresNames) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter(tier, (String)"tier");
            Intrinsics.checkNotNullParameter(featuresNames, (String)"featuresNames");
            Set<String> set = this.knownFeatures.get(tier);
            if (set == null) {
                return featuresNames;
            }
            Set<String> knownTierFeatures = set;
            Iterable $this$filterNot$iv = featuresNames;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (knownTierFeatures.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J8\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u00072\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$DefaultFeatureSerialization;", "Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "<init>", "()V", "SERIALIZED_FEATURE_SEPARATOR", "", "serialize", "", "tier", "Lcom/intellij/platform/ml/Tier;", "featureName", "deserialize", "Lkotlin/Pair;", "serializedFeatureName", "availableTiersPerName", "", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DefaultFeatureSerialization\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n170#2,6:173\n1#3:179\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DefaultFeatureSerialization\n*L\n76#1:173,6\n*E\n"})
    public static final class DefaultFeatureSerialization
    implements FeatureNameSerialization {
        @NotNull
        public static final DefaultFeatureSerialization INSTANCE = new DefaultFeatureSerialization();
        private static final char SERIALIZED_FEATURE_SEPARATOR = (char)47;

        private DefaultFeatureSerialization() {
        }

        @Override
        @NotNull
        public String serialize(@NotNull Tier<?> tier, @NotNull String featureName) {
            Intrinsics.checkNotNullParameter(tier, (String)"tier");
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            return tier.getName() + SERIALIZED_FEATURE_SEPARATOR + featureName;
        }

        @Override
        @NotNull
        public Pair<Tier<?>, String> deserialize(@NotNull String serializedFeatureName, @NotNull Map<String, ? extends Tier<?>> availableTiersPerName) {
            int indexOfLastSeparator;
            block4: {
                int n;
                Intrinsics.checkNotNullParameter((Object)serializedFeatureName, (String)"serializedFeatureName");
                Intrinsics.checkNotNullParameter(availableTiersPerName, (String)"availableTiersPerName");
                CharSequence $this$indexOfLast$iv = serializedFeatureName;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == SERIALIZED_FEATURE_SEPARATOR)) continue;
                        n = index$iv;
                        break block4;
                    } while (0 <= n2);
                }
                n = indexOfLastSeparator = -1;
            }
            if (!(indexOfLastSeparator >= 0)) {
                boolean $i$a$-require-RegressionModel$DefaultFeatureSerialization$deserialize$22 = false;
                String $i$a$-require-RegressionModel$DefaultFeatureSerialization$deserialize$22 = "Feature name '" + serializedFeatureName + "' does not contain tier's name";
                throw new IllegalArgumentException($i$a$-require-RegressionModel$DefaultFeatureSerialization$deserialize$22.toString());
            }
            String featureTierName = StringsKt.slice((String)serializedFeatureName, (IntRange)RangesKt.until((int)0, (int)indexOfLastSeparator));
            String featureName = StringsKt.slice((String)serializedFeatureName, (IntRange)RangesKt.until((int)indexOfLastSeparator, (int)serializedFeatureName.length()));
            Tier<?> tier = availableTiersPerName.get(featureTierName);
            if (tier == null) {
                boolean bl = false;
                String string2 = StringsKt.trimIndent((String)("\n          Serialized feature '" + serializedFeatureName + "' has tier " + featureTierName + ",\n          but all available tiers are " + availableTiersPerName.keySet() + "\n        "));
                throw new IllegalArgumentException(string2.toString());
            }
            Tier<?> featureTier = tier;
            return TuplesKt.to(featureTier, (Object)featureName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J8\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\t\u001a\u00020\u00032\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "", "serialize", "", "tier", "Lcom/intellij/platform/ml/Tier;", "featureName", "deserialize", "Lkotlin/Pair;", "serializedFeatureName", "availableTiersPerName", "", "intellij.platform.ml.impl"})
    public static interface FeatureNameSerialization {
        @NotNull
        public String serialize(@NotNull Tier<?> var1, @NotNull String var2);

        @NotNull
        public Pair<Tier<?>, String> deserialize(@NotNull String var1, @NotNull Map<String, ? extends Tier<?>> var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$SelectionMissingFeatures;", "Lcom/intellij/platform/ml/feature/FeatureSelector$Selection$Incomplete;", "selectedFeatures", "", "Lcom/intellij/platform/ml/feature/FeatureDeclaration;", "missingFeatures", "", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "details", "getDetails", "()Ljava/lang/String;", "intellij.platform.ml.impl"})
    public static final class SelectionMissingFeatures
    extends FeatureSelector.Selection.Incomplete {
        @NotNull
        private final String details;

        public SelectionMissingFeatures(@NotNull Set<? extends FeatureDeclaration<?>> selectedFeatures, @NotNull Set<String> missingFeatures) {
            Intrinsics.checkNotNullParameter(selectedFeatures, (String)"selectedFeatures");
            Intrinsics.checkNotNullParameter(missingFeatures, (String)"missingFeatures");
            super(selectedFeatures);
            this.details = "Regression model requires more features to run. Missing: " + missingFeatures + ", Has: " + selectedFeatures;
        }

        @NotNull
        public String getDetails() {
            return this.details;
        }
    }
}

