/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorInputMethodSupport;
import com.intellij.openapi.editor.impl.InputMethodInlayRenderer;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.TerminalStarter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputEditorInputMethodSupport;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputEditorInputMethodSupportKt;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "caretModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;)V", "inputMethodRequests", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$MyInputMethodRequests;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "install", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "handleInputMethodTextChanged", "event", "Ljava/awt/event/InputMethodEvent;", "collectString", "", "text", "Ljava/text/AttributedCharacterIterator;", "count", "", "MyInputMethodRequests", "intellij.terminal"})
public final class TerminalOutputEditorInputMethodSupport {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final TerminalCaretModel caretModel;
    @NotNull
    private final MyInputMethodRequests inputMethodRequests;
    @Nullable
    private Inlay<?> inlay;

    public TerminalOutputEditorInputMethodSupport(@NotNull EditorEx editor, @NotNull BlockTerminalSession session2, @NotNull TerminalCaretModel caretModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)caretModel, (String)"caretModel");
        this.editor = editor;
        this.session = session2;
        this.caretModel = caretModel;
        this.inputMethodRequests = new MyInputMethodRequests();
    }

    public final void install(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        if (!this.editor.isViewer()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        MouseAdapter mouseListener2 = new MouseAdapter(this){
            final /* synthetic */ TerminalOutputEditorInputMethodSupport this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                block1: {
                    if (TerminalOutputEditorInputMethodSupport.access$getInlay$p(this.this$0) == null || TerminalOutputEditorInputMethodSupport.access$getEditor$p(this.this$0).isDisposed()) break block1;
                    InputContext inputContext = TerminalOutputEditorInputMethodSupport.access$getEditor$p(this.this$0).getContentComponent().getInputContext();
                    if (inputContext != null) {
                        inputContext.endComposition();
                    }
                }
            }
        };
        this.editor.getContentComponent().addMouseListener(mouseListener2);
        InputMethodListener inputMethodListener2 = new InputMethodListener(this){
            final /* synthetic */ TerminalOutputEditorInputMethodSupport this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputMethodTextChanged(InputMethodEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!TerminalOutputEditorInputMethodSupport.access$getEditor$p(this.this$0).isDisposed()) {
                    TerminalOutputEditorInputMethodSupport.access$handleInputMethodTextChanged(this.this$0, event);
                }
                event.consume();
            }

            public void caretPositionChanged(InputMethodEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                event.consume();
            }
        };
        EditorEx editorEx = this.editor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        ((EditorImpl)editorEx).setInputMethodSupport(new EditorInputMethodSupport((InputMethodRequests)this.inputMethodRequests, inputMethodListener2));
        Disposer.register((Disposable)parentDisposable, () -> TerminalOutputEditorInputMethodSupport.install$lambda$0(this, mouseListener2));
    }

    private final void handleInputMethodTextChanged(InputMethodEvent event) {
        Inlay<?> inlay = this.inlay;
        if (inlay != null) {
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.inlay = null;
        AttributedCharacterIterator text = event.getText();
        if (text != null) {
            text.first();
            String committedString = this.collectString(text, event.getCommittedCharacterCount());
            LogicalPosition cursorPosition = this.caretModel.getCaretPosition();
            if (((CharSequence)committedString).length() > 0) {
                TerminalStarter terminalStarter = this.session.getTerminalStarterFuture$intellij_terminal().getNow(null);
                if (terminalStarter != null) {
                    terminalStarter.sendString(committedString, true);
                }
            }
            if (cursorPosition == null) {
                return;
            }
            String composedString = TerminalOutputEditorInputMethodSupport.collectString$default(this, text, 0, 2, null);
            if (((CharSequence)composedString).length() > 0) {
                int cursorOffset = this.editor.logicalPositionToOffset(cursorPosition);
                this.inlay = this.editor.getInlayModel().addInlineElement(cursorOffset, true, -1000000, (EditorCustomElementRenderer)new InputMethodInlayRenderer(composedString));
            }
        }
    }

    private final String collectString(AttributedCharacterIterator text, int count) {
        StringBuilder result = new StringBuilder();
        char c = text.current();
        for (int processedChars = 0; c != '\uffff' && processedChars < count; ++processedChars) {
            if (c >= ' ' && c != '\u007f') {
                result.append(c);
            }
            c = text.next();
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String collectString$default(TerminalOutputEditorInputMethodSupport terminalOutputEditorInputMethodSupport, AttributedCharacterIterator attributedCharacterIterator, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return terminalOutputEditorInputMethodSupport.collectString(attributedCharacterIterator, n);
    }

    private static final void install$lambda$0(TerminalOutputEditorInputMethodSupport this$0, install.mouseListener.1 $mouseListener) {
        ((EditorImpl)this$0.editor).getContentComponent().removeMouseListener((MouseListener)$mouseListener);
        ((EditorImpl)this$0.editor).setInputMethodSupport(null);
    }

    public static final /* synthetic */ Inlay access$getInlay$p(TerminalOutputEditorInputMethodSupport $this) {
        return $this.inlay;
    }

    public static final /* synthetic */ void access$handleInputMethodTextChanged(TerminalOutputEditorInputMethodSupport $this, InputMethodEvent event) {
        $this.handleInputMethodTextChanged(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J/\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J!\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport$MyInputMethodRequests;", "Ljava/awt/im/InputMethodRequests;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputEditorInputMethodSupport;)V", "getTextLocation", "Ljava/awt/Rectangle;", "offset", "Ljava/awt/font/TextHitInfo;", "getLocationOffset", "x", "", "y", "getInsertPositionOffset", "getCommittedText", "Ljava/text/AttributedCharacterIterator;", "beginIndex", "endIndex", "attributes", "", "Ljava/text/AttributedCharacterIterator$Attribute;", "(II[Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getCommittedTextLength", "cancelLatestCommittedText", "([Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getSelectedText", "intellij.terminal"})
    private final class MyInputMethodRequests
    implements InputMethodRequests {
        @Override
        @NotNull
        public Rectangle getTextLocation(@Nullable TextHitInfo offset) {
            if (TerminalOutputEditorInputMethodSupport.this.editor.isDisposed()) {
                return new Rectangle();
            }
            LogicalPosition logicalPosition = TerminalOutputEditorInputMethodSupport.this.caretModel.getCaretPosition();
            if (logicalPosition == null) {
                return new Rectangle();
            }
            LogicalPosition cursorPosition = logicalPosition;
            Point point = TerminalOutputEditorInputMethodSupport.this.editor.logicalPositionToXY(cursorPosition);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"logicalPositionToXY(...)");
            Point caret = point;
            Rectangle r = new Rectangle(caret, new Dimension(1, TerminalOutputEditorInputMethodSupport.this.editor.getLineHeight()));
            JComponent jComponent = TerminalOutputEditorInputMethodSupport.this.editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            Point p = TerminalOutputEditorInputMethodSupportKt.access$getLocationOnScreen(jComponent);
            r.translate(p.x, p.y);
            return r;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            LogicalPosition logicalPosition = TerminalOutputEditorInputMethodSupport.this.caretModel.getCaretPosition();
            if (logicalPosition == null) {
                return 0;
            }
            LogicalPosition cursorLogicalPosition = logicalPosition;
            return TerminalOutputEditorInputMethodSupport.this.editor.logicalPositionToOffset(cursorLogicalPosition);
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, @Nullable AttributedCharacterIterator.Attribute[] attributes) {
            String committed = TerminalOutputEditorInputMethodSupportKt.access$getText((Editor)TerminalOutputEditorInputMethodSupport.this.editor, beginIndex, endIndex);
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
            Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            return TerminalOutputEditorInputMethodSupport.this.editor.getDocument().getTextLength();
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }
    }
}

