/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.text.VersionComparatorUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInspection/MustAlreadyBeRemovedApiInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "currentVersion", "", "getCurrentVersion", "()Ljava/lang/String;", "setCurrentVersion", "(Ljava/lang/String;)V", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "MustAlreadyBeRemovedApiVisitor", "intellij.jvm.analysis.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nMustAlreadyBeRemovedApiInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MustAlreadyBeRemovedApiInspection.kt\ncom/intellij/codeInspection/MustAlreadyBeRemovedApiInspection\n+ 2 MustAlreadyBeRemovedApiInspection.kt\ncom/intellij/codeInspection/MustAlreadyBeRemovedApiInspectionKt\n*L\n1#1,76:1\n18#2:77\n*S KotlinDebug\n*F\n+ 1 MustAlreadyBeRemovedApiInspection.kt\ncom/intellij/codeInspection/MustAlreadyBeRemovedApiInspection\n*L\n31#1:77\n*E\n"})
public final class MustAlreadyBeRemovedApiInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    private String currentVersion = "";

    @NotNull
    public final String getCurrentVersion() {
        return this.currentVersion;
    }

    public final void setCurrentVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.currentVersion = string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.string((String)"currentVersion", (String)JvmAnalysisBundle.message("current.version", new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                if (((CharSequence)this.currentVersion).length() == 0) break block2;
                boolean $i$f$getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME = false;
                String string = ApiStatus.ScheduledForRemoval.class.getCanonicalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME>(...)");
                PsiFile psiFile = holder.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                if (AnnotatedApiUsageUtil.INSTANCE.canAnnotationBeUsedInFile(string, psiFile)) break block3;
            }
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UDeclaration.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new MustAlreadyBeRemovedApiVisitor(holder, this.currentVersion), classArray, true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInspection/MustAlreadyBeRemovedApiInspection$MustAlreadyBeRemovedApiVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "currentVersion", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Ljava/lang/String;)V", "visitDeclaration", "", "node", "Lorg/jetbrains/uast/UDeclaration;", "getVersionOfScheduledRemoval", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nMustAlreadyBeRemovedApiInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MustAlreadyBeRemovedApiInspection.kt\ncom/intellij/codeInspection/MustAlreadyBeRemovedApiInspection$MustAlreadyBeRemovedApiVisitor\n+ 2 MustAlreadyBeRemovedApiInspection.kt\ncom/intellij/codeInspection/MustAlreadyBeRemovedApiInspectionKt\n*L\n1#1,76:1\n18#2:77\n*S KotlinDebug\n*F\n+ 1 MustAlreadyBeRemovedApiInspection.kt\ncom/intellij/codeInspection/MustAlreadyBeRemovedApiInspection$MustAlreadyBeRemovedApiVisitor\n*L\n69#1:77\n*E\n"})
    private static final class MustAlreadyBeRemovedApiVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder problemsHolder;
        @NotNull
        private final String currentVersion;

        public MustAlreadyBeRemovedApiVisitor(@NotNull ProblemsHolder problemsHolder, @NotNull String currentVersion) {
            Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
            Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
            this.problemsHolder = problemsHolder;
            this.currentVersion = currentVersion;
        }

        public boolean visitDeclaration(@NotNull UDeclaration node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            String versionOfScheduledRemoval = this.getVersionOfScheduledRemoval((UAnnotated)node);
            if (versionOfScheduledRemoval != null && VersionComparatorUtil.compare((String)this.currentVersion, (String)versionOfScheduledRemoval) >= 0) {
                String string;
                if (Intrinsics.areEqual((Object)this.currentVersion, (Object)versionOfScheduledRemoval)) {
                    var4_3 = new Object[]{this.currentVersion};
                    string = JvmAnalysisBundle.message("jvm.inspections.must.already.be.removed.api.current.version.description", var4_3);
                } else {
                    var4_3 = new Object[]{versionOfScheduledRemoval, this.currentVersion};
                    string = JvmAnalysisBundle.message("jvm.inspections.must.already.be.removed.api.earlier.version.description", var4_3);
                }
                String message = string;
                Intrinsics.checkNotNull((Object)message);
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.problemsHolder, (UDeclaration)node, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            }
            return true;
        }

        private final String getVersionOfScheduledRemoval(UAnnotated annotated) {
            boolean $i$f$getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME = false;
            String string = ApiStatus.ScheduledForRemoval.class.getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME>(...)");
            UAnnotation uAnnotation = annotated.findAnnotation(string);
            if (uAnnotation == null) {
                return null;
            }
            UAnnotation annotation = uAnnotation;
            UExpression uExpression = annotation.findDeclaredAttributeValue("inVersion");
            return uExpression != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
        }
    }
}

