/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.JpsFileObject;

final class FileObjectKindFilter<T> {
    private final Iterators.Function<? super T, String> myToNameConverter;
    private final Map<JavaFileObject.Kind, Iterators.BooleanFunction<T>> myFilterMap;

    FileObjectKindFilter(Iterators.Function<? super T, String> toNameConverter) {
        this.myToNameConverter = toNameConverter;
        EnumMap filterMap = new EnumMap(JavaFileObject.Kind.class);
        for (final JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
            if (kind == JavaFileObject.Kind.OTHER) {
                filterMap.put(kind, new Iterators.BooleanFunction<T>(){

                    @Override
                    public boolean fun(T data) {
                        return JpsFileObject.findKind((String)FileObjectKindFilter.this.myToNameConverter.fun(data)) == JavaFileObject.Kind.OTHER;
                    }
                });
                continue;
            }
            filterMap.put(kind, new Iterators.BooleanFunction<T>(){

                @Override
                public boolean fun(T data) {
                    String name = (String)FileObjectKindFilter.this.myToNameConverter.fun(data);
                    return name.regionMatches(true, name.length() - kind.extension.length(), kind.extension, 0, kind.extension.length());
                }
            });
        }
        this.myFilterMap = Collections.unmodifiableMap(filterMap);
    }

    public Iterators.BooleanFunction<T> getFor(final Set<JavaFileObject.Kind> kinds) {
        Iterator<JavaFileObject.Kind> it = kinds.iterator();
        if (it.hasNext()) {
            JavaFileObject.Kind kind = it.next();
            if (!it.hasNext()) {
                return this.myFilterMap.get((Object)kind);
            }
        }
        return new Iterators.BooleanFunction<T>(){

            @Override
            public boolean fun(T data) {
                for (JavaFileObject.Kind kind : kinds) {
                    if (!((Iterators.BooleanFunction)FileObjectKindFilter.this.myFilterMap.get((Object)kind)).fun(data)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

