/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.stack.DataStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u0006\u0010\u0016\u001a\u00020\nJ\b\u0010\u0017\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0010J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u000fJ\u0010\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u001aJ\u0018\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100&0%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "", "owner", "Lorg/jetbrains/kotlin/ir/IrElement;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;)V", "getOwner", "()Lorg/jetbrains/kotlin/ir/IrElement;", "instructions", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "dataStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/DataStack;", "memory", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "isEmpty", "", "pushInstruction", "", "instruction", "popInstruction", "dropInstructions", "pushState", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "popState", "peekState", "storeState", "symbol", "variable", "containsStateInMemory", "loadState", "rewriteState", "newState", "getAll", "", "Lkotlin/Pair;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Frame.kt\norg/jetbrains/kotlin/ir/interpreter/stack/SubFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
final class SubFrame {
    @NotNull
    private final IrElement owner;
    @NotNull
    private final ArrayDeque<Instruction> instructions;
    @NotNull
    private final DataStack dataStack;
    @NotNull
    private final Map<IrSymbol, Variable> memory;

    public SubFrame(@NotNull IrElement owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        this.owner = owner;
        this.instructions = new ArrayDeque();
        this.dataStack = new DataStack();
        this.memory = new LinkedHashMap();
    }

    @NotNull
    public final IrElement getOwner() {
        return this.owner;
    }

    public final boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    public final void pushInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        this.instructions.addFirst(instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        return this.instructions.removeFirst();
    }

    @Nullable
    public final Instruction dropInstructions() {
        Instruction instruction;
        Instruction instruction2 = this.instructions.lastOrNull();
        if (instruction2 != null) {
            Instruction instruction3;
            Instruction $this$dropInstructions_u24lambda_u240 = instruction3 = instruction2;
            boolean bl = false;
            this.instructions.clear();
            instruction = instruction3;
        } else {
            instruction = null;
        }
        return instruction;
    }

    public final void pushState(@NotNull State state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.dataStack.push(state);
    }

    @NotNull
    public final State popState() {
        return this.dataStack.pop();
    }

    @Nullable
    public final State peekState() {
        return this.dataStack.peek();
    }

    public final void storeState(@NotNull IrSymbol symbol, @NotNull Variable variable) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(variable, "variable");
        this.memory.put(symbol, variable);
    }

    public final void storeState(@NotNull IrSymbol symbol, @Nullable State state) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        this.memory.put(symbol, new Variable(state));
    }

    public final boolean containsStateInMemory(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return this.memory.get(symbol) != null;
    }

    @Nullable
    public final State loadState(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Variable variable = this.memory.get(symbol);
        return variable != null ? variable.getState() : null;
    }

    public final void rewriteState(@NotNull IrSymbol symbol, @NotNull State newState) {
        block0: {
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter(newState, "newState");
            Variable variable = this.memory.get(symbol);
            if (variable == null) break block0;
            variable.setState(newState);
        }
    }

    @NotNull
    public final List<Pair<IrSymbol, Variable>> getAll() {
        return MapsKt.toList(this.memory);
    }
}

