/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "", "<init>", "()V", "allowExternalInlining", "", "getAllowExternalInlining", "()Z", "needsInlining", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getFunctionDeclaration", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "shouldExcludeFunctionFromInlining", "ir.inline"})
public abstract class InlineFunctionResolver {
    public boolean getAllowExternalInlining() {
        return false;
    }

    public boolean needsInlining(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return function2.isInline() && (this.getAllowExternalInlining() || !function2.isExternal());
    }

    @Nullable
    public IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        if (this.shouldExcludeFunctionFromInlining(symbol)) {
            return null;
        }
        IrFunction owner = symbol.getOwner();
        IrSimpleFunction irSimpleFunction = owner instanceof IrSimpleFunction ? (IrSimpleFunction)owner : null;
        return irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, null, 1, null)) != null ? (IrFunction)irSimpleFunction : owner;
    }

    protected boolean shouldExcludeFunctionFromInlining(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return !this.needsInlining(symbol.getOwner()) || Symbols.Companion.isLateinitIsInitializedPropertyGetter(symbol) || Symbols.Companion.isTypeOfIntrinsic(symbol);
    }
}

