/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputBlock;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewEditorScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "previewOutputBlocksManager", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;", "toolwindowHandler", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;Lcom/intellij/openapi/Disposable;)V", "onStart", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "handle", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "error", "message", "", "onFinish", "clear", "printToPreviewEditor", "clearOutputManager", "kotlin.jvm"})
public final class PreviewEditorScratchOutputHandler
implements ScratchOutputHandler {
    @NotNull
    private final PreviewOutputBlocksManager previewOutputBlocksManager;
    @NotNull
    private final ScratchOutputHandler toolwindowHandler;
    @NotNull
    private final Disposable parentDisposable;

    public PreviewEditorScratchOutputHandler(@NotNull PreviewOutputBlocksManager previewOutputBlocksManager, @NotNull ScratchOutputHandler toolwindowHandler, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)previewOutputBlocksManager, (String)"previewOutputBlocksManager");
        Intrinsics.checkNotNullParameter((Object)toolwindowHandler, (String)"toolwindowHandler");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.previewOutputBlocksManager = previewOutputBlocksManager;
        this.toolwindowHandler = toolwindowHandler;
        this.parentDisposable = parentDisposable;
    }

    @Override
    public void onStart(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolwindowHandler.onStart(file);
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.printToPreviewEditor(expression, output);
    }

    @Override
    public void error(@NotNull ScratchFile file, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.toolwindowHandler.error(file, message2);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolwindowHandler.onFinish(file);
    }

    @Override
    public void clear(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolwindowHandler.clear(file);
        this.clearOutputManager();
    }

    private final void printToPreviewEditor(ScratchExpression expression, ScratchOutput output) {
        TransactionGuard.submitTransaction((Disposable)this.parentDisposable, () -> PreviewEditorScratchOutputHandler.printToPreviewEditor$lambda$0(this, expression, output));
    }

    private final void clearOutputManager() {
        TransactionGuard.submitTransaction((Disposable)this.parentDisposable, () -> PreviewEditorScratchOutputHandler.clearOutputManager$lambda$1(this));
    }

    private static final void printToPreviewEditor$lambda$0(PreviewEditorScratchOutputHandler this$0, ScratchExpression $expression, ScratchOutput $output) {
        ScratchOutputBlock scratchOutputBlock = this$0.previewOutputBlocksManager.getBlock($expression);
        if (scratchOutputBlock == null) {
            scratchOutputBlock = this$0.previewOutputBlocksManager.addBlockToTheEnd($expression);
        }
        ScratchOutputBlock targetCell = scratchOutputBlock;
        targetCell.addOutput($output);
    }

    private static final void clearOutputManager$lambda$1(PreviewEditorScratchOutputHandler this$0) {
        this$0.previewOutputBlocksManager.clear();
    }
}

