/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.util.Query;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0006\u001a\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"canDeleteElement", "", "Lcom/intellij/psi/PsiElement;", "removeOverrideModifier", "", "cleanUpOverrides", "Lcom/intellij/psi/PsiMethod;", "checkParametersInMethodHierarchy", "", "parameter", "Lcom/intellij/psi/PsiParameter;", "collectParametersHierarchy", "", "method", "addParameter", "result", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/refactoring/safeDelete/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1310#2,2:114\n3829#2:119\n4344#2,2:120\n1228#3,2:116\n73#4:118\n1863#5,2:122\n774#5:124\n865#5,2:125\n1863#5,2:127\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/refactoring/safeDelete/UtilsKt\n*L\n47#1:114,2\n93#1:119\n93#1:120,2\n58#1:116,2\n71#1:118\n94#1:122,2\n96#1:124\n96#1:125,2\n97#1:127,2\n*E\n"})
public final class UtilsKt {
    public static final boolean canDeleteElement(@NotNull PsiElement $this$canDeleteElement) {
        Intrinsics.checkNotNullParameter((Object)$this$canDeleteElement, (String)"<this>");
        if ($this$canDeleteElement instanceof KtObjectDeclaration && ((KtObjectDeclaration)$this$canDeleteElement).isObjectLiteral()) {
            return false;
        }
        if ($this$canDeleteElement instanceof KtParameter) {
            PsiElement psiElement = ((KtParameter)$this$canDeleteElement).getParent();
            KtParameterList ktParameterList = psiElement instanceof KtParameterList ? (KtParameterList)psiElement : null;
            if (ktParameterList == null) {
                return false;
            }
            KtParameterList parameterList = ktParameterList;
            PsiElement psiElement2 = parameterList.getParent();
            KtDeclaration ktDeclaration = psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null;
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration declaration = ktDeclaration;
            return !(declaration instanceof KtPropertyAccessor);
        }
        return $this$canDeleteElement instanceof KtClassOrObject || $this$canDeleteElement instanceof KtSecondaryConstructor || $this$canDeleteElement instanceof KtNamedFunction || $this$canDeleteElement instanceof PsiMethod || $this$canDeleteElement instanceof PsiClass || $this$canDeleteElement instanceof KtProperty || $this$canDeleteElement instanceof KtTypeParameter || $this$canDeleteElement instanceof KtTypeAlias;
    }

    public static final void removeOverrideModifier(@NotNull PsiElement $this$removeOverrideModifier) {
        Intrinsics.checkNotNullParameter((Object)$this$removeOverrideModifier, (String)"<this>");
        PsiElement psiElement = $this$removeOverrideModifier;
        if (psiElement instanceof KtNamedFunction || psiElement instanceof KtProperty) {
            KtModifierList ktModifierList = ((KtModifierListOwner)$this$removeOverrideModifier).getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) != null) {
                ktModifierList.delete();
            }
        } else if (psiElement instanceof PsiMethod) {
            Object object;
            block6: {
                PsiAnnotation[] psiAnnotationArray = ((PsiMethod)$this$removeOverrideModifier).getModifierList().getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                Object[] $this$firstOrNull$iv = psiAnnotationArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiAnnotation annotation = (PsiAnnotation)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    object = element$iv;
                    break block6;
                }
                object = null;
            }
            PsiAnnotation psiAnnotation = (PsiAnnotation)object;
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }
    }

    public static final void cleanUpOverrides(@NotNull PsiMethod $this$cleanUpOverrides) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanUpOverrides, (String)"<this>");
        Object[] objectArray = $this$cleanUpOverrides.findSuperMethods(true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findSuperMethods(...)");
        Object[] superMethods = objectArray;
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)$this$cleanUpOverrides, (boolean)true).findAll()) {
            boolean bl;
            block2: {
                Sequence currentSuperMethods;
                PsiMethod[] psiMethodArray = overridingMethod.findSuperMethods(true);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
                Sequence $this$all$iv = currentSuperMethods = SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])psiMethodArray), (Sequence)ArraysKt.asSequence((Object[])superMethods));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    PsiMethod superMethod = (PsiMethod)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)superMethod);
                    if (Intrinsics.areEqual((Object)LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)superMethod)), (Object)LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$cleanUpOverrides)))) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            Intrinsics.checkNotNull((Object)overridingMethod);
            PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)overridingMethod));
            if (psiElement == null) continue;
            UtilsKt.removeOverrideModifier(psiElement);
        }
    }

    @Nullable
    public static final Collection<PsiElement> checkParametersInMethodHierarchy(@NotNull PsiParameter parameter) {
        Collection parametersToDelete;
        PsiMethod method;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                PsiElement psiElement = parameter.getDeclarationScope();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                method = (PsiMethod)psiElement;
                Object[] objectArray = new Object[]{parameter.getName()};
                parametersToDelete = (Collection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> UtilsKt.checkParametersInMethodHierarchy$lambda$3(method, parameter), KotlinBundle.message((String)"progress.title.collect.hierarchy", (Object[])objectArray), true, parameter.getProject());
                if (parametersToDelete == null || parametersToDelete.size() <= 1) break block2;
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block3;
            }
            return parametersToDelete;
        }
        Object[] objectArray = new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)method), (ElementDescriptionLocation)((ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT))};
        String message2 = KotlinBundle.message((String)"override.declaration.delete.multiple.parameters", (Object[])objectArray);
        int exitCode = Messages.showOkCancelDialog((Project)parameter.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? parametersToDelete : null;
    }

    private static final Set<PsiElement> collectParametersHierarchy(PsiMethod method, PsiParameter parameter) {
        ArrayDeque<PsiMethod> queue = new ArrayDeque<PsiMethod>();
        HashSet visited = new HashSet();
        HashSet parametersToDelete = new HashSet();
        queue.add(method);
        while (!queue.isEmpty()) {
            Iterable $this$forEach$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            PsiMethod currentMethod = (PsiMethod)queue.poll();
            ((Collection)visited).add(currentMethod);
            Intrinsics.checkNotNull((Object)currentMethod);
            UtilsKt.addParameter(currentMethod, parametersToDelete, parameter);
            PsiMethod[] psiMethodArray = currentMethod.findSuperMethods(true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            Object[] objectArray = psiMethodArray;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                queue.offer(it);
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)currentMethod);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
            $this$forEach$iv = (Iterable)query;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object element$iv$iv = bl.next();
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl2 = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl3 = false;
                queue.offer(it);
            }
        }
        return parametersToDelete;
    }

    private static final void addParameter(PsiMethod method, Set<PsiElement> result2, PsiParameter parameter) {
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)parameter));
        Intrinsics.checkNotNull((Object)psiElement);
        int parameterIndex = KtPsiUtilKt.parameterIndex((PsiElement)psiElement);
        if (method instanceof KtLightMethod) {
            KtDeclaration declaration = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
            if (declaration instanceof KtFunction) {
                result2.add((PsiElement)((KtFunction)declaration).getValueParameters().get(parameterIndex));
            }
        } else {
            result2.add((PsiElement)method.getParameterList().getParameters()[parameterIndex]);
        }
    }

    private static final Set checkParametersInMethodHierarchy$lambda$3$lambda$2(PsiMethod $method, PsiParameter $parameter) {
        return UtilsKt.collectParametersHierarchy($method, $parameter);
    }

    private static final Collection checkParametersInMethodHierarchy$lambda$3(PsiMethod $method, PsiParameter $parameter) {
        return (Collection)ActionsKt.runReadAction(() -> UtilsKt.checkParametersInMethodHierarchy$lambda$3$lambda$2($method, $parameter));
    }
}

