/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.usageView.UsageViewTypeLocation;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020#H&J\b\u00102\u001a\u00020\u0017H\u0014J\b\u00103\u001a\u00020\u0017H\u0014J\b\u00104\u001a\u00020+H\u0014J\b\u00105\u001a\u00020+H\u0014J\u0010\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020+H\u0003J\b\u00108\u001a\u00020+H\u0014J\n\u00109\u001a\u0004\u0018\u00010+H\u0014J\b\u0010:\u001a\u00020+H\u0014R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u001e\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010)\u001a\u0004\b'\u0010(R\u0016\u0010*\u001a\u0004\u0018\u00010+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0014\u00100\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010-\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "declaration", "reference", "Lcom/intellij/psi/PsiReference;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiReference;Lcom/intellij/openapi/editor/Editor;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getReference", "()Lcom/intellij/psi/PsiReference;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "kotlinRefactoringSettings", "Lorg/jetbrains/kotlin/idea/refactoring/KotlinCommonRefactoringSettings;", "getKotlinRefactoringSettings", "()Lorg/jetbrains/kotlin/idea/refactoring/KotlinCommonRefactoringSettings;", "isKeepTheDeclarationByDefault", "", "isInlineThis", "doAction", "", "saveSettings", "inlineThisOption", "Lkotlin/reflect/KMutableProperty1;", "getInlineThisOption", "()Lkotlin/reflect/KMutableProperty1;", "inlineKeepOption", "getInlineKeepOption", "createProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "occurrencesNumber", "", "kotlin.jvm.PlatformType", "getOccurrencesNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "occurrencesString", "", "getOccurrencesString", "()Ljava/lang/String;", "kind", "getKind", "refactoringName", "getRefactoringName", "canInlineThisOnly", "allowInlineAll", "getBorderTitle", "getNameLabelText", "getInlineText", "verb", "getInlineAllText", "getKeepTheDeclarationText", "getInlineThisText", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinInlineDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinInlineDialog.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public abstract class AbstractKotlinInlineDialog<TDeclaration extends KtNamedDeclaration>
extends InlineOptionsDialog {
    @NotNull
    private final TDeclaration declaration;
    @Nullable
    private final PsiReference reference;
    @Nullable
    private final Editor editor;
    @NotNull
    private final KotlinCommonRefactoringSettings kotlinRefactoringSettings;
    private final Integer occurrencesNumber;

    public AbstractKotlinInlineDialog(@NotNull TDeclaration declaration, @Nullable PsiReference reference2, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter(declaration, (String)"declaration");
        super(((PsiElement)declaration).getProject(), true, (PsiElement)declaration);
        this.declaration = declaration;
        this.reference = reference2;
        this.editor = editor;
        this.kotlinRefactoringSettings = KotlinCommonRefactoringSettings.Companion.getInstance();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.occurrencesNumber = (Integer)ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"progress.title.calculate.occurrences", (Object[])new Object[0]), () -> AbstractKotlinInlineDialog.occurrencesNumber$lambda$0(this));
        this.myInvokedOnReference = this.reference != null;
        this.setTitle(this.getRefactoringName());
    }

    @NotNull
    protected final TDeclaration getDeclaration() {
        return this.declaration;
    }

    @Nullable
    protected final PsiReference getReference() {
        return this.reference;
    }

    @Nullable
    protected final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    protected final KotlinCommonRefactoringSettings getKotlinRefactoringSettings() {
        return this.kotlinRefactoringSettings;
    }

    protected boolean isKeepTheDeclarationByDefault() {
        return (Boolean)this.getInlineKeepOption().get((Object)this.kotlinRefactoringSettings);
    }

    protected final boolean isInlineThis() {
        return (Boolean)this.getInlineThisOption().get((Object)this.kotlinRefactoringSettings);
    }

    public final void doAction() {
        this.invokeRefactoring(this.createProcessor());
        this.saveSettings();
    }

    private final void saveSettings() {
        KotlinCommonRefactoringSettings settings2 = this.kotlinRefactoringSettings;
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            this.getInlineThisOption().set((Object)settings2, (Object)this.isInlineThisOnly());
        }
        JRadioButton jRadioButton = this.myKeepTheDeclaration;
        boolean bl = jRadioButton != null ? jRadioButton.isEnabled() : false;
        if (bl) {
            this.getInlineKeepOption().set((Object)settings2, (Object)this.isKeepTheDeclaration());
        }
    }

    @NotNull
    public abstract KMutableProperty1<KotlinCommonRefactoringSettings, Boolean> getInlineThisOption();

    @NotNull
    public abstract KMutableProperty1<KotlinCommonRefactoringSettings, Boolean> getInlineKeepOption();

    @NotNull
    public abstract BaseRefactoringProcessor createProcessor();

    protected final Integer getOccurrencesNumber() {
        return this.occurrencesNumber;
    }

    private final String getOccurrencesString() {
        String string;
        if (this.occurrencesNumber >= 0) {
            Integer n = this.occurrencesNumber;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"occurrencesNumber");
            string = this.occurrencesNumber + " " + StringUtil.pluralize((String)"occurrence", (int)((Number)n).intValue());
        } else {
            string = null;
        }
        return string;
    }

    private final String getKind() {
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)this.declaration), (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
        return string;
    }

    private final String getRefactoringName() {
        Object[] objectArray = new Object[]{StringUtil.capitalizeWords((String)this.getKind(), (boolean)true)};
        return KotlinBundle.message((String)"text.inline.0", (Object[])objectArray);
    }

    protected boolean canInlineThisOnly() {
        return false;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    @NotNull
    protected String getBorderTitle() {
        return this.getRefactoringName();
    }

    @NotNull
    protected String getNameLabelText() {
        Object object;
        block3: {
            block2: {
                object = this.getOccurrencesString();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = " - " + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String occurrencesString = object;
        return StringsKt.capitalize((String)this.getKind()) + " " + this.declaration.getNameAsSafeName() + " " + occurrencesString;
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String getInlineText(String verb) {
        Object object;
        Object[] objectArray;
        String string;
        block3: {
            block2: {
                void it;
                string = "text.inline.all.references.and.verb.0.the.kind.1.occurrences.2";
                objectArray = new Object[3];
                objectArray[0] = verb;
                objectArray[1] = this.getKind();
                Object[] objectArray2 = objectArray;
                int n = 2;
                object = this.getOccurrencesString();
                if (object == null) break block2;
                String string2 = object;
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                String string3 = string;
                boolean bl = false;
                String string4 = "(" + (String)it + ")";
                string = string3;
                objectArray2 = objectArray3;
                n = n2;
                String string5 = string4;
                object = string5;
                if (string5 != null) break block3;
            }
            object = "";
        }
        objectArray2[n] = object;
        return KotlinBundle.message((String)string, (Object[])objectArray);
    }

    @NotNull
    protected String getInlineAllText() {
        String string;
        if (((PsiElement)this.declaration).isWritable()) {
            string = this.getInlineText(KotlinBundle.message((String)"text.remove", (Object[])new Object[0]));
        } else {
            String string2 = RefactoringBundle.message((String)"all.invocations.in.project");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return string;
    }

    @Nullable
    protected String getKeepTheDeclarationText() {
        return ((PsiElement)this.declaration).isWritable() && (this.occurrencesNumber > 1 || !this.myInvokedOnReference) ? this.getInlineText(KotlinBundle.message((String)"text.keep", (Object[])new Object[0])) : null;
    }

    @NotNull
    protected String getInlineThisText() {
        Object[] objectArray = new Object[]{this.getKind()};
        return KotlinBundle.message((String)"text.inline.this.reference.and.keep.the.0", (Object[])objectArray);
    }

    private static final Integer occurrencesNumber$lambda$0(AbstractKotlinInlineDialog this$0) {
        return InlineOptionsDialog.initOccurrencesNumber((PsiNameIdentifierOwner)((PsiNameIdentifierOwner)this$0.declaration));
    }
}

