/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.copy.AbstractCopyKotlinDeclarationsHandlerKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u000bH\u0004\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0010\u001a\u00020\u00112\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u000b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00112\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u000bH\u0004\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0016\u001a\u00020\u00112\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u000b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH&J\"\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler;", "Lcom/intellij/refactoring/copy/CopyHandlerDelegateBase;", "<init>", "()V", "copyFilesHandler", "Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "getCopyFilesHandler", "()Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "copyFilesHandler$delegate", "Lkotlin/Lazy;", "getSourceFiles", "", "Lcom/intellij/psi/PsiFileSystemItem;", "elements", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiFileSystemItem;", "canCopyFiles", "", "fromUpdate", "([Lcom/intellij/psi/PsiElement;Z)Z", "canCopyDeclarations", "([Lcom/intellij/psi/PsiElement;)Z", "canCopy", "getOrCreateTargetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "originalFile", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "targetFileName", "", "createFile", "getFilePolicy", "Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler$ExistingFilePolicy;", "existingFile", "Lcom/intellij/psi/PsiFile;", "ExistingFilePolicy", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAbstractCopyKotlinDeclarationsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,140:1\n11165#2:141\n11500#2,3:142\n12574#2,2:147\n10072#2:149\n10494#2,2:150\n10496#2,3:153\n37#3,2:145\n1#4:152\n1663#5,8:156\n73#6:164\n73#6:165\n*S KotlinDebug\n*F\n+ 1 AbstractCopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler\n*L\n44#1:141\n44#1:142,3\n50#1:147,2\n57#1:149\n57#1:150,2\n57#1:153,3\n45#1:145,2\n58#1:156,8\n112#1:164\n123#1:165\n*E\n"})
public abstract class AbstractCopyKotlinDeclarationsHandler
extends CopyHandlerDelegateBase {
    @NotNull
    private final Lazy copyFilesHandler$delegate = LazyKt.lazy(AbstractCopyKotlinDeclarationsHandler::copyFilesHandler_delegate$lambda$0);

    @NotNull
    protected final CopyFilesOrDirectoriesHandler getCopyFilesHandler() {
        Lazy lazy = this.copyFilesHandler$delegate;
        return (CopyFilesOrDirectoriesHandler)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiFileSystemItem[] getSourceFiles(@NotNull PsiElement[] elements) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        PsiElement[] $this$map$iv = elements;
        boolean $i$f$map = false;
        PsiElement[] psiElementArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            PsiFileSystemItem psiFileSystemItem;
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiFile psiFile = it.getContainingFile();
            if (psiFile != null) {
                psiFileSystemItem = (PsiFileSystemItem)psiFile;
            } else {
                psiFileSystemItem = it instanceof PsiFileSystemItem ? (PsiFileSystemItem)it : null;
                if (psiFileSystemItem == null) {
                    return null;
                }
            }
            collection.add(psiFileSystemItem);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFileSystemItem[0]);
    }

    private final boolean canCopyFiles(PsiElement[] elements, boolean fromUpdate) {
        boolean bl;
        PsiFileSystemItem[] sourceFiles;
        block3: {
            PsiFileSystemItem[] psiFileSystemItemArray = this.getSourceFiles(elements);
            if (psiFileSystemItemArray == null) {
                return false;
            }
            PsiFileSystemItem[] $this$any$iv = sourceFiles = psiFileSystemItemArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                PsiFileSystemItem element$iv;
                PsiFileSystemItem it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!(it instanceof KtFile)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (!bl) {
            return false;
        }
        return this.getCopyFilesHandler().canCopy((PsiElement[])sourceFiles, fromUpdate);
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean canCopyDeclarations(@NotNull PsiElement[] elements) {
        void $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        PsiFile psiFile = elements;
        boolean $i$f$flatMap = false;
        void var6_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[j];
            boolean bl = false;
            Collection collection = AbstractCopyKotlinDeclarationsHandlerKt.getDeclarationsToCopy((PsiElement)it);
            if (collection.isEmpty()) {
                boolean bl2 = false;
                return false;
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<PsiFile> set$iv = new HashSet<PsiFile>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtElement it = (KtElement)e$iv;
            boolean bl = false;
            PsiFile key$iv = it.getContainingFile();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        KtElement ktElement = (KtElement)CollectionsKt.singleOrNull((List)list$iv);
        if (ktElement == null || (psiFile = ktElement.getContainingFile()) == null) {
            return false;
        }
        PsiFile containingFile = psiFile;
        return ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)containingFile) != null;
    }

    public boolean canCopy(@NotNull PsiElement[] elements, boolean fromUpdate) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return this.canCopyDeclarations(elements) || this.canCopyFiles(elements, fromUpdate);
    }

    @Nullable
    protected final KtFile getOrCreateTargetFile(@NotNull KtFile originalFile, @NotNull PsiDirectory targetDirectory, @NotNull String targetFileName) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        PsiFile existingFile = targetDirectory.findFile(targetFileName);
        if (Intrinsics.areEqual((Object)existingFile, (Object)originalFile)) {
            return null;
        }
        if (existingFile != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getFilePolicy(existingFile, targetFileName, targetDirectory).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    ActionsKt.runWriteAction(() -> AbstractCopyKotlinDeclarationsHandler.getOrCreateTargetFile$lambda$6(existingFile));
                    break;
                }
                case 3: {
                    return null;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return (KtFile)ActionsKt.runWriteAction(() -> AbstractCopyKotlinDeclarationsHandler.getOrCreateTargetFile$lambda$7(existingFile, this, targetFileName, targetDirectory));
    }

    @NotNull
    public abstract KtFile createFile(@NotNull String var1, @NotNull PsiDirectory var2);

    private final ExistingFilePolicy getFilePolicy(PsiFile existingFile, String targetFileName, PsiDirectory targetDirectory) {
        ExistingFilePolicy existingFilePolicy;
        Object[] objectArray = new Object[]{targetFileName, targetDirectory.getVirtualFile().getPath()};
        String message2 = KotlinBundle.message((String)"text.file.0.already.exists.in.1", (Object[])objectArray);
        if (!(existingFile instanceof KtFile)) {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return ExistingFilePolicy.OVERWRITE;
            }
            int answer = Messages.showOkCancelDialog((String)message2, (String)AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), (String)KotlinBundle.message((String)"action.text.overwrite", (Object[])new Object[0]), (String)KotlinBundle.message((String)"action.text.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            existingFilePolicy = answer == 0 ? ExistingFilePolicy.OVERWRITE : ExistingFilePolicy.SKIP;
        } else {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return ExistingFilePolicy.APPEND;
            }
            int answer = Messages.showYesNoCancelDialog((String)message2, (String)AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), (String)KotlinBundle.message((String)"action.text.append", (Object[])new Object[0]), (String)KotlinBundle.message((String)"action.text.overwrite", (Object[])new Object[0]), (String)KotlinBundle.message((String)"action.text.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            switch (answer) {
                case 0: {
                    existingFilePolicy = ExistingFilePolicy.APPEND;
                    break;
                }
                case 1: {
                    existingFilePolicy = ExistingFilePolicy.OVERWRITE;
                    break;
                }
                default: {
                    existingFilePolicy = ExistingFilePolicy.SKIP;
                }
            }
        }
        return existingFilePolicy;
    }

    private static final CopyFilesOrDirectoriesHandler copyFilesHandler_delegate$lambda$0() {
        return new CopyFilesOrDirectoriesHandler();
    }

    private static final Unit getOrCreateTargetFile$lambda$6(PsiFile $existingFile) {
        $existingFile.delete();
        return Unit.INSTANCE;
    }

    private static final KtFile getOrCreateTargetFile$lambda$7(PsiFile $existingFile, AbstractCopyKotlinDeclarationsHandler this$0, String $targetFileName, PsiDirectory $targetDirectory) {
        return $existingFile != null && $existingFile.isValid() ? (KtFile)$existingFile : this$0.createFile($targetFileName, $targetDirectory);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler$ExistingFilePolicy;", "", "<init>", "(Ljava/lang/String;I)V", "APPEND", "OVERWRITE", "SKIP", "kotlin.refactorings.common"})
    public static final class ExistingFilePolicy
    extends Enum<ExistingFilePolicy> {
        public static final /* enum */ ExistingFilePolicy APPEND = new ExistingFilePolicy();
        public static final /* enum */ ExistingFilePolicy OVERWRITE = new ExistingFilePolicy();
        public static final /* enum */ ExistingFilePolicy SKIP = new ExistingFilePolicy();
        private static final /* synthetic */ ExistingFilePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ExistingFilePolicy[] values() {
            return (ExistingFilePolicy[])$VALUES.clone();
        }

        public static ExistingFilePolicy valueOf(String value) {
            return Enum.valueOf(ExistingFilePolicy.class, value);
        }

        @NotNull
        public static EnumEntries<ExistingFilePolicy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = existingFilePolicyArray = new ExistingFilePolicy[]{ExistingFilePolicy.APPEND, ExistingFilePolicy.OVERWRITE, ExistingFilePolicy.SKIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExistingFilePolicy.values().length];
            try {
                nArray[ExistingFilePolicy.APPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExistingFilePolicy.OVERWRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExistingFilePolicy.SKIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

