/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.RemoveReturnLabelFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveReturnLabelFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class RemoveReturnLabelFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final RemoveReturnLabelFixFactory INSTANCE = new RemoveReturnLabelFixFactory();

    private RemoveReturnLabelFixFactory() {
    }

    @Override
    @Nullable
    protected KotlinQuickFixAction<KtReturnExpression> createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement();
        KtReturnExpression ktReturnExpression = psiElement instanceof KtReturnExpression ? (KtReturnExpression)psiElement : null;
        if (ktReturnExpression == null) {
            return null;
        }
        KtReturnExpression returnExpression = ktReturnExpression;
        String string = returnExpression.getLabelName();
        if (string == null) {
            return null;
        }
        String labelName = string;
        return new RemoveReturnLabelFix(returnExpression, labelName);
    }
}

