/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001&B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J#\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0094\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010 \u001a\u00020\u0017*\u00020\u0002H\u0002J\u0016\u0010!\u001a\u00020\u0017*\u00020\u00022\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0002J\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0007H\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "candidateMembers", "", "Lorg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix$MemberData;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Ljava/util/List;)V", "kind", "", "getKind", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getText", "getFamilyName", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "addMember", "memberData", "removeDefaultParameterValues", "copyAnnotationEntriesFrom", "member", "createMemberPopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "actionName", "MemberData", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddMemberToSupertypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddMemberToSupertypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1#2:269\n1863#3,2:270\n1863#3,2:272\n*S KotlinDebug\n*F\n+ 1 AddMemberToSupertypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix\n*L\n89#1:270,2\n96#1:272,2\n*E\n"})
public abstract class AddMemberToSupertypeFix
extends KotlinQuickFixAction<KtCallableDeclaration>
implements LowPriorityAction {
    @NotNull
    private final List<MemberData> candidateMembers;

    public AddMemberToSupertypeFix(@NotNull KtCallableDeclaration element, @NotNull List<MemberData> candidateMembers) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(candidateMembers, (String)"candidateMembers");
        super((PsiElement)element);
        this.candidateMembers = candidateMembers;
        boolean bl2 = bl = !((Collection)this.candidateMembers).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public abstract String getKind();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                object = (MemberData)CollectionsKt.singleOrNull(this.candidateMembers);
                if (object == null) break block2;
                MemberData it = object;
                boolean bl = false;
                String string = this.actionName(it);
                object = string;
                if (string != null) break block3;
            }
            Object[] objectArray = new Object[]{this.getKind()};
            object = KotlinBundle.message((String)"fix.add.member.supertype.text", (Object[])objectArray);
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.getKind()};
        return KotlinBundle.message((String)"fix.add.member.supertype.family", (Object[])objectArray);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CommandProcessor.getInstance().runUndoTransparentAction(() -> AddMemberToSupertypeFix.invoke$lambda$1(this, editor, project));
    }

    private final void addMember(MemberData memberData, Project project) {
        Object[] objectArray = new Object[]{this.getKind()};
        ApplicationUtilsKt.executeWriteCommand(project, KotlinBundle.message((String)"fix.add.member.supertype.progress", (Object[])objectArray), (Function0<Unit>)((Function0)() -> AddMemberToSupertypeFix.addMember$lambda$2(this, memberData, project)));
    }

    private final void removeDefaultParameterValues(KtCallableDeclaration $this$removeDefaultParameterValues) {
        List list2 = $this$removeDefaultParameterValues.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            KtExpression ktExpression = it.getDefaultValue();
            if (ktExpression != null) {
                ktExpression.delete();
            }
            PsiElement psiElement = it.getEqualsToken();
            if (psiElement == null) continue;
            psiElement.delete();
        }
    }

    private final void copyAnnotationEntriesFrom(KtCallableDeclaration $this$copyAnnotationEntriesFrom, KtCallableDeclaration member) {
        block1: {
            Object object = member;
            if (object == null || (object = object.getAnnotationEntries()) == null || (object = CollectionsKt.reversed((Iterable)((Iterable)object))) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                $this$copyAnnotationEntriesFrom.addAnnotationEntry(it);
            }
        }
    }

    private final ListPopupStep<?> createMemberPopup(Project project) {
        String string = KotlinBundle.message((String)"fix.add.member.supertype.choose.type", (Object[])new Object[0]);
        List<MemberData> list2 = this.candidateMembers;
        return (ListPopupStep)new BaseListPopupStep<MemberData>(this, project, string, list2){
            final /* synthetic */ AddMemberToSupertypeFix this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super($super_call_param$1, $super_call_param$2);
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public PopupStep<?> onChosen(MemberData selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                if (finalChoice) {
                    AddMemberToSupertypeFix.access$addMember(this.this$0, selectedValue, this.$project);
                }
                return PopupStep.FINAL_CHOICE;
            }

            public Icon getIconFor(MemberData value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.this$0.getIcon();
            }

            public String getTextFor(MemberData value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return AddMemberToSupertypeFix.access$actionName(this.this$0, value);
            }
        };
    }

    @Nls
    private final String actionName(MemberData memberData) {
        Object[] objectArray = new Object[]{memberData.getSignaturePreview(), String.valueOf(memberData.getTargetClass().getName())};
        return KotlinBundle.message((String)"fix.add.member.supertype.add.to", (Object[])objectArray);
    }

    private static final void invoke$lambda$1(AddMemberToSupertypeFix this$0, Editor $editor, Project $project) {
        if (this$0.candidateMembers.size() == 1 || $editor == null || !$editor.getComponent().isShowing()) {
            this$0.addMember((MemberData)CollectionsKt.first(this$0.candidateMembers), $project);
        } else {
            JBPopupFactory.getInstance().createListPopup(this$0.createMemberPopup($project)).showInBestPositionFor($editor);
        }
    }

    private static final Unit addMember$lambda$2(AddMemberToSupertypeFix this$0, MemberData $memberData, Project $project) {
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)this$0.getElement();
        if (ktCallableDeclaration != null) {
            this$0.removeDefaultParameterValues(ktCallableDeclaration);
        }
        KtClassBody classBody = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)((KtClassOrObject)$memberData.getTargetClass()));
        KtCallableDeclaration memberElement = (KtCallableDeclaration)new KtPsiFactory($project, false, 2, null).createDeclaration($memberData.getSourceCode());
        this$0.copyAnnotationEntriesFrom(memberElement, (KtCallableDeclaration)this$0.getElement());
        PsiElement psiElement = classBody.addBefore((PsiElement)memberElement, classBody.getRBrace());
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
        KtCallableDeclaration insertedMemberElement = (KtCallableDeclaration)psiElement;
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)insertedMemberElement, null, 2, null);
        PsiElement psiElement2 = KtPsiUtilKt.modalityModifier((KtDeclaration)((KtDeclaration)insertedMemberElement));
        IElementType iElementType = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null;
        KtModifierKeywordToken ktModifierKeywordToken = iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
        if (ktModifierKeywordToken == null) {
            return Unit.INSTANCE;
        }
        KtModifierKeywordToken modifierToken = ktModifierKeywordToken;
        if (Intrinsics.areEqual((Object)PsiModificationUtilsKt.implicitModality((KtDeclaration)insertedMemberElement), (Object)modifierToken)) {
            new RemoveModifierFixBase((KtModifierListOwner)insertedMemberElement, modifierToken, true).invoke();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$addMember(AddMemberToSupertypeFix $this, MemberData memberData, Project project) {
        $this.addMember(memberData, project);
    }

    public static final /* synthetic */ String access$actionName(AddMemberToSupertypeFix $this, MemberData memberData) {
        return $this.actionName(memberData);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix$MemberData;", "", "signaturePreview", "", "sourceCode", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtClass;)V", "getSignaturePreview", "()Ljava/lang/String;", "getSourceCode", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "kotlin.idea"})
    public static final class MemberData {
        @NotNull
        private final String signaturePreview;
        @NotNull
        private final String sourceCode;
        @NotNull
        private final KtClass targetClass;

        public MemberData(@NotNull String signaturePreview, @NotNull String sourceCode, @NotNull KtClass targetClass) {
            Intrinsics.checkNotNullParameter((Object)signaturePreview, (String)"signaturePreview");
            Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
            Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
            this.signaturePreview = signaturePreview;
            this.sourceCode = sourceCode;
            this.targetClass = targetClass;
        }

        @NotNull
        public final String getSignaturePreview() {
            return this.signaturePreview;
        }

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final KtClass getTargetClass() {
            return this.targetClass;
        }
    }
}

