/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCodeProblemReporter;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCoroutinesDelegateQuickFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCoroutinesUsageInWholeProjectFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspectionKt;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteTopLevelFunctionUsageReporter;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeProblemReporter;", "textMarker", "", "oldFqName", "newFqName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTextMarker", "()Ljava/lang/String;", "getOldFqName", "getNewFqName", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "fix", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteTopLevelFunctionUsageReporter$Companion$RebindReferenceFix;", "Companion", "kotlin.idea"})
final class ObsoleteTopLevelFunctionUsageReporter
implements ObsoleteCodeProblemReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String textMarker;
    @NotNull
    private final String oldFqName;
    @NotNull
    private final String newFqName;
    @NotNull
    private final Companion.RebindReferenceFix fix;

    public ObsoleteTopLevelFunctionUsageReporter(@NotNull String textMarker, @NotNull String oldFqName, @NotNull String newFqName) {
        Intrinsics.checkNotNullParameter((Object)textMarker, (String)"textMarker");
        Intrinsics.checkNotNullParameter((Object)oldFqName, (String)"oldFqName");
        Intrinsics.checkNotNullParameter((Object)newFqName, (String)"newFqName");
        this.textMarker = textMarker;
        this.oldFqName = oldFqName;
        this.newFqName = newFqName;
        this.fix = new Companion.RebindReferenceFix(this.newFqName);
    }

    @NotNull
    public final String getTextMarker() {
        return this.textMarker;
    }

    @NotNull
    public final String getOldFqName() {
        return this.oldFqName;
    }

    @NotNull
    public final String getNewFqName() {
        return this.newFqName;
    }

    @Override
    public boolean report(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull KtSimpleNameExpression simpleNameExpression) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)simpleNameExpression, (String)"simpleNameExpression");
        if (!Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)this.textMarker)) {
            return false;
        }
        if (!ObsoleteExperimentalCoroutinesInspectionKt.access$isTopLevelCallForReplace(simpleNameExpression, this.oldFqName, this.newFqName)) {
            return false;
        }
        Object[] objectArray = new Object[]{this.newFqName};
        String string = KotlinBundle.message((String)"0.is.expected.to.be.used.since.kotlin.1.3", (Object[])objectArray);
        objectArray = ObsoleteExperimentalCoroutinesInspectionKt.fixesWithWholeProject(isOnTheFly, new ObsoleteCoroutinesDelegateQuickFix(this.fix), ObsoleteCoroutinesUsageInWholeProjectFix.INSTANCE);
        holder.registerProblem((PsiElement)simpleNameExpression, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteTopLevelFunctionUsageReporter$Companion;", "", "<init>", "()V", "RebindReferenceFix", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteTopLevelFunctionUsageReporter$Companion$RebindReferenceFix;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCodeFix;", "fqName", "", "<init>", "(Ljava/lang/String;)V", "getFqName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
        private static final class RebindReferenceFix
        implements ObsoleteCodeFix {
            @NotNull
            private final String fqName;

            public RebindReferenceFix(@NotNull String fqName2) {
                Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                this.fqName = fqName2;
            }

            @NotNull
            public final String getFqName() {
                return this.fqName;
            }

            @Override
            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement element = descriptor2.getPsiElement();
                if (!(element instanceof KtSimpleNameExpression)) {
                    return;
                }
                KtSimpleNameReference.bindToFqName$default((KtSimpleNameReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)element)), (FqName)new FqName(this.fqName), (KtSimpleNameReference.ShorteningMode)KtSimpleNameReference.ShorteningMode.FORCED_SHORTENING, null, (int)4, null);
            }
        }
    }
}

