/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.TestUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\t*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinThrowableNotThrownInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isUsed", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinThrowableNotThrownInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinThrowableNotThrownInspection.kt\norg/jetbrains/kotlin/idea/inspections/KotlinThrowableNotThrownInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class KotlinThrowableNotThrownInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor(arg_0 -> KotlinThrowableNotThrownInspection.buildVisitor$lambda$1(this, holder, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUsed(KtExpression $this$isUsed) {
        BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$isUsed, BodyResolveMode.PARTIAL_WITH_CFA);
        if (!BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)$this$isUsed), (BindingContext)context2)) {
            return false;
        }
        Boolean isUsedAsResultOfLambda = (Boolean)context2.get((ReadOnlySlice)BindingContext.USED_AS_RESULT_OF_LAMBDA, (Object)$this$isUsed);
        if (Intrinsics.areEqual((Object)isUsedAsResultOfLambda, (Object)true)) {
            return true;
        }
        Class[] classArray = new Class[]{KtThrowExpression.class, KtReturnExpression.class, KtProperty.class};
        PsiElement psiElement = PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)$this$isUsed), (boolean)true, (Class[])classArray);
        if (!(psiElement instanceof KtProperty)) return true;
        KtProperty ktProperty = (KtProperty)psiElement;
        if (ktProperty == null) {
            return true;
        }
        KtProperty property = ktProperty;
        if (!property.isLocal()) return true;
        Query query = ReferencesSearch.search((PsiElement)((PsiElement)property));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        if (!CollectionsKt.any((Iterable)((Iterable)query))) return false;
        return true;
    }

    private static final Unit buildVisitor$lambda$1(KotlinThrowableNotThrownInspection this$0, ProblemsHolder $holder, KtCallExpression callExpression) {
        String string;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression calleeExpression = ktExpression;
        String it = calleeExpression.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        if (!(StringsKt.contains$default((CharSequence)it, (CharSequence)"Exception", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"Error", (boolean)false, (int)2, null))) {
            return Unit.INSTANCE;
        }
        if (TestUtils.isInTestSourceContent((PsiElement)((PsiElement)callExpression))) {
            return Unit.INSTANCE;
        }
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)callExpression, null, 1, null);
        if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
            return Unit.INSTANCE;
        }
        ResolvedCall resultingDescriptor = resolvedCall;
        KotlinType kotlinType = resultingDescriptor.getReturnType();
        if (kotlinType == null) {
            return Unit.INSTANCE;
        }
        KotlinType type2 = kotlinType;
        if (TypeUtilsKt.isNothing((KotlinType)type2) || KotlinTypeKt.isNullable((KotlinType)type2)) {
            return Unit.INSTANCE;
        }
        Object[] objectArray = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = objectArray instanceof ClassDescriptor ? (ClassDescriptor)objectArray : null;
        if (classDescriptor == null) {
            return Unit.INSTANCE;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        ClassDescriptor classDescriptor3 = DefaultBuiltIns.Companion.getInstance().getThrowable();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor3, (String)"getThrowable(...)");
        if (!DescriptorUtilsKt.isSubclassOf((ClassDescriptor)classDescriptor2, (ClassDescriptor)classDescriptor3)) {
            return Unit.INSTANCE;
        }
        if (this$0.isUsed((KtExpression)callExpression)) {
            return Unit.INSTANCE;
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            objectArray = new Object[]{calleeExpression.getText()};
            string = KotlinBundle.message((String)"throwable.instance.0.is.not.thrown", (Object[])objectArray);
        } else {
            objectArray = new Object[]{calleeExpression.getText()};
            string = KotlinBundle.message((String)"result.of.0.call.is.not.thrown", (Object[])objectArray);
        }
        String description = string;
        $holder.registerProblem((PsiElement)calleeExpression, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        return Unit.INSTANCE;
    }
}

