/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a7\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0002\u001a&\u0010\f\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\n*\u00020\tH\u0002\u001a\f\u0010\u0014\u001a\u00020\n*\u00020\tH\u0002\u001a\f\u0010\u0015\u001a\u00020\n*\u00020\tH\u0002\u001a\f\u0010\u0016\u001a\u00020\n*\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"getTargetMethodOnMutableList", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "getTargetMethod", "isValidFirstArgument", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "", "Lkotlin/ExtensionFunctionType;", "canReplaceWithStdLib", "fqName", "args", "", "checkApiVersion", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "isMutableList", "isMutableListOrSubtype", "isList", "isListOrSubtype", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJavaCollectionsStaticMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCollectionsStaticMethodInspection.kt\norg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspectionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1755#2,3:128\n1755#2,3:131\n*S KotlinDebug\n*F\n+ 1 JavaCollectionsStaticMethodInspection.kt\norg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspectionKt\n*L\n93#1:128,3\n100#1:131,3\n*E\n"})
public final class JavaCollectionsStaticMethodInspectionKt {
    private static final Pair<String, KtValueArgument> getTargetMethodOnMutableList(KtDotQualifiedExpression expression) {
        return JavaCollectionsStaticMethodInspectionKt.getTargetMethod(expression, (Function1<? super KotlinType, Boolean>)((Function1)JavaCollectionsStaticMethodInspectionKt::getTargetMethodOnMutableList$lambda$0));
    }

    private static final Pair<String, KtValueArgument> getTargetMethod(KtDotQualifiedExpression expression, Function1<? super KotlinType, Boolean> isValidFirstArgument) {
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)expression);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        List list2 = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        List args = list2;
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)args);
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument firstArg = ktValueArgument;
        BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)expression, BodyResolveMode.PARTIAL);
        KtExpression ktExpression = firstArg.getArgumentExpression();
        if (!(ktExpression != null && (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2)) != null ? ((Boolean)isValidFirstArgument.invoke((Object)ktExpression)).booleanValue() : false)) {
            return null;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)context2);
        CallableDescriptor callableDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        JavaMethodDescriptor javaMethodDescriptor = callableDescriptor instanceof JavaMethodDescriptor ? (JavaMethodDescriptor)callableDescriptor : null;
        if (javaMethodDescriptor == null) {
            return null;
        }
        JavaMethodDescriptor descriptor2 = javaMethodDescriptor;
        Object object = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
        if (object == null || (object = object.asString()) == null) {
            return null;
        }
        Object fqName2 = object;
        if (!JavaCollectionsStaticMethodInspectionKt.canReplaceWithStdLib(expression, (String)fqName2, args)) {
            return null;
        }
        String[] stringArray = new String[]{"."};
        String methodName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)fqName2), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        return TuplesKt.to((Object)methodName, (Object)firstArg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canReplaceWithStdLib(KtDotQualifiedExpression expression, String fqName2, List<? extends KtValueArgument> args) {
        if (!StringsKt.startsWith$default((String)fqName2, (String)"java.util.Collections.", (boolean)false, (int)2, null)) {
            return false;
        }
        int size = args.size();
        switch (fqName2) {
            case "java.util.Collections.fill": {
                if (!JavaCollectionsStaticMethodInspectionKt.checkApiVersion(ApiVersion.KOTLIN_1_2, expression)) return false;
                if (size != 2) return false;
                return true;
            }
            case "java.util.Collections.reverse": {
                if (size != 1) return false;
                return true;
            }
            case "java.util.Collections.shuffle": {
                if (!JavaCollectionsStaticMethodInspectionKt.checkApiVersion(ApiVersion.KOTLIN_1_2, expression)) return false;
                if (size == 1) return true;
                if (size != 2) return false;
                return true;
            }
            case "java.util.Collections.sort": {
                if (size == 1) return true;
                if (size != 2) return false;
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull(args, (int)1);
                if (!((ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null) instanceof KtLambdaExpression)) return false;
                return true;
            }
            default: {
                return false;
            }
        }
    }

    private static final boolean checkApiVersion(ApiVersion requiredVersion, KtDotQualifiedExpression expression) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)expression));
        if (module == null) {
            return true;
        }
        Module module2 = module;
        return LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(module2).getApiVersion().compareTo(requiredVersion) >= 0;
    }

    private static final boolean isMutableList(KotlinType $this$isMutableList) {
        ClassifierDescriptor classifierDescriptor = $this$isMutableList.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null), (Object)StandardNames.FqNames.mutableList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMutableListOrSubtype(KotlinType $this$isMutableListOrSubtype) {
        KotlinType it;
        if (JavaCollectionsStaticMethodInspectionKt.isMutableList($this$isMutableListOrSubtype)) return true;
        Collection collection = $this$isMutableListOrSubtype.getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSupertypes(...)");
        Iterable $this$any$iv = CollectionsKt.reversed((Iterable)collection);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
        } while (!JavaCollectionsStaticMethodInspectionKt.isMutableList(it));
        return true;
    }

    private static final boolean isList(KotlinType $this$isList) {
        ClassifierDescriptor classifierDescriptor = $this$isList.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null), (Object)StandardNames.FqNames.list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isListOrSubtype(KotlinType $this$isListOrSubtype) {
        KotlinType it;
        if (JavaCollectionsStaticMethodInspectionKt.isList($this$isListOrSubtype)) return true;
        Collection collection = $this$isListOrSubtype.getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSupertypes(...)");
        Iterable $this$any$iv = CollectionsKt.reversed((Iterable)collection);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
        } while (!JavaCollectionsStaticMethodInspectionKt.isList(it));
        return true;
    }

    private static final boolean getTargetMethodOnMutableList$lambda$0(KotlinType $this$getTargetMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetMethod, (String)"$this$getTargetMethod");
        return JavaCollectionsStaticMethodInspectionKt.isMutableListOrSubtype($this$getTargetMethod);
    }

    public static final /* synthetic */ Pair access$getTargetMethod(KtDotQualifiedExpression expression, Function1 isValidFirstArgument) {
        return JavaCollectionsStaticMethodInspectionKt.getTargetMethod(expression, (Function1<? super KotlinType, Boolean>)isValidFirstArgument);
    }

    public static final /* synthetic */ boolean access$isListOrSubtype(KotlinType $receiver) {
        return JavaCollectionsStaticMethodInspectionKt.isListOrSubtype($receiver);
    }

    public static final /* synthetic */ boolean access$isMutableListOrSubtype(KotlinType $receiver) {
        return JavaCollectionsStaticMethodInspectionKt.isMutableListOrSubtype($receiver);
    }

    public static final /* synthetic */ Pair access$getTargetMethodOnMutableList(KtDotQualifiedExpression expression) {
        return JavaCollectionsStaticMethodInspectionKt.getTargetMethodOnMutableList(expression);
    }
}

