/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\b*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AssignBackingFieldFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "removeRedundantWhiteSpace", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSetterBackingFieldAssignmentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetterBackingFieldAssignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/AssignBackingFieldFix\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n385#2,11:111\n1#3:122\n*S KotlinDebug\n*F\n+ 1 SetterBackingFieldAssignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/AssignBackingFieldFix\n*L\n106#1:111,11\n*E\n"})
final class AssignBackingFieldFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message((String)"assign.backing.field.fix.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        KtPropertyAccessor ktPropertyAccessor = psiElement instanceof KtPropertyAccessor ? (KtPropertyAccessor)psiElement : null;
        if (ktPropertyAccessor == null) {
            return;
        }
        KtPropertyAccessor setter = ktPropertyAccessor;
        List list2 = setter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull((List)list2);
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        KtBlockExpression ktBlockExpression = setter.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        this.removeRedundantWhiteSpace(bodyExpression);
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)setter, false, 2, null);
        KtExpression assignment2 = psiFactory.createExpression("field = " + parameter.getName());
        List list3 = bodyExpression.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getStatements(...)");
        KtExpression lastStatement = (KtExpression)CollectionsKt.lastOrNull((List)list3);
        if (lastStatement != null) {
            bodyExpression.addAfter((PsiElement)assignment2, (PsiElement)lastStatement);
            bodyExpression.addAfter(psiFactory.createNewLine(), (PsiElement)lastStatement);
            v5 = GenericPsiUtils.reformatted$default((PsiElement)bodyExpression, false, 1, null);
        } else {
            v5 = bodyExpression.addBefore((PsiElement)assignment2, bodyExpression.getRBrace());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeRedundantWhiteSpace(KtBlockExpression $this$removeRedundantWhiteSpace) {
        block4: {
            Object v0;
            Sequence sequence;
            block3: {
                void $this$singleOrNull$iv;
                Sequence sequence2;
                Sequence sequence3;
                PsiElement psiElement = $this$removeRedundantWhiteSpace.getLBrace();
                if (psiElement == null || (sequence3 = PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)1, null)) == null || (sequence2 = SequencesKt.takeWhile((Sequence)sequence3, arg_0 -> AssignBackingFieldFix.removeRedundantWhiteSpace$lambda$0($this$removeRedundantWhiteSpace, arg_0))) == null) break block4;
                sequence = sequence2;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PsiWhiteSpace)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            PsiElement psiElement = v0;
            if (psiElement != null) {
                Sequence it = sequence = psiElement;
                boolean bl = false;
                it.delete();
            }
        }
    }

    private static final boolean removeRedundantWhiteSpace$lambda$0(KtBlockExpression $this_removeRedundantWhiteSpace, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$this_removeRedundantWhiteSpace.getRBrace());
    }
}

