/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.psi.PsiElement;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u001a$\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"getCurrentDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "positionManager", "Lcom/intellij/debugger/PositionManager;", "location", "Lcom/sun/jdi/Location;", "methodNameMatches", "", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "name", "", "nameMatchesUpToDollar", "methodName", "targetMethodName", "isInlinedFromFunction", "Lcom/sun/jdi/LocalVariable;", "isNameMangledInBytecode", "isInternalMethod", "getMethodNameInCallerFrame", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n774#2:174\n865#2,2:175\n295#2,2:177\n295#2,2:179\n*S KotlinDebug\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilterKt\n*L\n126#1:174\n126#1:175,2\n132#1:177,2\n134#1:179,2\n*E\n"})
public final class KotlinMethodFilterKt {
    /*
     * WARNING - void declaration
     */
    private static final KtDeclaration getCurrentDeclaration(PositionManager positionManager, Location location) {
        Class[] classArray;
        SourcePosition sourcePosition = positionManager.getSourcePosition(location);
        Object elementAt = sourcePosition != null ? sourcePosition.getElementAt() : null;
        PsiElement psiElement = elementAt;
        if (psiElement == null || (psiElement = (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)psiElement, (boolean)false, (Class[])(classArray = new Class[]{KtDeclaration.class}), KotlinMethodFilterKt::getCurrentDeclaration$lambda$0)) == null) {
            return null;
        }
        PsiElement declaration = psiElement;
        if (declaration instanceof KtProperty) {
            void $this$filterTo$iv$iv;
            int currentLine = DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true);
            List list2 = ((KtProperty)declaration).getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtPropertyAccessor it = (KtPropertyAccessor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(PsiLinesUtilsKt.getLineNumber$default((PsiElement)it, false, 1, null) == currentLine)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List accessorsOnLine = (List)destination$iv$iv;
            if (!((Collection)accessorsOnLine).isEmpty()) {
                String methodName;
                if (accessorsOnLine.size() == 1) {
                    return (KtDeclaration)CollectionsKt.single((List)accessorsOnLine);
                }
                Method method = SafeUtilKt.safeMethod(location);
                String string = methodName = method != null ? method.name() : null;
                if (methodName != null) {
                    KtDeclaration ktDeclaration;
                    if (JvmAbi.isSetterName((String)methodName)) {
                        Object v5;
                        block10: {
                            Iterable $this$firstOrNull$iv = accessorsOnLine;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (KtPropertyAccessor)element$iv;
                                boolean bl = false;
                                if (!it.isSetter()) continue;
                                v5 = element$iv;
                                break block10;
                            }
                            v5 = null;
                        }
                        ktDeclaration = v5;
                    } else {
                        Object v7;
                        block11: {
                            Iterable $this$firstOrNull$iv = accessorsOnLine;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (KtPropertyAccessor)element$iv;
                                boolean bl = false;
                                if (!it.isGetter()) continue;
                                v7 = element$iv;
                                break block11;
                            }
                            v7 = null;
                        }
                        ktDeclaration = v7;
                    }
                    return ktDeclaration;
                }
            }
        }
        return declaration;
    }

    public static final boolean methodNameMatches(@NotNull CallableMemberInfo methodInfo, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (Intrinsics.areEqual((Object)methodInfo.getName(), (Object)name2)) {
            return true;
        }
        if (methodInfo.isInternalMethod() || methodInfo.isLocal()) {
            return KotlinMethodFilterKt.nameMatchesUpToDollar(name2, methodInfo.getName());
        }
        return false;
    }

    private static final boolean nameMatchesUpToDollar(String methodName, String targetMethodName) {
        return StringsKt.startsWith$default((String)methodName, (String)(targetMethodName + "$"), (boolean)false, (int)2, null);
    }

    private static final boolean isInlinedFromFunction(LocalVariable $this$isInlinedFromFunction, String methodName, boolean isNameMangledInBytecode, boolean isInternalMethod) {
        String string = $this$isInlinedFromFunction.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String variableName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(InlineScopeUtilsKt.dropInlineScopeInfo((String)string), isNameMangledInBytecode);
        if (!StringsKt.startsWith$default((String)variableName, (String)"$i$f$", (boolean)false, (int)2, null)) {
            return false;
        }
        String inlineMethodName = StringsKt.substringAfter$default((String)variableName, (String)"$i$f$", null, (int)2, null);
        return Intrinsics.areEqual((Object)inlineMethodName, (Object)methodName) || isInternalMethod && KotlinMethodFilterKt.nameMatchesUpToDollar(inlineMethodName, methodName);
    }

    private static final String getMethodNameInCallerFrame(StackFrameProxyImpl frameProxy) {
        StackFrameProxyImpl stackFrameProxyImpl = frameProxy;
        if (stackFrameProxyImpl == null || (stackFrameProxyImpl = stackFrameProxyImpl.threadProxy()) == null) {
            return null;
        }
        StackFrameProxyImpl threadProxy = stackFrameProxyImpl;
        int callerFrameIndex = frameProxy.getFrameIndex() + 1;
        if (callerFrameIndex >= threadProxy.frameCount()) {
            return null;
        }
        StackFrameProxyImpl callerFrame = threadProxy.frame(callerFrameIndex);
        Object object = callerFrame;
        return object != null && (object = SafeUtilKt.safeLocation((StackFrameProxy)object)) != null && (object = SafeUtilKt.safeMethod((Location)object)) != null ? object.name() : null;
    }

    private static final boolean getCurrentDeclaration$lambda$0(KtDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof KtProperty) || !((KtProperty)it).isLocal();
    }

    public static final /* synthetic */ KtDeclaration access$getCurrentDeclaration(PositionManager positionManager, Location location) {
        return KotlinMethodFilterKt.getCurrentDeclaration(positionManager, location);
    }

    public static final /* synthetic */ String access$getMethodNameInCallerFrame(StackFrameProxyImpl frameProxy) {
        return KotlinMethodFilterKt.getMethodNameInCallerFrame(frameProxy);
    }

    public static final /* synthetic */ boolean access$isInlinedFromFunction(LocalVariable $receiver, String methodName, boolean isNameMangledInBytecode, boolean isInternalMethod) {
        return KotlinMethodFilterKt.isInlinedFromFunction($receiver, methodName, isNameMangledInBytecode, isInternalMethod);
    }
}

