/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.google.gson.Gson;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineJobHierarchyProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFramesProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.LazyCoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineInfoProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016JO\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\r2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\rH\u0002\u00a2\u0006\u0002\u0010\u0018J<\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001b\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\r\"\u0006\b\u0000\u0010!\u0018\u0001*\u00020\"H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineInfoProvider;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "debugProbesImpl", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugProbesImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugProbesImpl;)V", "stackFramesProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFramesProvider;", "jobHierarchyProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineJobHierarchyProvider;", "dumpCoroutinesInfo", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "calculateCoroutineInfoData", "coroutineInfos", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider$CoroutineInfoFromJson;", "coroutineInfoRefs", "Lcom/sun/jdi/ObjectReference;", "lastObservedThreadRefs", "Lcom/sun/jdi/ThreadReference;", "lastObservedFrameRefs", "([Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider$CoroutineInfoFromJson;Ljava/util/List;Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "getLazyCoroutineInfoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/LazyCoroutineInfoData;", "info", "coroutineInfoRef", "lastObservedThreadRef", "lastObservedFrameRef", "stackTraceProvider", "toTypedList", "T", "Lcom/sun/jdi/ArrayReference;", "CoroutineInfoFromJson", "Companion", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutinesInfoFromJsonAndReferencesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutinesInfoFromJsonAndReferencesProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,133:1\n112#1,8:136\n112#1,8:145\n112#1,8:154\n119#2:134\n119#2:135\n119#2:144\n119#2:153\n*S KotlinDebug\n*F\n+ 1 CoroutinesInfoFromJsonAndReferencesProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider\n*L\n30#1:136,8\n32#1:145,8\n34#1:154,8\n28#1:134\n30#1:135\n32#1:144\n34#1:153\n*E\n"})
public final class CoroutinesInfoFromJsonAndReferencesProvider
implements CoroutineInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultExecutionContext executionContext;
    @NotNull
    private final DebugProbesImpl debugProbesImpl;
    @NotNull
    private final CoroutineStackFramesProvider stackFramesProvider;
    @NotNull
    private final CoroutineJobHierarchyProvider jobHierarchyProvider;
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();

    public CoroutinesInfoFromJsonAndReferencesProvider(@NotNull DefaultExecutionContext executionContext, @NotNull DebugProbesImpl debugProbesImpl) {
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)debugProbesImpl, (String)"debugProbesImpl");
        this.executionContext = executionContext;
        this.debugProbesImpl = debugProbesImpl;
        this.stackFramesProvider = new CoroutineStackFramesProvider(this.executionContext);
        this.jobHierarchyProvider = new CoroutineJobHierarchyProvider();
    }

    @Override
    @NotNull
    public List<CoroutineInfoData> dumpCoroutinesInfo() {
        List list2;
        List result$iv2;
        List result$iv3;
        Object object;
        ArrayReference arrayReference = this.debugProbesImpl.dumpCoroutinesInfoAsJsonAndReferences(this.executionContext);
        if (arrayReference == null) {
            return CollectionsKt.emptyList();
        }
        ArrayReference array = arrayReference;
        if (array.length() != 4) {
            throw new IllegalStateException("The result array of 'dumpCoroutinesInfoAsJSONAndReferences' should be of size 4".toString());
        }
        Value $this$safeAs$iv = array.getValue(0);
        boolean $i$f$safeAs = false;
        Value value = $this$safeAs$iv;
        if (!(value instanceof StringReference)) {
            value = null;
        }
        if ((object = (StringReference)value) == null || (object = object.value()) == null) {
            throw new IllegalStateException("The first element of the result array must be a string".toString());
        }
        Object coroutinesInfoAsJsonString = object;
        Value $this$safeAs$iv2 = array.getValue(1);
        boolean $i$f$safeAs222 = false;
        Value value2 = $this$safeAs$iv2;
        if (!(value2 instanceof ArrayReference)) {
            value2 = null;
        }
        if (($this$safeAs$iv = (ArrayReference)value2) != null) {
            CoroutinesInfoFromJsonAndReferencesProvider $i$f$safeAs222 = this;
            Value $this$toTypedList$iv = $this$safeAs$iv;
            boolean $i$f$toTypedList = false;
            result$iv3 = new ArrayList();
            Iterator<Value> iterator2 = $this$toTypedList$iv.getValues().iterator();
            while (iterator2.hasNext()) {
                Value value3;
                Value value4 = value3 = iterator2.next();
                if (!(value4 != null ? value4 instanceof ThreadReference : true)) {
                    throw new IllegalStateException(("Value has type " + value3.getClass() + ", but " + ThreadReference.class + " was expected").toString());
                }
                result$iv3.add(value3);
            }
        } else {
            throw new IllegalStateException("The second element of the result array must be an array".toString());
        }
        List lastObservedThreadRefs = result$iv3;
        Value $this$safeAs$iv3 = array.getValue(2);
        boolean $i$f$safeAs322 = false;
        Value value5 = $this$safeAs$iv3;
        if (!(value5 instanceof ArrayReference)) {
            value5 = null;
        }
        if (($this$safeAs$iv2 = (ArrayReference)value5) != null) {
            CoroutinesInfoFromJsonAndReferencesProvider $i$f$safeAs322 = this;
            Value $this$toTypedList$iv = $this$safeAs$iv2;
            boolean $i$f$toTypedList = false;
            result$iv2 = new ArrayList();
            Iterator<Value> iterator3 = $this$toTypedList$iv.getValues().iterator();
            while (iterator3.hasNext()) {
                Value value$iv2;
                Value value6 = value$iv2 = iterator3.next();
                if (!(value6 != null ? value6 instanceof ObjectReference : true)) {
                    throw new IllegalStateException(("Value has type " + value$iv2.getClass() + ", but " + ObjectReference.class + " was expected").toString());
                }
                result$iv2.add(value$iv2);
            }
        } else {
            throw new IllegalStateException("The third element of the result array must be an array".toString());
        }
        List lastObservedFrameRefs = result$iv2;
        Value $this$safeAs$iv4 = array.getValue(3);
        boolean $i$f$safeAs422 = false;
        Value value7 = $this$safeAs$iv4;
        if (!(value7 instanceof ArrayReference)) {
            value7 = null;
        }
        if (($this$safeAs$iv3 = (ArrayReference)value7) != null) {
            CoroutinesInfoFromJsonAndReferencesProvider $i$f$safeAs422 = this;
            Value $this$toTypedList$iv = $this$safeAs$iv3;
            boolean $i$f$toTypedList = false;
            list2 = new ArrayList();
            for (Value value$iv : $this$toTypedList$iv.getValues()) {
                if (!(value$iv instanceof ObjectReference)) {
                    throw new IllegalStateException(("Value has type " + value$iv.getClass() + ", but " + ObjectReference.class + " was expected").toString());
                }
                list2.add(value$iv);
            }
        } else {
            throw new IllegalStateException("The fourth element of the result array must be an array".toString());
        }
        List coroutineInfoRefs = list2;
        CoroutineInfoFromJson[] coroutinesInfo = (CoroutineInfoFromJson[])new Gson().fromJson((String)coroutinesInfoAsJsonString, CoroutineInfoFromJson[].class);
        if (coroutineInfoRefs.size() != lastObservedFrameRefs.size() || lastObservedFrameRefs.size() != coroutinesInfo.length || coroutinesInfo.length != lastObservedThreadRefs.size()) {
            throw new IllegalStateException("Arrays must have equal sizes".toString());
        }
        Intrinsics.checkNotNull((Object)coroutinesInfo);
        return this.calculateCoroutineInfoData(coroutinesInfo, coroutineInfoRefs, lastObservedThreadRefs, lastObservedFrameRefs);
    }

    private final List<CoroutineInfoData> calculateCoroutineInfoData(CoroutineInfoFromJson[] coroutineInfos, List<? extends ObjectReference> coroutineInfoRefs, List<? extends ThreadReference> lastObservedThreadRefs, List<? extends ObjectReference> lastObservedFrameRefs) {
        List result2 = new ArrayList();
        int n = coroutineInfos.length;
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            CoroutineInfoFromJson info2 = coroutineInfos[j];
            result2.add(this.getLazyCoroutineInfoData(info2, coroutineInfoRefs.get(i2), lastObservedThreadRefs.get(i2), lastObservedFrameRefs.get(i2), this.stackFramesProvider, this.jobHierarchyProvider));
        }
        return result2;
    }

    private final LazyCoroutineInfoData getLazyCoroutineInfoData(CoroutineInfoFromJson info2, ObjectReference coroutineInfoRef, ThreadReference lastObservedThreadRef, ObjectReference lastObservedFrameRef, CoroutineStackFramesProvider stackTraceProvider, CoroutineJobHierarchyProvider jobHierarchyProvider) {
        Object object;
        block3: {
            block2: {
                DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
                CoroutineInfo coroutineInfo = CoroutineInfo.Companion.instance(this.executionContext);
                ObjectReference contextRef = coroutineInfo != null ? coroutineInfo.getContextRef(coroutineInfoRef) : null;
                object = contextRef;
                if (object == null) break block2;
                ObjectReference it = object;
                boolean bl = false;
                MirrorOfCoroutineContext mirrorOfCoroutineContext = new CoroutineContext(this.executionContext).fetchMirror(info2.getName(), info2.getId(), info2.getDispatcher(), it, this.executionContext);
                object = mirrorOfCoroutineContext;
                if (mirrorOfCoroutineContext != null) break block3;
            }
            object = new MirrorOfCoroutineContext(info2.getName(), info2.getId(), info2.getDispatcher(), null, null);
        }
        Object coroutineContextMirror = object;
        MirrorOfCoroutineInfo coroutineInfoMirror = this.debugProbesImpl.getCoroutineInfo(coroutineInfoRef, this.executionContext, (MirrorOfCoroutineContext)coroutineContextMirror, info2.getSequenceNumber(), info2.getState(), lastObservedThreadRef, lastObservedFrameRef);
        return new LazyCoroutineInfoData(coroutineInfoMirror, stackTraceProvider, jobHierarchyProvider);
    }

    private final /* synthetic */ <T> List<T> toTypedList(ArrayReference $this$toTypedList) {
        boolean $i$f$toTypedList = false;
        List result2 = new ArrayList();
        for (Value value : $this$toTypedList.getValues()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(value instanceof Object)) {
                Class<?> clazz = value.getClass();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                throw new IllegalStateException(("Value has type " + clazz + ", but " + Object.class + " was expected").toString());
            }
            result2.add(value);
        }
        return result2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider$Companion;", "", "<init>", "()V", "instance", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "debugProbesImpl", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugProbesImpl;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @Nullable
        public final CoroutinesInfoFromJsonAndReferencesProvider instance(@NotNull DefaultExecutionContext executionContext, @NotNull DebugProbesImpl debugProbesImpl) {
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)debugProbesImpl, (String)"debugProbesImpl");
            if (debugProbesImpl.canDumpCoroutinesInfoAsJsonAndReferences()) {
                return new CoroutinesInfoFromJsonAndReferencesProvider(executionContext, debugProbesImpl);
            }
            return null;
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JJ\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider$CoroutineInfoFromJson;", "", "name", "", "id", "", "dispatcher", "sequenceNumber", "state", "<init>", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getDispatcher", "getSequenceNumber", "getState", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;)Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutinesInfoFromJsonAndReferencesProvider$CoroutineInfoFromJson;", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.coroutines"})
    private static final class CoroutineInfoFromJson {
        @Nullable
        private final String name;
        @Nullable
        private final Long id;
        @Nullable
        private final String dispatcher;
        @Nullable
        private final Long sequenceNumber;
        @Nullable
        private final String state;

        public CoroutineInfoFromJson(@Nullable String name2, @Nullable Long id, @Nullable String dispatcher, @Nullable Long sequenceNumber, @Nullable String state) {
            this.name = name2;
            this.id = id;
            this.dispatcher = dispatcher;
            this.sequenceNumber = sequenceNumber;
            this.state = state;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Long getId() {
            return this.id;
        }

        @Nullable
        public final String getDispatcher() {
            return this.dispatcher;
        }

        @Nullable
        public final Long getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Nullable
        public final String getState() {
            return this.state;
        }

        @Nullable
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final Long component2() {
            return this.id;
        }

        @Nullable
        public final String component3() {
            return this.dispatcher;
        }

        @Nullable
        public final Long component4() {
            return this.sequenceNumber;
        }

        @Nullable
        public final String component5() {
            return this.state;
        }

        @NotNull
        public final CoroutineInfoFromJson copy(@Nullable String name2, @Nullable Long id, @Nullable String dispatcher, @Nullable Long sequenceNumber, @Nullable String state) {
            return new CoroutineInfoFromJson(name2, id, dispatcher, sequenceNumber, state);
        }

        public static /* synthetic */ CoroutineInfoFromJson copy$default(CoroutineInfoFromJson coroutineInfoFromJson, String string, Long l, String string2, Long l2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = coroutineInfoFromJson.name;
            }
            if ((n & 2) != 0) {
                l = coroutineInfoFromJson.id;
            }
            if ((n & 4) != 0) {
                string2 = coroutineInfoFromJson.dispatcher;
            }
            if ((n & 8) != 0) {
                l2 = coroutineInfoFromJson.sequenceNumber;
            }
            if ((n & 0x10) != 0) {
                string3 = coroutineInfoFromJson.state;
            }
            return coroutineInfoFromJson.copy(string, l, string2, l2, string3);
        }

        @NotNull
        public String toString() {
            return "CoroutineInfoFromJson(name=" + this.name + ", id=" + this.id + ", dispatcher=" + this.dispatcher + ", sequenceNumber=" + this.sequenceNumber + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result2 = this.name == null ? 0 : this.name.hashCode();
            result2 = result2 * 31 + (this.id == null ? 0 : ((Object)this.id).hashCode());
            result2 = result2 * 31 + (this.dispatcher == null ? 0 : this.dispatcher.hashCode());
            result2 = result2 * 31 + (this.sequenceNumber == null ? 0 : ((Object)this.sequenceNumber).hashCode());
            result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoroutineInfoFromJson)) {
                return false;
            }
            CoroutineInfoFromJson coroutineInfoFromJson = (CoroutineInfoFromJson)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)coroutineInfoFromJson.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)coroutineInfoFromJson.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dispatcher, (Object)coroutineInfoFromJson.dispatcher)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sequenceNumber, (Object)coroutineInfoFromJson.sequenceNumber)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.state, (Object)coroutineInfoFromJson.state);
        }
    }
}

