/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.sun.jdi.ThreadReference;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineDescriptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\f\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "", "descriptor", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;", "continuationStackFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "getContinuationStackFrames", "()Ljava/util/List;", "creationStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "getCreationStackFrames", "activeThread", "Lcom/sun/jdi/ThreadReference;", "getActiveThread", "()Lcom/sun/jdi/ThreadReference;", "jobHierarchy", "", "getJobHierarchy", "topFrameVariables", "Lcom/intellij/debugger/engine/JavaValue;", "getTopFrameVariables", "topFrameVariables$delegate", "Lkotlin/Lazy;", "isSuspended", "", "isCreated", "isRunning", "isRunningOnCurrentThread", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContext;", "Companion", "kotlin.jvm-debugger.coroutines"})
public abstract class CoroutineInfoData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineDescriptor descriptor;
    @NotNull
    private final Lazy topFrameVariables$delegate;
    @NotNull
    public static final String DEFAULT_COROUTINE_NAME = "coroutine";
    @NotNull
    public static final String DEFAULT_COROUTINE_STATE = "UNKNOWN";

    public CoroutineInfoData(@NotNull CoroutineDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.descriptor = descriptor2;
        this.topFrameVariables$delegate = LazyKt.lazy(() -> CoroutineInfoData.topFrameVariables_delegate$lambda$0(this));
    }

    @NotNull
    public final CoroutineDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public abstract List<CoroutineStackFrameItem> getContinuationStackFrames();

    @NotNull
    public abstract List<CreationCoroutineStackFrameItem> getCreationStackFrames();

    @Nullable
    public abstract ThreadReference getActiveThread();

    @NotNull
    public abstract List<String> getJobHierarchy();

    @NotNull
    public final List<JavaValue> getTopFrameVariables() {
        Lazy lazy = this.topFrameVariables$delegate;
        return (List)lazy.getValue();
    }

    public final boolean isSuspended() {
        return this.descriptor.getState() == State.SUSPENDED;
    }

    public final boolean isCreated() {
        return this.descriptor.getState() == State.CREATED;
    }

    public final boolean isRunning() {
        return this.descriptor.getState() == State.RUNNING;
    }

    public final boolean isRunningOnCurrentThread(@NotNull SuspendContext suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        ThreadReferenceProxy threadReferenceProxy = suspendContext.getThread();
        return Intrinsics.areEqual((Object)this.getActiveThread(), (Object)(threadReferenceProxy != null ? threadReferenceProxy.getThreadReference() : null));
    }

    private static final List topFrameVariables_delegate$lambda$0(CoroutineInfoData this$0) {
        Object object = (CoroutineStackFrameItem)((Object)CollectionsKt.firstOrNull(this$0.getContinuationStackFrames()));
        if (object == null || (object = object.getSpilledVariables()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData$Companion;", "", "<init>", "()V", "DEFAULT_COROUTINE_NAME", "", "DEFAULT_COROUTINE_STATE", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

