/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Accessible;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculator;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinFileSelector;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 K2\u00020\u0001:\u0002JKB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J$\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ!\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u0003H\u0002J\u0018\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u00106\u001a\u00020\u00162\u0006\u0010%\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010<\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\b\u001a\u00020?H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010\b\u001a\u00020?H\u0002J\u0013\u0010B\u001a\u0004\u0018\u00010?2\u0006\u0010\b\u001a\u00020?H\u0082\u0010J\u001a\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0018\u00010D*\u00020,H\u0002J\f\u0010E\u001a\u00020\u0003*\u00020,H\u0002J\f\u0010F\u001a\u00020\u0003*\u00020,H\u0002J\u001a\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0018\u00010D*\u00020,H\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010'\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinFileSelector;", "checkClassFqName", "", "<init>", "(Z)V", "analyze", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "chooseMostApplicableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "location", "Lcom/sun/jdi/Location;", "(Ljava/util/List;Lcom/sun/jdi/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rankFiles", "", "", "", "collect", "Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "conditions", "", "", "([Ljava/lang/Object;)Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "rankingForClass", "clazz", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "fqName", "", "virtualMachine", "Lcom/sun/jdi/VirtualMachine;", "type", "Lcom/sun/jdi/ReferenceType;", "rankingForClassName", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "bindingContext", "rankingForMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "method", "Lcom/sun/jdi/Method;", "rankingForAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getPropertyName", "accessorMethodName", "isSetter", "rankingForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "rankingForVisibility", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "accessible", "Lcom/sun/jdi/Accessible;", "fileRankingSafe", "file", "fileRanking", "findFunctionLiteralOnLine", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "Lcom/intellij/psi/PsiElement;", "findAnonymousFunctionInParent", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findNonLocalCallableParent", "getContainingClassAndMethodNameForLambda", "Lkotlin/Pair;", "isAnonymousClassLambda", "isIndyLambda", "getContainingClassAndMethodNameForIndyLambda", "makeTypeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "Ranking", "Companion", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nFileRankingCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileRankingCalculator.kt\norg/jetbrains/kotlin/idea/debugger/FileRankingCalculator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,394:1\n1#2:395\n11165#3:396\n11500#3,3:397\n1797#4,3:400\n1755#4,3:413\n133#5:403\n133#5:404\n133#5:405\n137#5:406\n133#5:407\n133#5:408\n133#5:409\n133#5:410\n141#5:411\n133#5:412\n*S KotlinDebug\n*F\n+ 1 FileRankingCalculator.kt\norg/jetbrains/kotlin/idea/debugger/FileRankingCalculator\n*L\n73#1:396\n73#1:397,3\n80#1:400,3\n346#1:413,3\n219#1:403\n234#1:404\n245#1:405\n247#1:406\n270#1:407\n279#1:408\n284#1:409\n299#1:410\n319#1:411\n311#1:412\n*E\n"})
public abstract class FileRankingCalculator
implements KotlinFileSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean checkClassFqName;
    @NotNull
    private static final Regex INDY_LAMBDA_NAME_REGEX = new Regex("([^$]+)\\$lambda\\$\\d+.*");
    @NotNull
    private static final Logger LOG;

    public FileRankingCalculator(boolean checkClassFqName) {
        this.checkClassFqName = checkClassFqName;
    }

    public /* synthetic */ FileRankingCalculator(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public abstract BindingContext analyze(@NotNull KtElement var1);

    @Override
    @Nullable
    public Object chooseMostApplicableFile(@NotNull List<? extends KtFile> files2, @NotNull Location location, @NotNull Continuation<? super KtFile> $completion) {
        return FileRankingCalculator.chooseMostApplicableFile$suspendImpl(this, files2, location, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object chooseMostApplicableFile$suspendImpl(FileRankingCalculator var0, List<? extends KtFile> var1_1, Location var2_2, Continuation<? super KtFile> $completion) {
        if (!($completion instanceof chooseMostApplicableFile.1)) ** GOTO lbl-1000
        var14_4 = $completion;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ FileRankingCalculator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FileRankingCalculator.chooseMostApplicableFile$suspendImpl(this.this$0, null, null, (Continuation<? super KtFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = CoroutinesKt.blockingContext((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, chooseMostApplicableFile$lambda$1(org.jetbrains.kotlin.idea.debugger.FileRankingCalculator java.util.List com.sun.jdi.Location ), ()Ljava/util/Map;)((FileRankingCalculator)$this, (List)files, (Location)location), (Continuation)$continuation);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if (!(var7_9 = (var6_8 = (Iterable)(fileWithRankings = (Map)v0).entrySet()).iterator()).hasNext()) {
                    v1 = null;
                } else {
                    var8_10 = var7_9.next();
                    if (!var7_9.hasNext()) {
                        v1 = var8_10;
                    } else {
                        it = (Map.Entry)var8_10;
                        $i$a$-maxByOrNull-FileRankingCalculator$chooseMostApplicableFile$fileWithMaxScore$1 = false;
                        var9_12 = ((Number)it.getValue()).intValue();
                        do {
                            var10_14 = var7_9.next();
                            it = (Map.Entry)var10_14;
                            $i$a$-maxByOrNull-FileRankingCalculator$chooseMostApplicableFile$fileWithMaxScore$1 = false;
                            var11_15 = ((Number)it.getValue()).intValue();
                            if (var9_12 >= var11_15) continue;
                            var8_10 = var10_14;
                            var9_12 = var11_15;
                        } while (var7_9.hasNext());
                        v1 = var8_10;
                    }
                }
                v2 = v1;
                Intrinsics.checkNotNull((Object)v2);
                fileWithMaxScore = v2;
                return fileWithMaxScore.getKey();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final Map<KtFile, Integer> rankFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Location location) {
        boolean bl;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        boolean bl2 = bl = !files2.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((Iterable)files2, arg_0 -> FileRankingCalculator.rankFiles$lambda$3(this, location, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final Ranking collect(Object ... conditions) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Object $this$map$iv = conditions;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Ranking ranking;
            void condition2;
            void item$iv$iv;
            void var10_15 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_18 = condition2;
            if (var12_18 instanceof Boolean) {
                ranking = Ranking.Companion.minor((Boolean)condition2);
            } else if (var12_18 instanceof Integer) {
                ranking = new Ranking(((Number)condition2).intValue());
            } else if (var12_18 instanceof Ranking) {
                ranking = (Ranking)condition2;
            } else {
                throw new IllegalStateException(("Invalid condition type " + condition2.getClass().getName()).toString());
            }
            collection.add(ranking);
        }
        $this$map$iv = (List)destination$iv$iv;
        Ranking initial$iv = Ranking.Companion.getZERO();
        boolean $i$f$fold = false;
        Ranking accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void r;
            Ranking ranking = (Ranking)element$iv;
            Ranking sum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = sum.plus((Ranking)r);
        }
        return accumulator$iv;
    }

    private final Ranking rankingForClass(KtClassOrObject clazz, String fqName2, VirtualMachine virtualMachine) {
        BindingContext bindingContext = this.analyze((KtElement)clazz);
        ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)clazz);
        if (classDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        List<ReferenceType> list2 = virtualMachine.classesByName(fqName2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classesByName(...)");
        ReferenceType referenceType = (ReferenceType)CollectionsKt.firstOrNull(list2);
        if (referenceType == null) {
            FileRankingCalculator $this$rankingForClass_u24lambda_u246 = this;
            boolean bl = false;
            return $this$rankingForClass_u24lambda_u246.rankingForClassName(fqName2, descriptor2, bindingContext);
        }
        ReferenceType jdiType = referenceType;
        return this.rankingForClass(clazz, jdiType);
    }

    private final Ranking rankingForClass(KtClassOrObject clazz, ReferenceType type2) {
        BindingContext bindingContext = this.analyze((KtElement)clazz);
        ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)clazz);
        if (classDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        Object[] objectArray = new Object[5];
        String string = type2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        objectArray[0] = this.rankingForClassName(string, descriptor2, bindingContext);
        objectArray[1] = Ranking.Companion.minor(type2.isAbstract() && descriptor2.getModality() == Modality.ABSTRACT);
        objectArray[2] = Ranking.Companion.minor(type2.isFinal() && descriptor2.getModality() == Modality.FINAL);
        objectArray[3] = Ranking.Companion.minor(type2.isStatic() && !descriptor2.isInner());
        objectArray[4] = this.rankingForVisibility((DeclarationDescriptorWithVisibility)descriptor2, type2);
        return this.collect(objectArray);
    }

    private final Ranking rankingForClassName(String fqName2, ClassDescriptor descriptor2, BindingContext bindingContext) {
        Ranking ranking;
        if (DescriptorUtils.isLocal((DeclarationDescriptor)((DeclarationDescriptor)descriptor2))) {
            return Ranking.Companion.getZERO();
        }
        String expectedFqName = this.makeTypeMapper(bindingContext).mapType((ClassifierDescriptor)descriptor2).getClassName();
        if (this.checkClassFqName) {
            ranking = Intrinsics.areEqual((Object)expectedFqName, (Object)fqName2) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getLOW();
        } else {
            Intrinsics.checkNotNull((Object)expectedFqName);
            ranking = Intrinsics.areEqual((Object)FileRankingCalculatorKt.access$simpleName(expectedFqName), (Object)FileRankingCalculatorKt.access$simpleName(fqName2)) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getLOW();
        }
        return ranking;
    }

    private final Ranking rankingForMethod(KtFunction function, Method method) {
        BindingContext bindingContext = this.analyze((KtElement)function);
        Object object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)function);
        CallableMemberDescriptor callableMemberDescriptor = object instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)object : null;
        if (callableMemberDescriptor == null) {
            return Ranking.Companion.getZERO();
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        if (!(function instanceof KtConstructor) && !Intrinsics.areEqual((Object)method.name(), (Object)descriptor2.getName().asString())) {
            return Ranking.Companion.getLOW();
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = method.isConstructor() && function instanceof KtConstructor;
        objectArray[1] = method.isAbstract() && descriptor2.getModality() == Modality.ABSTRACT;
        objectArray[2] = method.isFinal() && descriptor2.getModality() == Modality.FINAL;
        objectArray[3] = method.isVarArgs() && DescriptorUtilsKt.varargParameterPosition((CallableDescriptor)((CallableDescriptor)descriptor2)) >= 0;
        objectArray[4] = this.rankingForVisibility((DeclarationDescriptorWithVisibility)descriptor2, method);
        List<LocalVariable> list2 = SafeUtilKt.safeArguments(method);
        objectArray[5] = descriptor2.getValueParameters().size() == (list2 != null ? list2.size() : 0);
        return this.collect(objectArray);
    }

    private final Ranking rankingForAccessor(KtPropertyAccessor accessor, Method method) {
        String expectedPropertyName;
        String methodName;
        block7: {
            block8: {
                methodName = method.name();
                String string = accessor.getProperty().getName();
                if (string == null) {
                    return Ranking.Companion.getZERO();
                }
                expectedPropertyName = string;
                if (accessor.isSetter()) {
                    Intrinsics.checkNotNull((Object)methodName);
                    if (!StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null) || !(method.returnType() instanceof VoidType) || method.argumentTypes().size() != 1) {
                        return Ranking.Companion.getMAJOR().unaryMinus();
                    }
                }
                if (!accessor.isGetter()) break block7;
                Intrinsics.checkNotNull((Object)methodName);
                if (!StringsKt.startsWith$default((String)methodName, (String)"get", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)methodName, (String)"is", (boolean)false, (int)2, null)) {
                    return Ranking.Companion.getMAJOR().unaryMinus();
                }
                if (method.returnType() instanceof VoidType) break block8;
                List<Type> list2 = method.argumentTypes();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"argumentTypes(...)");
                if (!(!((Collection)list2).isEmpty())) break block7;
            }
            return Ranking.Companion.getNORMAL().unaryMinus();
        }
        Intrinsics.checkNotNull((Object)methodName);
        String actualPropertyName = this.getPropertyName(methodName, accessor.isSetter());
        return Intrinsics.areEqual((Object)expectedPropertyName, (Object)actualPropertyName) ? Ranking.Companion.getNORMAL() : Ranking.Companion.getNORMAL().unaryMinus();
    }

    private final String getPropertyName(String accessorMethodName, boolean isSetter) {
        if (isSetter) {
            return StringsKt.drop((String)accessorMethodName, (int)3);
        }
        return StringsKt.drop((String)accessorMethodName, (int)(StringsKt.startsWith$default((String)accessorMethodName, (String)"is", (boolean)false, (int)2, null) ? 2 : 3));
    }

    private final Ranking rankingForProperty(KtProperty property, Method method) {
        String methodName = method.name();
        String string = property.getName();
        if (string == null) {
            return Ranking.Companion.getZERO();
        }
        String propertyName = string;
        if (property.isTopLevel() && Intrinsics.areEqual((Object)method.name(), (Object)"<clinit>")) {
            return Ranking.Companion.getMINOR();
        }
        Intrinsics.checkNotNull((Object)methodName);
        if (!StringsKt.startsWith$default((String)methodName, (String)"get", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null)) {
            return Ranking.Companion.getMAJOR().unaryMinus();
        }
        return Intrinsics.areEqual((Object)StringsKt.drop((String)methodName, (int)3), (Object)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)propertyName)) ? Ranking.Companion.getMAJOR() : Ranking.Companion.getNORMAL().unaryMinus();
    }

    private final Ranking rankingForVisibility(DeclarationDescriptorWithVisibility descriptor2, Accessible accessible) {
        Object[] objectArray = new Object[]{accessible.isPublic() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PUBLIC), accessible.isProtected() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PROTECTED), accessible.isPrivate() && Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)};
        return this.collect(objectArray);
    }

    private final Ranking fileRankingSafe(KtFile file, Location location) {
        Ranking ranking;
        try {
            ranking = this.fileRanking(file, location);
        }
        catch (ClassNotLoadedException e) {
            LOG.error("ClassNotLoadedException should never happen in FileRankingCalculator", (Throwable)e);
            ranking = Ranking.Companion.getZERO();
        }
        catch (AbsentInformationException e) {
            ranking = Ranking.Companion.getZERO();
        }
        catch (InternalException e) {
            ranking = Ranking.Companion.getZERO();
        }
        catch (VMDisconnectedException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("Exception during Kotlin sources ranking", (Throwable)e);
            ranking = Ranking.Companion.getZERO();
        }
        return ranking;
    }

    /*
     * WARNING - void declaration
     */
    private final Ranking fileRanking(KtFile file, Location location) {
        Ranking overallRanking;
        block40: {
            Ranking ranking;
            Method method;
            PsiElement elementAt;
            block37: {
                PsiElement constructorOrInitializer;
                Object object;
                KtClassOrObject containingClass;
                int locationLineNumber;
                block39: {
                    Object object2;
                    block38: {
                        void $this$getParentOfType$iv;
                        locationLineNumber = location.lineNumber() - 1;
                        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, locationLineNumber);
                        if (n == null) {
                            return Ranking.Companion.getLOW();
                        }
                        int lineStartOffset = n;
                        PsiElement psiElement = file.findElementAt(lineStartOffset);
                        if (psiElement == null) {
                            return Ranking.Companion.getZERO();
                        }
                        elementAt = psiElement;
                        overallRanking = Ranking.Companion.getZERO();
                        method = location.method();
                        Intrinsics.checkNotNull((Object)method);
                        if (this.isIndyLambda(method) || this.isAnonymousClassLambda(method)) {
                            void $this$getParentOfType$iv2;
                            NavigatablePsiElement navigatablePsiElement;
                            Pair<String, String> pair = this.getContainingClassAndMethodNameForLambda(method);
                            if (pair == null) {
                                return Ranking.Companion.getZERO();
                            }
                            Pair<String, String> pair2 = pair;
                            String className = (String)pair2.component1();
                            String methodName = (String)pair2.component2();
                            if (method.isBridge() && method.isSynthetic()) {
                                void $this$getParentOfType$iv3;
                                PsiElement psiElement2 = elementAt;
                                boolean strict$iv = false;
                                boolean $i$f$getParentOfType = false;
                                KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv3, KtClassOrObject.class, (boolean)strict$iv);
                                if (ktClassOrObject == null) {
                                    return Ranking.Companion.getLOW();
                                }
                                KtClassOrObject containingClass2 = ktClassOrObject;
                                VirtualMachine virtualMachine = location.virtualMachine();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
                                return this.rankingForClass(containingClass2, className, virtualMachine);
                            }
                            KtFunctionLiteral ktFunctionLiteral = this.findFunctionLiteralOnLine(elementAt);
                            if (ktFunctionLiteral != null) {
                                navigatablePsiElement = (NavigatablePsiElement)ktFunctionLiteral;
                            } else {
                                KtNamedFunction ktNamedFunction = this.findAnonymousFunctionInParent(elementAt);
                                if (ktNamedFunction != null) {
                                    navigatablePsiElement = (NavigatablePsiElement)ktNamedFunction;
                                } else {
                                    return Ranking.Companion.getLOW();
                                }
                            }
                            NavigatablePsiElement containingFunctionLiteral = navigatablePsiElement;
                            PsiElement psiElement3 = this.findNonLocalCallableParent((PsiElement)containingFunctionLiteral);
                            if (psiElement3 == null) {
                                return Ranking.Companion.getLOW();
                            }
                            PsiElement containingCallable = psiElement3;
                            PsiElement $this$getParentOfType$iv3 = containingCallable;
                            if ($this$getParentOfType$iv3 instanceof KtFunction) {
                                if (Intrinsics.areEqual((Object)((KtFunction)containingCallable).getName(), (Object)methodName)) {
                                    overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                                }
                            } else if ($this$getParentOfType$iv3 instanceof KtProperty) {
                                if (Intrinsics.areEqual((Object)((KtProperty)containingCallable).getName(), (Object)methodName)) {
                                    overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                                }
                            } else if ($this$getParentOfType$iv3 instanceof KtPropertyAccessor && Intrinsics.areEqual((Object)((KtPropertyAccessor)containingCallable).getProperty().getName(), (Object)methodName)) {
                                overallRanking = overallRanking.plus(Ranking.Companion.getMAJOR());
                            }
                            PsiElement strict$iv = containingCallable;
                            boolean strict$iv2 = false;
                            boolean $i$f$getParentOfType = false;
                            KtClassOrObject containingClass3 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv2, KtClassOrObject.class, (boolean)strict$iv2);
                            if (containingClass3 != null) {
                                VirtualMachine virtualMachine = location.virtualMachine();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
                                overallRanking = overallRanking.plus(this.rankingForClass(containingClass3, className, virtualMachine));
                            }
                            return overallRanking;
                        }
                        if (!Intrinsics.areEqual((Object)method.name(), (Object)"<init>")) break block37;
                        PsiElement methodName = elementAt;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv);
                        if (ktClassOrObject == null) {
                            return Ranking.Companion.getLOW();
                        }
                        containingClass = ktClassOrObject;
                        PsiElement $this$getParentOfTypes2$iv = elementAt;
                        boolean $i$f$getParentOfTypes2 = false;
                        Class[] containingClass3 = new Class[]{KtConstructor.class, KtClassInitializer.class};
                        object = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes2$iv, (Class[])containingClass3);
                        if (object == null) break block38;
                        PsiElement it = $i$f$getParentOfTypes2 = object;
                        boolean bl = false;
                        object = PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)containingClass), (PsiElement)it, (boolean)false, (int)2, null) ? $i$f$getParentOfTypes2 : null;
                        if (object != null) break block39;
                    }
                    KtPrimaryConstructor ktPrimaryConstructor = containingClass.getPrimaryConstructor();
                    if (ktPrimaryConstructor != null) {
                        KtPrimaryConstructor ktPrimaryConstructor2;
                        KtPrimaryConstructor it = ktPrimaryConstructor2 = ktPrimaryConstructor;
                        boolean bl = false;
                        object2 = FileRankingCalculatorKt.access$getLine((PsiElement)it) == FileRankingCalculatorKt.access$getLine((PsiElement)containingClass) ? ktPrimaryConstructor2 : null;
                    } else {
                        object2 = null;
                    }
                    object = (PsiElement)object2;
                }
                if ((constructorOrInitializer = object) == null && locationLineNumber < FileRankingCalculatorKt.access$getLine((PsiElement)containingClass)) {
                    PsiElement psiElement = containingClass.getLastChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getLastChild(...)");
                    if (locationLineNumber > FileRankingCalculatorKt.access$getLine(psiElement)) {
                        return Ranking.Companion.getLOW();
                    }
                }
                ReferenceType referenceType = location.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
                overallRanking = overallRanking.plus(this.rankingForClass(containingClass, referenceType));
                if (constructorOrInitializer instanceof KtConstructor) {
                    overallRanking = overallRanking.plus(this.rankingForMethod((KtFunction)constructorOrInitializer, method));
                }
                break block40;
            }
            PsiElement psiElement = this.findNonLocalCallableParent(elementAt);
            if (psiElement == null) {
                return Ranking.Companion.getLOW();
            }
            PsiElement callable = psiElement;
            PsiElement constructorOrInitializer = callable;
            if (constructorOrInitializer instanceof KtFunction) {
                ranking = this.rankingForMethod((KtFunction)callable, method);
            } else if (constructorOrInitializer instanceof KtPropertyAccessor) {
                ranking = this.rankingForAccessor((KtPropertyAccessor)callable, method);
            } else if (constructorOrInitializer instanceof KtProperty) {
                ranking = this.rankingForProperty((KtProperty)callable, method);
            } else {
                return Ranking.Companion.getLOW();
            }
            overallRanking = overallRanking.plus(ranking);
            PsiElement $this$getParentOfType$iv = elementAt;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtClassOrObject containingClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, (boolean)strict$iv);
            if (containingClass != null) {
                ReferenceType referenceType = location.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
                overallRanking = overallRanking.plus(this.rankingForClass(containingClass, referenceType));
            }
        }
        return overallRanking;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunctionLiteral findFunctionLiteralOnLine(PsiElement element) {
        void $this$getParentOfType$iv;
        void $this$getParentOfType$iv2;
        PsiElement psiElement = element;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType22 = false;
        KtFunctionLiteral literal = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv2, KtFunctionLiteral.class, (boolean)strict$iv);
        if (literal != null) {
            return literal;
        }
        PsiElement $i$f$getParentOfType22 = element;
        boolean strict$iv2 = false;
        boolean $i$f$getParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtCallExpression.class, (boolean)strict$iv2);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        for (KtLambdaArgument lambdaArgument : callExpression.getLambdaArguments()) {
            int n = FileRankingCalculatorKt.access$getLine(element);
            Intrinsics.checkNotNull((Object)lambdaArgument);
            if (n != FileRankingCalculatorKt.access$getLine((PsiElement)lambdaArgument)) continue;
            KtLambdaExpression ktLambdaExpression = lambdaArgument.getLambdaExpression();
            Object functionLiteral = ktLambdaExpression != null ? ktLambdaExpression.getFunctionLiteral() : null;
            if (functionLiteral == null) continue;
            return functionLiteral;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction findAnonymousFunctionInParent(PsiElement element) {
        void $this$getParentOfType$iv;
        PsiElement psiElement = element;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        KtNamedFunction parentFun = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedFunction.class, (boolean)strict$iv);
        if (parentFun != null && KtPsiUtilKt.isFunctionalExpression((PsiElement)((PsiElement)parentFun))) {
            return parentFun;
        }
        return null;
    }

    private final PsiElement findNonLocalCallableParent(PsiElement element) {
        PsiElement containingCallable;
        FileRankingCalculator fileRankingCalculator = this;
        while (true) {
            if (FileRankingCalculator.findNonLocalCallableParent$isCallableDeclaration(element) && !FileRankingCalculator.findNonLocalCallableParent$isLocalDeclaration(element)) {
                return element;
            }
            PsiElement $this$getParentOfTypes3$iv = element;
            boolean $i$f$getParentOfTypes3 = false;
            Class[] classArray = new Class[]{KtProperty.class, KtFunction.class, KtAnonymousInitializer.class};
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes3$iv, (Class[])classArray) == null) {
                return null;
            }
            if (!FileRankingCalculator.findNonLocalCallableParent$isLocalDeclaration(containingCallable)) break;
            element = containingCallable;
        }
        return containingCallable;
    }

    private final Pair<String, String> getContainingClassAndMethodNameForLambda(Method $this$getContainingClassAndMethodNameForLambda) {
        if (this.isIndyLambda($this$getContainingClassAndMethodNameForLambda)) {
            return this.getContainingClassAndMethodNameForIndyLambda($this$getContainingClassAndMethodNameForLambda);
        }
        ReferenceType referenceType = $this$getContainingClassAndMethodNameForLambda.declaringType();
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
        ClassType declaringClass = (ClassType)referenceType;
        String string = declaringClass.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        Object object = new char[]{'$'};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)3, (int)2, null);
        boolean bl = false;
        Object object2 = it.size() == 3 ? object : null;
        if (object2 == null) {
            return null;
        }
        Object object3 = object2;
        String className = (String)object3.get(0);
        String methodName = (String)object3.get(1);
        return new Pair((Object)className, (Object)methodName);
    }

    private final boolean isAnonymousClassLambda(Method $this$isAnonymousClassLambda) {
        ReferenceType referenceType = $this$isAnonymousClassLambda.declaringType();
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            return false;
        }
        ClassType declaringClass = classType;
        ClassType classType2 = declaringClass.superclass();
        return classType2 != null ? FileRankingCalculator.isAnonymousClassLambda$isLambdaClass(classType2) : false;
    }

    private final boolean isIndyLambda(Method $this$isIndyLambda) {
        String string = $this$isIndyLambda.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        CharSequence charSequence = string;
        return INDY_LAMBDA_NAME_REGEX.matches(charSequence);
    }

    private final Pair<String, String> getContainingClassAndMethodNameForIndyLambda(Method $this$getContainingClassAndMethodNameForIndyLambda) {
        String string = $this$getContainingClassAndMethodNameForIndyLambda.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        MatchResult matchResult = INDY_LAMBDA_NAME_REGEX.matchEntire((CharSequence)string);
        if (matchResult == null) {
            return null;
        }
        MatchResult match2 = matchResult;
        List values2 = match2.getGroupValues();
        if (values2.size() != 2) {
            return null;
        }
        String methodName = (String)values2.get(1);
        String className = $this$getContainingClassAndMethodNameForIndyLambda.declaringType().name();
        return TuplesKt.to((Object)className, (Object)methodName);
    }

    private final KotlinTypeMapper makeTypeMapper(BindingContext bindingContext) {
        ClassBuilderMode classBuilderMode = ClassBuilderMode.LIGHT_CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)classBuilderMode, (String)"LIGHT_CLASSES");
        return new KotlinTypeMapper(bindingContext, classBuilderMode, "debugger", KotlinTypeMapper.Companion.getLANGUAGE_VERSION_SETTINGS_DEFAULT(), false, null, false, null, null, 480, null);
    }

    private static final Map chooseMostApplicableFile$lambda$1$lambda$0(FileRankingCalculator this$0, List $files, Location $location) {
        return this$0.rankFiles($files, $location);
    }

    private static final Map chooseMostApplicableFile$lambda$1(FileRankingCalculator this$0, List $files, Location $location) {
        return (Map)ActionsKt.runReadAction(() -> FileRankingCalculator.chooseMostApplicableFile$lambda$1$lambda$0(this$0, $files, $location));
    }

    private static final int rankFiles$lambda$3(FileRankingCalculator this$0, Location $location, KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.fileRankingSafe(it, $location).getValue();
    }

    private static final boolean findNonLocalCallableParent$isCallableDeclaration(PsiElement $this$findNonLocalCallableParent_u24isCallableDeclaration) {
        return $this$findNonLocalCallableParent_u24isCallableDeclaration instanceof KtProperty || $this$findNonLocalCallableParent_u24isCallableDeclaration instanceof KtFunction || $this$findNonLocalCallableParent_u24isCallableDeclaration instanceof KtAnonymousInitializer;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean findNonLocalCallableParent$isLocalDeclaration(PsiElement $this$findNonLocalCallableParent_u24isLocalDeclaration) {
        void $this$getParentOfType$iv;
        PsiElement psiElement = $this$findNonLocalCallableParent_u24isLocalDeclaration;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtDeclaration containingDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv);
        return containingDeclaration instanceof KtCallableDeclaration || containingDeclaration instanceof KtPropertyAccessor;
    }

    private static final boolean isAnonymousClassLambda$isLambdaClass(ClassType $this$isAnonymousClassLambda_u24isLambdaClass) {
        while (true) {
            ClassType superClass;
            boolean bl;
            block6: {
                List<InterfaceType> list2 = $this$isAnonymousClassLambda_u24isLambdaClass.interfaces();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"interfaces(...)");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        InterfaceType it = (InterfaceType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)FunctionBase.class.getName())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            if ($this$isAnonymousClassLambda_u24isLambdaClass.superclass() == null) {
                return false;
            }
            $this$isAnonymousClassLambda_u24isLambdaClass = superClass;
        }
    }

    public FileRankingCalculator() {
        this(false, 1, null);
    }

    static {
        Logger logger = Logger.getInstance((String)"FileRankingCalculator");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Companion;", "", "<init>", "()V", "INDY_LAMBDA_NAME_REGEX", "Lkotlin/text/Regex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm-debugger.core-fe10"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "", "value", "", "<init>", "(I)V", "getValue", "()I", "unaryMinus", "plus", "other", "compareTo", "toString", "", "Companion", "kotlin.jvm-debugger.core-fe10"})
    private static final class Ranking
    implements Comparable<Ranking> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int value;
        @NotNull
        private static final Ranking LOW = new Ranking(-1000);
        @NotNull
        private static final Ranking ZERO = new Ranking(0);
        @NotNull
        private static final Ranking MINOR = new Ranking(1);
        @NotNull
        private static final Ranking NORMAL = new Ranking(5);
        @NotNull
        private static final Ranking MAJOR = new Ranking(10);

        public Ranking(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        @NotNull
        public final Ranking unaryMinus() {
            return new Ranking(-this.value);
        }

        @NotNull
        public final Ranking plus(@NotNull Ranking other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new Ranking(this.value + other.value);
        }

        @Override
        public int compareTo(@NotNull Ranking other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.value - other.value;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking$Companion;", "", "<init>", "()V", "LOW", "Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "getLOW", "()Lorg/jetbrains/kotlin/idea/debugger/FileRankingCalculator$Ranking;", "ZERO", "getZERO", "MINOR", "getMINOR", "NORMAL", "getNORMAL", "MAJOR", "getMAJOR", "minor", "condition", "", "kotlin.jvm-debugger.core-fe10"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Ranking getLOW() {
                return LOW;
            }

            @NotNull
            public final Ranking getZERO() {
                return ZERO;
            }

            @NotNull
            public final Ranking getMINOR() {
                return MINOR;
            }

            @NotNull
            public final Ranking getNORMAL() {
                return NORMAL;
            }

            @NotNull
            public final Ranking getMAJOR() {
                return MAJOR;
            }

            @NotNull
            public final Ranking minor(boolean condition2) {
                return condition2 ? this.getMINOR() : this.getZERO();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

