/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemContentRootContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SingleFileSourcesTracker;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Query;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.core.ExternalContentRootChooser;
import org.jetbrains.kotlin.idea.core.PureKotlinSourceFoldersHolder;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\n\u0010\u000e\u001a\u00020\n*\u00020\u000f\u001a(\u0010\u0010\u001a\u0004\u0018\u00010\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a*\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#*\u00020\u0014H\u0002\u001a\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&*\u00020\u00142\u0006\u0010'\u001a\u00020\u001b\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&*\u00020\u0014\u001a(\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0&*\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u001bH\u0002\u001a4\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0&*\u00020\u00142\u0006\u0010'\u001a\u00020\u001b2\u001a\u0010*\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0&\u0012\u0006\u0012\u0004\u0018\u00010-0+\u001a\u0012\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u00020\u0019H\u0002\u001a\u000e\u00100\u001a\u0004\u0018\u00010-*\u00020\u000bH\u0002\u001a8\u00101\u001a\u0004\u0018\u00010\u000b*\u00020\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u00020$0&2\u001a\u0010*\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0&\u0012\u0006\u0012\u0004\u0018\u00010-0+H\u0002\u001aV\u00103\u001a\u0004\u0018\u00010-*\u00020\u00142\f\u00104\u001a\b\u0012\u0004\u0012\u00020-0&2\u000e\u00105\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010&2\f\u00106\u001a\b\u0012\u0004\u0012\u00020-0&2\u001a\u0010*\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0&\u0012\u0006\u0012\u0004\u0018\u00010-0+H\u0002\u001a\"\u00107\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010&*\u00020\u00142\f\u00104\u001a\b\u0012\u0004\u0012\u00020-0&H\u0002\u001a\u0014\u00108\u001a\n\u0012\u0004\u0012\u00020,\u0018\u000109*\u00020\u0014H\u0002\u001a\u001a\u0010:\u001a\u00020-*\u00020\u00142\f\u0010;\u001a\b\u0012\u0004\u0012\u00020-0&H\u0002\u001a\u0018\u0010<\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019\"\u001a\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006=\u00b2\u0006\u0010\u00106\u001a\b\u0012\u0004\u0012\u00020-0&X\u008a\u0084\u0002"}, d2={"getPackage", "Lcom/intellij/psi/PsiPackage;", "Lcom/intellij/psi/PsiDirectory;", "getNonRootFqNameOrNull", "Lorg/jetbrains/kotlin/name/FqName;", "getFqNameByDirectory", "Lcom/intellij/psi/PsiFile;", "getFqNameWithImplicitPrefix", "getFqNameWithImplicitPrefixOrRoot", "hasExplicitPackagePrefix", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "packageMatchesDirectoryOrImplicit", "Lorg/jetbrains/kotlin/psi/KtFile;", "getWritableModuleDirectory", "vFiles", "Lcom/intellij/util/Query;", "module", "Lcom/intellij/openapi/module/Module;", "manager", "Lcom/intellij/psi/PsiManager;", "findLongestExistingPackage", "packageName", "", "pureKotlinSourceFolders", "Lorg/jetbrains/kotlin/idea/core/PureKotlinSourceFoldersHolder;", "allowedScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "kotlinSourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "Lorg/jetbrains/jps/model/java/JavaSourceRootProperties;", "findNonGeneratedKotlinSourceFolders", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/roots/SourceFolder;", "findExistingNonGeneratedKotlinSourceRootFiles", "", "pureKotlinSourceFoldersHolder", "toExistingFiles", "findOrConfigureKotlinSourceRoots", "contentRootChooser", "Lkotlin/Function1;", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemContentRootContributor$ExternalContentRoot;", "Ljava/nio/file/Path;", "convertUrlToPath", "url", "pathOrNull", "createSourceRootDirectory", "nonGeneratedSourceFolders", "chooseSourceRootPath", "allowedPaths", "sourceFolderPaths", "contentEntryPaths", "findSourceRootPathByExternalProject", "findContentRootsByExternalProject", "", "chooseSourceRootPathHeuristically", "contentEntries", "findOrCreateDirectoryForPackage", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\npackageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 packageUtils.kt\norg/jetbrains/kotlin/idea/core/PackageUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,328:1\n1#2:329\n1#2:345\n1#2:395\n1557#3:330\n1628#3,3:331\n1611#3,9:335\n1863#3:344\n1864#3:346\n1620#3:347\n1755#3,3:348\n774#3:351\n865#3:352\n1755#3,3:353\n866#3:356\n774#3:357\n865#3:358\n2632#3,3:359\n866#3:362\n1557#3:369\n1628#3,3:370\n2669#3,7:373\n1053#3:382\n189#4:334\n621#5,6:363\n37#6,2:380\n37#6,2:383\n11483#7,9:385\n13409#7:394\n13410#7:396\n11492#7:397\n*S KotlinDebug\n*F\n+ 1 packageUtils.kt\norg/jetbrains/kotlin/idea/core/PackageUtilsKt\n*L\n183#1:345\n184#1:395\n68#1:330\n68#1:331,3\n183#1:335,9\n183#1:344\n183#1:346\n183#1:347\n208#1:348,3\n220#1:351\n220#1:352\n221#1:353,3\n220#1:356\n235#1:357\n235#1:358\n235#1:359,3\n235#1:362\n259#1:369\n259#1:370,3\n259#1:373,7\n302#1:382\n172#1:334\n241#1:363,6\n278#1:380,2\n302#1:383,2\n184#1:385,9\n184#1:394\n184#1:396\n184#1:397\n*E\n"})
public final class PackageUtilsKt {
    @NotNull
    private static final Set<JpsModuleSourceRootType<JavaSourceRootProperties>> kotlinSourceRootTypes;

    @Nullable
    public static final PsiPackage getPackage(@NotNull PsiDirectory $this$getPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$getPackage, (String)"<this>");
        JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
        Intrinsics.checkNotNull((Object)javaDirectoryService);
        return javaDirectoryService.getPackage($this$getPackage);
    }

    private static final FqName getNonRootFqNameOrNull(PsiDirectory $this$getNonRootFqNameOrNull) {
        FqName fqName2;
        Object object = PackageUtilsKt.getPackage($this$getNonRootFqNameOrNull);
        if (object != null && (object = object.getQualifiedName()) != null) {
            Object p0 = object;
            boolean $i$f$getNonRootFqNameOrNull$stub_for_inlining = false;
            boolean bl = false;
            fqName2 = new FqName((String)p0);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    @NotNull
    public static final FqName getFqNameByDirectory(@NotNull PsiFile $this$getFqNameByDirectory) {
        String singleFileSourcePackageName;
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameByDirectory, (String)"<this>");
        Project project = $this$getFqNameByDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SingleFileSourcesTracker singleFileSourcesTracker = SingleFileSourcesTracker.Companion.getInstance(project);
        VirtualFile virtualFile = $this$getFqNameByDirectory.getVirtualFile();
        if (virtualFile == null) {
            return FqName.ROOT;
        }
        VirtualFile vFile = virtualFile;
        String string = singleFileSourcePackageName = singleFileSourcesTracker.getPackageNameForSingleFileSource(vFile);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return new FqName(it);
        }
        PsiDirectory psiDirectory = $this$getFqNameByDirectory.getParent();
        if (psiDirectory == null || (psiDirectory = PackageUtilsKt.getNonRootFqNameOrNull(psiDirectory)) == null) {
            psiDirectory = FqName.ROOT;
        }
        return psiDirectory;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName getFqNameWithImplicitPrefix(@NotNull PsiDirectory $this$getFqNameWithImplicitPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithImplicitPrefix, (String)"<this>");
        FqName fqName2 = PackageUtilsKt.getNonRootFqNameOrNull($this$getFqNameWithImplicitPrefix);
        if (fqName2 == null) {
            return null;
        }
        FqName packageFqName = fqName2;
        VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$this$getFqNameWithImplicitPrefix);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile;
            boolean bl = false;
            Project project = $this$getFqNameWithImplicitPrefix.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object object = virtualFile2 = !PackageUtilsKt.hasExplicitPackagePrefix(it, project) ? virtualFile3 : null;
            if (virtualFile2 != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                VirtualFile sourceRoot = virtualFile2;
                boolean bl2 = false;
                Project project2 = $this$getFqNameWithImplicitPrefix.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                FqName implicitPrefix = PerModulePackageCacheService.Companion.getInstance(project2).getImplicitPackagePrefix(sourceRoot);
                Iterable iterable = CollectionsKt.plus((Collection)implicitPrefix.pathSegments(), (Iterable)packageFqName.pathSegments());
                FqName.Companion companion = FqName.Companion;
                boolean $i$f$map = false;
                void var11_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Name name2 = (Name)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it2.asString());
                }
                return companion.fromSegments((List)destination$iv$iv);
            }
        }
        return packageFqName;
    }

    @NotNull
    public static final FqName getFqNameWithImplicitPrefixOrRoot(@NotNull PsiDirectory $this$getFqNameWithImplicitPrefixOrRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithImplicitPrefixOrRoot, (String)"<this>");
        FqName fqName2 = PackageUtilsKt.getFqNameWithImplicitPrefix($this$getFqNameWithImplicitPrefixOrRoot);
        if (fqName2 == null) {
            fqName2 = FqName.ROOT;
        }
        return fqName2;
    }

    private static final boolean hasExplicitPackagePrefix(VirtualFile $this$hasExplicitPackagePrefix, Project project) {
        Object object = PhysicalFileSystemUtilsKt.toPsiDirectory($this$hasExplicitPackagePrefix, project);
        return object != null && (object = PackageUtilsKt.getPackage(object)) != null && (object = object.getQualifiedName()) != null ? ((CharSequence)object).length() > 0 : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean packageMatchesDirectoryOrImplicit(@NotNull KtFile $this$packageMatchesDirectoryOrImplicit) {
        Intrinsics.checkNotNullParameter((Object)$this$packageMatchesDirectoryOrImplicit, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$packageMatchesDirectoryOrImplicit.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$this$packageMatchesDirectoryOrImplicit))) return true;
        PsiDirectory psiDirectory = $this$packageMatchesDirectoryOrImplicit.getParent();
        if (!Intrinsics.areEqual((Object)$this$packageMatchesDirectoryOrImplicit.getPackageFqName(), (Object)(psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null))) return false;
        return true;
    }

    private static final PsiDirectory getWritableModuleDirectory(Query<VirtualFile> vFiles2, Module module, PsiManager manager) {
        Iterator iterator2 = vFiles2.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            PsiDirectory directory;
            VirtualFile vFile = (VirtualFile)iterator3.next();
            if (ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)module.getProject()) != module || (directory = manager.findDirectory(vFile)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    private static final PsiPackage findLongestExistingPackage(Module module, String packageName, PureKotlinSourceFoldersHolder pureKotlinSourceFolders, GlobalSearchScope allowedScope) {
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        String nameToMatch = packageName;
        while (true) {
            int lastDotIndex;
            Query vFiles2;
            Intrinsics.checkNotNullExpressionValue((Object)ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(nameToMatch, false).filtering(arg_0 -> PackageUtilsKt.findLongestExistingPackage$lambda$4((Function1)new Function1<VirtualFile, Boolean>((Object)allowedScope){

                public final Boolean invoke(VirtualFile p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((GlobalSearchScope)this.receiver).contains(p0);
                }
            }, arg_0)), (String)"filtering(...)");
            PsiDirectory directory = PackageUtilsKt.getWritableModuleDirectory((Query<VirtualFile>)vFiles2, module, manager);
            if (directory != null) {
                String string = directory.getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (pureKotlinSourceFolders.hasPurePrefixInPath(module, string)) {
                    return PackageUtilsKt.getPackage(directory);
                }
            }
            if ((lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)nameToMatch, (char)'.', (int)0, (boolean)false, (int)6, null)) < 0) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)nameToMatch.substring(0, lastDotIndex), (String)"substring(...)");
        }
    }

    private static final Sequence<SourceFolder> findNonGeneratedKotlinSourceFolders(Module $this$findNonGeneratedKotlinSourceFolders) {
        ContentEntry[] contentEntryArray = ModuleRootManager.getInstance((Module)$this$findNonGeneratedKotlinSourceFolders).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        return SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])contentEntryArray), PackageUtilsKt::findNonGeneratedKotlinSourceFolders$lambda$5), PackageUtilsKt::findNonGeneratedKotlinSourceFolders$lambda$6);
    }

    @NotNull
    public static final List<VirtualFile> findExistingNonGeneratedKotlinSourceRootFiles(@NotNull Module $this$findExistingNonGeneratedKotlinSourceRootFiles, @NotNull PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder) {
        Intrinsics.checkNotNullParameter((Object)$this$findExistingNonGeneratedKotlinSourceRootFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pureKotlinSourceFoldersHolder, (String)"pureKotlinSourceFoldersHolder");
        Sequence<SourceFolder> sequence = PackageUtilsKt.findNonGeneratedKotlinSourceFolders($this$findExistingNonGeneratedKotlinSourceRootFiles);
        Project project = $this$findExistingNonGeneratedKotlinSourceRootFiles.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return PackageUtilsKt.toExistingFiles(sequence, project, pureKotlinSourceFoldersHolder);
    }

    @NotNull
    public static final List<VirtualFile> findExistingNonGeneratedKotlinSourceRootFiles(@NotNull Module $this$findExistingNonGeneratedKotlinSourceRootFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$findExistingNonGeneratedKotlinSourceRootFiles, (String)"<this>");
        return PackageUtilsKt.findExistingNonGeneratedKotlinSourceRootFiles($this$findExistingNonGeneratedKotlinSourceRootFiles, new PureKotlinSourceFoldersHolder());
    }

    private static final List<VirtualFile> toExistingFiles(Sequence<? extends SourceFolder> $this$toExistingFiles, Project project, PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull($this$toExistingFiles, arg_0 -> PackageUtilsKt.toExistingFiles$lambda$8(pureKotlinSourceFoldersHolder, project, arg_0)));
    }

    @NotNull
    public static final List<VirtualFile> findOrConfigureKotlinSourceRoots(@NotNull Module $this$findOrConfigureKotlinSourceRoots, @NotNull PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder, @NotNull Function1<? super List<ExternalSystemContentRootContributor.ExternalContentRoot>, ? extends Path> contentRootChooser) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrConfigureKotlinSourceRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pureKotlinSourceFoldersHolder, (String)"pureKotlinSourceFoldersHolder");
        Intrinsics.checkNotNullParameter(contentRootChooser, (String)"contentRootChooser");
        List nonGeneratedSourceFolders = SequencesKt.toList(PackageUtilsKt.findNonGeneratedKotlinSourceFolders($this$findOrConfigureKotlinSourceRoots));
        Sequence sequence = CollectionsKt.asSequence((Iterable)nonGeneratedSourceFolders);
        Project project = $this$findOrConfigureKotlinSourceRoots.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Collection $this$ifNotEmpty$iv = PackageUtilsKt.toExistingFiles((Sequence<? extends SourceFolder>)sequence, project, pureKotlinSourceFoldersHolder);
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$findOrConfigureKotlinSourceRoots_u24lambda_u249 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            return $this$findOrConfigureKotlinSourceRoots_u24lambda_u249;
        }
        return CollectionsKt.listOfNotNull((Object)PackageUtilsKt.createSourceRootDirectory($this$findOrConfigureKotlinSourceRoots, nonGeneratedSourceFolders, contentRootChooser));
    }

    private static final Path convertUrlToPath(String url) {
        Path path2;
        Object object = VfsUtilCore.convertToURL((String)url);
        if (object != null && (object = ((URL)object).getPath()) != null) {
            Object p0 = object;
            boolean $i$f$convertUrlToPath$stub_for_inlining$10 = false;
            boolean bl = false;
            Path path3 = Paths.get((String)p0, new String[0]);
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else {
            path2 = null;
        }
        return path2;
    }

    private static final Path pathOrNull(VirtualFile $this$pathOrNull) {
        return $this$pathOrNull.getFileSystem().getNioPath($this$pathOrNull);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile createSourceRootDirectory(Module $this$createSourceRootDirectory, List<? extends SourceFolder> nonGeneratedSourceFolders, Function1<? super List<ExternalSystemContentRootContributor.ExternalContentRoot>, ? extends Path> contentRootChooser) {
        Iterable iterable;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = nonGeneratedSourceFolders;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SourceFolder it = (SourceFolder)element$iv$iv;
            boolean bl2 = false;
            String string = it.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            if (PackageUtilsKt.convertUrlToPath(string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            boolean bl = false;
            iterable = null;
        } else {
            iterable = $this$mapNotNull$iv;
        }
        List<Path> sourceFolderPaths = (List<Path>)iterable;
        Lazy contentEntryPaths$delegate = LazyKt.lazy(() -> PackageUtilsKt.createSourceRootDirectory$lambda$14($this$createSourceRootDirectory));
        List<Path> list2 = sourceFolderPaths;
        if (list2 == null) {
            list2 = PackageUtilsKt.createSourceRootDirectory$lambda$15((Lazy<? extends List<? extends Path>>)contentEntryPaths$delegate);
        }
        List<Path> allowedPaths = list2;
        Path path2 = PackageUtilsKt.chooseSourceRootPath($this$createSourceRootDirectory, allowedPaths, sourceFolderPaths, PackageUtilsKt.createSourceRootDirectory$lambda$15((Lazy<? extends List<? extends Path>>)contentEntryPaths$delegate), contentRootChooser);
        if (path2 == null) {
            return null;
        }
        Path srcFolderPath = path2;
        ActionsKt.runWriteAction(() -> PackageUtilsKt.createSourceRootDirectory$lambda$16(srcFolderPath, $this$createSourceRootDirectory));
        return VfsUtil.findFile((Path)srcFolderPath, (boolean)true);
    }

    private static final Path chooseSourceRootPath(Module $this$chooseSourceRootPath, List<? extends Path> allowedPaths, List<? extends Path> sourceFolderPaths, List<? extends Path> contentEntryPaths, Function1<? super List<ExternalSystemContentRootContributor.ExternalContentRoot>, ? extends Path> contentRootChooser) {
        List<ExternalSystemContentRootContributor.ExternalContentRoot> externalContentRoots = PackageUtilsKt.findSourceRootPathByExternalProject($this$chooseSourceRootPath, allowedPaths);
        Collection collection = externalContentRoots;
        if (!(collection == null || collection.isEmpty())) {
            collection = (ExternalSystemContentRootContributor.ExternalContentRoot)CollectionsKt.singleOrNull(externalContentRoots);
            if (collection != null) {
                Collection it = collection;
                boolean bl = false;
                return it.getPath();
            }
            if (externalContentRoots.size() == 2) {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = externalContentRoots;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ExternalSystemContentRootContributor.ExternalContentRoot it = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it.getPath()), (Object)"java")) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl && JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform($this$chooseSourceRootPath))) {
                    Object v1;
                    Object it;
                    block11: {
                        Object element$iv;
                        it = externalContentRoots;
                        element$iv = it.iterator();
                        while (element$iv.hasNext()) {
                            Object e = element$iv.next();
                            ExternalSystemContentRootContributor.ExternalContentRoot it2 = (ExternalSystemContentRootContributor.ExternalContentRoot)e;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it2.getPath()), (Object)"kotlin")) continue;
                            v1 = e;
                            break block11;
                        }
                        v1 = null;
                    }
                    collection = v1;
                    if (collection != null) {
                        it = collection;
                        boolean bl4 = false;
                        return it.getPath();
                    }
                }
            }
            return (Path)contentRootChooser.invoke(externalContentRoots);
        }
        Iterable<Path> iterable = sourceFolderPaths;
        if (iterable == null || (iterable = (Path)CollectionsKt.singleOrNull(iterable)) == null) {
            iterable = PackageUtilsKt.chooseSourceRootPathHeuristically($this$chooseSourceRootPath, contentEntryPaths);
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ExternalSystemContentRootContributor.ExternalContentRoot> findSourceRootPathByExternalProject(Module $this$findSourceRootPathByExternalProject, List<? extends Path> allowedPaths) {
        List list2;
        Collection<ExternalSystemContentRootContributor.ExternalContentRoot> collection = PackageUtilsKt.findContentRootsByExternalProject($this$findSourceRootPathByExternalProject);
        if (collection != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block6: {
                    ExternalSystemContentRootContributor.ExternalContentRoot externalContentRoot = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = allowedPaths;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Path it = (Path)element$iv;
                            boolean bl3 = false;
                            if (!externalContentRoot.getPath().startsWith(it)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<ExternalSystemContentRootContributor.ExternalContentRoot> findContentRootsByExternalProject(Module $this$findContentRootsByExternalProject) {
        void $this$filterTo$iv$iv;
        List list2;
        KotlinSourceRootType kotlinSourceRootType;
        Object object;
        KotlinSourceRootType kotlinSourceRootType2 = KotlinFacetUtils.getKotlinSourceRootType($this$findContentRootsByExternalProject);
        if (kotlinSourceRootType2 != null) {
            object = kotlinSourceRootType2;
            KotlinSourceRootType it = object;
            boolean bl = false;
            v1 = !ProjectStructureUtils.isAndroidModule$default($this$findContentRootsByExternalProject, null, 1, null) ? object : null;
        } else {
            v1 = kotlinSourceRootType = null;
        }
        if (Intrinsics.areEqual(kotlinSourceRootType, (Object)SourceKotlinRootType.INSTANCE)) {
            list2 = CollectionsKt.listOf((Object)ExternalSystemSourceType.SOURCE);
        } else if (Intrinsics.areEqual(kotlinSourceRootType, (Object)TestSourceKotlinRootType.INSTANCE)) {
            list2 = CollectionsKt.listOf((Object)ExternalSystemSourceType.TEST);
        } else if (kotlinSourceRootType == null) {
            Object[] objectArray = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.TEST};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List sourceRootTypes = list2;
        Collection collection = ExternalSystemApiUtil.getExternalProjectContentRoots((Module)$this$findContentRootsByExternalProject, (Collection)sourceRootTypes);
        if (collection == null) {
            return null;
        }
        Collection externalContentRoots = collection;
        Collection excludedPaths = ExternalSystemApiUtil.getExternalProjectContentRoots((Module)$this$findContentRootsByExternalProject, (ExternalSystemSourceType)ExternalSystemSourceType.EXCLUDED);
        object = excludedPaths;
        if (object == null || object.isEmpty()) {
            return externalContentRoots;
        }
        Iterable $this$filter$iv = externalContentRoots;
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl2;
            block14: {
                ExternalSystemContentRootContributor.ExternalContentRoot contentRoot = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$none$iv = excludedPaths;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ExternalSystemContentRootContributor.ExternalContentRoot it = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv;
                        boolean bl4 = false;
                        if (!contentRoot.getPath().startsWith(it.getPath())) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Path chooseSourceRootPathHeuristically(Module $this$chooseSourceRootPathHeuristically, List<? extends Path> contentEntries) {
        Path path2;
        Object v3;
        block4: {
            String string;
            block3: {
                String string2 = $this$chooseSourceRootPathHeuristically.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String $this$takeLastWhile$iv = string2;
                boolean $i$f$takeLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it = $this$takeLastWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it != '.') continue;
                    String string3 = $this$takeLastWhile$iv;
                    int n = index$iv + 1;
                    String string4 = string3.substring(n);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    break block3;
                }
                string = $this$takeLastWhile$iv;
            }
            String moduleName = string;
            Iterable iterable = contentEntries;
            for (Object t : iterable) {
                Path it = (Path)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)moduleName)) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        if ((path2 = (Path)v3) == null && (path2 = (Path)CollectionsKt.firstOrNull(contentEntries)) == null) {
            throw new KotlinExceptionWithAttachments("Content entry path is not found").withAttachment("module", (Object)$this$chooseSourceRootPathHeuristically.getName());
        }
        Path sourceRootPath = path2;
        Path path3 = sourceRootPath.resolve("kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        return path3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiDirectory findOrCreateDirectoryForPackage(@NotNull Module module, @NotNull String packageName) {
        PsiDirectory psiDirectory;
        List<VirtualFile> sourcePaths;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder = new PureKotlinSourceFoldersHolder();
        PsiDirectory existingDirectoryByPackage = null;
        String restOfName = packageName;
        if (((CharSequence)packageName).length() > 0 && !((Collection)(sourcePaths = PackageUtilsKt.findExistingNonGeneratedKotlinSourceRootFiles(module, pureKotlinSourceFoldersHolder))).isEmpty()) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourcePaths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GlobalSearchScopesCore.DirectoryScope(project2, (VirtualFile)it, true));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv2 = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                SearchScope $i$f$mapTo2 = (SearchScope)iterator$iv.next();
                GlobalSearchScope p0 = (GlobalSearchScope)accumulator$iv2;
                boolean $i$f$findOrCreateDirectoryForPackage$stub_for_inlining$29 = false;
                boolean bl = false;
                accumulator$iv2 = p0.union((SearchScope)p1);
            }
            Object t = accumulator$iv2;
            Intrinsics.checkNotNullExpressionValue(t, (String)"reduce(...)");
            GlobalSearchScope allowedScope = (GlobalSearchScope)t;
            PsiPackage rootPackage = PackageUtilsKt.findLongestExistingPackage(module, packageName, pureKotlinSourceFoldersHolder, allowedScope);
            if (rootPackage != null) {
                String string;
                int beginIndex = rootPackage.getQualifiedName().length() + 1;
                if (beginIndex < packageName.length()) {
                    String string2 = packageName.substring(beginIndex);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = "";
                }
                String subPackageName = string;
                Object postfixToShow = StringsKt.replace$default((String)subPackageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
                if (((CharSequence)subPackageName).length() > 0) {
                    char accumulator$iv2 = File.separatorChar;
                    postfixToShow = accumulator$iv2 + (String)postfixToShow;
                }
                PsiDirectory[] psiDirectoryArray = rootPackage.getDirectories(allowedScope);
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                PsiDirectory[] moduleDirectories = psiDirectoryArray;
                List result2 = new ArrayList();
                for (PsiDirectory directory : moduleDirectories) {
                    VirtualFile virtualFile = directory.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    if (!pureKotlinSourceFoldersHolder.hasPurePrefixInVirtualFile(project2, virtualFile)) continue;
                    ((Collection)result2).add(directory);
                }
                Collection $this$toTypedArray$iv = result2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PsiDirectory psiDirectory2 = DirectoryChooserUtil.selectDirectory((Project)project2, (PsiDirectory[])thisCollection$iv.toArray(new PsiDirectory[0]), null, (String)postfixToShow);
                if (psiDirectory2 == null) {
                    return null;
                }
                existingDirectoryByPackage = psiDirectory2;
                restOfName = subPackageName;
            }
        }
        if ((psiDirectory = existingDirectoryByPackage) == null) {
            void $this$toTypedArray$iv;
            boolean bl = false;
            List<VirtualFile> sourceRoots = PackageUtilsKt.findOrConfigureKotlinSourceRoots(module, pureKotlinSourceFoldersHolder, (Function1<? super List<ExternalSystemContentRootContributor.ExternalContentRoot>, ? extends Path>)((Function1)arg_0 -> PackageUtilsKt.findOrCreateDirectoryForPackage$lambda$32$lambda$30(project2, arg_0)));
            if (sourceRoots.isEmpty()) {
                return null;
            }
            List directoryList = new ArrayList();
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory;
                if (PsiManager.getInstance((Project)project2).findDirectory(sourceRoot) == null) continue;
                ((Collection)directoryList).add(directory);
            }
            Iterable $this$sortedBy$iv = directoryList;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PsiDirectory it = (PsiDirectory)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (PsiDirectory)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            PsiDirectory[] sourceDirectories = thisCollection$iv.toArray(new PsiDirectory[0]);
            char c = File.separatorChar;
            String string = StringsKt.replace$default((String)packageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
            psiDirectory = DirectoryChooserUtil.selectDirectory((Project)project2, (PsiDirectory[])sourceDirectories, null, (String)(c + (String)string));
            if (psiDirectory == null) {
                return null;
            }
        }
        PsiDirectory existingDirectory = psiDirectory;
        Ref.ObjectRef psiDirectory3 = new Ref.ObjectRef();
        psiDirectory3.element = existingDirectory;
        while (((CharSequence)restOfName).length() > 0) {
            String name2 = PackageUtilsKt.findOrCreateDirectoryForPackage$getLeftPart(restOfName);
            PsiDirectory foundExistingDirectory = ((PsiDirectory)psiDirectory3.element).findSubdirectory(name2);
            PsiDirectory psiDirectory4 = foundExistingDirectory;
            if (psiDirectory4 == null) {
                Object object = WriteAction.compute(() -> PackageUtilsKt.findOrCreateDirectoryForPackage$lambda$33(psiDirectory3, name2));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                psiDirectory4 = (PsiDirectory)object;
            }
            psiDirectory3.element = psiDirectory4;
            restOfName = PackageUtilsKt.findOrCreateDirectoryForPackage$cutLeftPart(restOfName);
        }
        return (PsiDirectory)psiDirectory3.element;
    }

    private static final boolean findLongestExistingPackage$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Sequence findNonGeneratedKotlinSourceFolders$lambda$5(ContentEntry it) {
        List list2 = it.getSourceFolders(kotlinSourceRootTypes);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSourceFolders(...)");
        return CollectionsKt.asSequence((Iterable)list2);
    }

    private static final boolean findNonGeneratedKotlinSourceFolders$lambda$6(SourceFolder it) {
        JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)it.getJpsElement().getProperties(kotlinSourceRootTypes);
        return !(javaSourceRootProperties != null ? javaSourceRootProperties.isForGeneratedSources() : false);
    }

    private static final VirtualFile toExistingFiles$lambda$8(PureKotlinSourceFoldersHolder $pureKotlinSourceFoldersHolder, Project $project, SourceFolder sourceFolder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        VirtualFile virtualFile = sourceFolder.getFile();
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = $pureKotlinSourceFoldersHolder.hasPurePrefixInVirtualFile($project, it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List createSourceRootDirectory$lambda$14(Module $this_createSourceRootDirectory) {
        void $this$mapNotNullTo$iv$iv;
        ContentEntry[] contentEntryArray = ProjectUtil.getRootManager((Module)$this_createSourceRootDirectory).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        Object[] $this$mapNotNull$iv = contentEntryArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            ContentEntry it = (ContentEntry)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getFile();
            if (object == null || (object = PackageUtilsKt.pathOrNull(object)) == null) {
                String string = it.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                object = PackageUtilsKt.convertUrlToPath(string);
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<Path> createSourceRootDirectory$lambda$15(Lazy<? extends List<? extends Path>> $contentEntryPaths$delegate) {
        Lazy<? extends List<? extends Path>> lazy = $contentEntryPaths$delegate;
        return (List)lazy.getValue();
    }

    private static final Unit createSourceRootDirectory$lambda$16(Path $srcFolderPath, Module $this_createSourceRootDirectory) {
        VfsUtil.createDirectoryIfMissing((String)((Object)$srcFolderPath.toAbsolutePath()).toString());
        Project project = $this_createSourceRootDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.NO_RESCAN_NEEDED;
        Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"NO_RESCAN_NEEDED");
        ProjectStructureUtils.invalidateProjectRoots(project, rootsChangeRescanningInfo);
        return Unit.INSTANCE;
    }

    private static final Path findOrCreateDirectoryForPackage$lambda$32$lambda$30(Project $project, List externalContentRoots) {
        Intrinsics.checkNotNullParameter((Object)externalContentRoots, (String)"externalContentRoots");
        ExternalSystemContentRootContributor.ExternalContentRoot externalContentRoot = ExternalContentRootChooser.Companion.choose($project, externalContentRoots);
        return externalContentRoot != null ? externalContentRoot.getPath() : null;
    }

    private static final String findOrCreateDirectoryForPackage$getLeftPart(String packageName) {
        String string;
        int index2 = StringsKt.indexOf$default((CharSequence)packageName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (index2 > -1) {
            String string2 = packageName.substring(0, index2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = packageName;
        }
        return string;
    }

    private static final String findOrCreateDirectoryForPackage$cutLeftPart(String packageName) {
        String string;
        int index2 = StringsKt.indexOf$default((CharSequence)packageName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (index2 > -1) {
            String string2 = packageName.substring(index2 + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    private static final PsiDirectory findOrCreateDirectoryForPackage$lambda$33(Ref.ObjectRef $psiDirectory, String $name) {
        return ((PsiDirectory)$psiDirectory.element).createSubdirectory($name);
    }

    static {
        Object[] objectArray = new KotlinSourceRootType[]{SourceKotlinRootType.INSTANCE, TestSourceKotlinRootType.INSTANCE};
        Set set = SetsKt.setOf((Object[])objectArray);
        Set set2 = JavaModuleSourceRootTypes.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"SOURCES");
        kotlinSourceRootTypes = SetsKt.plus((Set)set, (Iterable)set2);
    }
}

